/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.SystemPatchZip;
import oracle.glcm.opatch.common.api.SystemSubpatchInfo;
import oracle.glcm.opatch.common.impl.SystemSubpatchInfoImpl;
import oracle.glcm.opatch.common.impl.bundle.PatchTypes;
import oracle.glcm.opatch.common.impl.bundle.PatchingTools;
import oracle.glcm.opatch.common.impl.bundle.Subpatch;
import oracle.glcm.opatch.common.impl.dao.PatchBundleDAO;
import oracle.glcm.opatch.common.impl.dao.PatchCompositeDAO;
import oracle.glcm.opatch.common.impl.dao.PatchInventoryDAO;

public class SystemPatchZipImpl
implements SystemPatchZip {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private PatchBundleDAO pbdao = null;
    static String bundle = "bundle.xml";
    static String inventory = "inventory.xml";
    static String composite = "composite.xml";
    private HashMap<String, PatchInventoryDAO> mapInventories = new HashMap();
    private HashMap<String, PatchCompositeDAO> mapComposites = new HashMap();

    public SystemPatchZipImpl(InputStream is) throws IOException, PatchMetadataLoadingException {
        MyZipInputStream zis = new MyZipInputStream(is);
        ZipEntry zentry = zis.getNextEntry();
        while (zentry != null) {
            String name = zentry.getName();
            if (name.endsWith(bundle)) {
                this.pbdao = new PatchBundleDAO(zis);
            } else if (name.endsWith(inventory)) {
                PatchInventoryDAO pidao = new PatchInventoryDAO(zis);
                String patchid = pidao.getPatchId();
                if (patchid == null) {
                    this.logger.severe("Entry:" + name + " has no patchid");
                } else {
                    this.mapInventories.put(pidao.getPatchId(), pidao);
                }
            } else if (name.endsWith(composite)) {
                PatchCompositeDAO compdao = new PatchCompositeDAO(zis);
                this.mapComposites.put(compdao.getCompositePatchId(), compdao);
            }
            zentry = zis.getNextEntry();
        }
    }

    public HashMap<SystemSubpatchInfo, HashSet<String>> getFixedBugs() {
        HashMap<SystemSubpatchInfo, HashSet<String>> result = new HashMap<SystemSubpatchInfo, HashSet<String>>();
        List subpatches = this.pbdao.getBundleObj().getSubpatches().getSubpatch();
        for (Subpatch sp : subpatches) {
            SystemSubpatchInfoImpl sspi;
            PatchTypes type = sp.getPatchType();
            String patchID = sp.getPatchId();
            HashSet<String> bugSet = new HashSet<String>();
            if (type == null || sp.getPatchingTool() == null || !sp.getPatchingTool().equals((Object)PatchingTools.OPATCH)) continue;
            if (type.equals((Object)PatchTypes.SINGLETON)) {
                PatchInventoryDAO pidao = this.mapInventories.get(patchID);
                if (pidao != null) {
                    List<PatchInventory.Bug> bugList = pidao.getBugs();
                    for (PatchInventory.Bug bug : bugList) {
                        bugSet.add(bug.getNumber());
                    }
                } else {
                    this.logger.severe("Singleton " + sp.getLocation() + " has no matched/(or missed) patchid in inventory.xml ");
                }
            } else if (type.equals((Object)PatchTypes.COMPOSITE)) {
                List<String> subpatchIDs = this.mapComposites.get(patchID).getSubpatchIDs();
                for (String id : subpatchIDs) {
                    PatchInventoryDAO pidao = this.mapInventories.get(id);
                    if (pidao != null) {
                        List<PatchInventory.Bug> bugList = pidao.getBugs();
                        for (PatchInventory.Bug bug : bugList) {
                            bugSet.add(bug.getNumber());
                        }
                        continue;
                    }
                    this.logger.severe("Composite " + sp.getLocation() + " with subpatch" + id + " has no matched/(or missed) patchid in inventory.xml ");
                }
            } else {
                this.logger.severe("Subpatch " + sp.getLocation() + "has unknown target type" + type.name());
            }
            if (bugSet.isEmpty() || result.containsKey(sspi = new SystemSubpatchInfoImpl(sp))) continue;
            result.put(sspi, bugSet);
        }
        return result;
    }

    private class MyZipInputStream
    extends ZipInputStream {
        public MyZipInputStream(InputStream s) {
            super(s);
        }

        @Override
        public void close() throws IOException {
        }

        public void myclose() throws CloneNotSupportedException {
            super.clone();
        }
    }
}

