/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.alias.patch;

import java.util.Date;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.api.alias.patch.PatchRec;

public class PatchRecImpl
implements PatchRec {
    String upi;
    String id;
    String patchLocation;
    Date creationTime;
    Date applicationTime;

    private PatchRecImpl(Builder builder) throws MaintenanceAliasException {
        String upi = builder.upi;
        if (upi == null || upi.isEmpty()) {
            throw new MaintenanceAliasException("Can not convert an invalid value to patch upi");
        }
        this.upi = upi;
        this.id = builder.id;
        this.patchLocation = builder.patchLocation;
        this.creationTime = builder.creationTime;
        this.applicationTime = builder.applicationTime;
    }

    public String getUpi() {
        return this.upi;
    }

    public String getId() {
        return this.id;
    }

    public String getPatchLocation() {
        return this.patchLocation;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getApplicationTime() {
        return this.applicationTime;
    }

    public int hashCode() {
        return this.upi.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PatchRec) {
            PatchRec patch = (PatchRec)obj;
            return this.upi.equals(patch.getUpi());
        }
        return false;
    }

    public static class Builder
    implements PatchRec.Builder {
        String upi;
        String id;
        String patchLocation;
        Date creationTime;
        Date applicationTime;

        public Builder(String upi) {
            this.upi = upi;
        }

        public PatchRec.Builder setId(String id) {
            this.id = id;
            return this;
        }

        public PatchRec.Builder setPatchLocation(String patchLocation) {
            this.patchLocation = patchLocation;
            return this;
        }

        public PatchRec.Builder setCreationTime(Date creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public PatchRec.Builder setApplicationTime(Date applicationTime) {
            this.applicationTime = applicationTime;
            return this;
        }

        public PatchRec build() throws MaintenanceAliasException {
            return new PatchRecImpl(this);
        }
    }
}

