/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.dao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.PatchChecksum;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.PatchChecksumImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PatchChecksumDAO {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static String CHECKSUM_INFO = "checksum_info";
    private static String PATH = "path";
    private static String FILE = "file";
    private static String CHECKSUM = "checksum";
    private static String APP_DIR = "app_dir";
    private Document doc = null;

    public PatchChecksumDAO(String checksumFile) throws PatchMetadataLoadingException {
        this.logger.info("Enter PatchChecksumDAO constructor (file)...");
        try {
            Path fXmlFile = NioServiceFactory.getNioService().getPath(checksumFile, new String[0]);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            try (InputStream inputStream = Files.newInputStream(fXmlFile, new OpenOption[0]);){
                this.doc = dBuilder.parse(inputStream);
            }
            this.doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException pe) {
            throw new PatchMetadataLoadingException("Failed to configure xml parser for checksum.xml", (Throwable)pe);
        }
        catch (IOException ioe) {
            throw new PatchMetadataLoadingException("Failed to read checksum.xml file", (Throwable)ioe);
        }
        catch (SAXException se) {
            throw new PatchMetadataLoadingException("Failed to parse checksum.xml file", (Throwable)se);
        }
        this.logger.info("Done PatchChecksumDAO constructor (file)...");
    }

    public void save(String xmlFile) throws PatchMetadataWritingException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            try (OutputStream outputStream = Files.newOutputStream(NioServiceFactory.getNioService().getPath(xmlFile, new String[0]), new OpenOption[0]);){
                transformer.transform(new DOMSource(this.doc), new StreamResult(outputStream));
            }
        }
        catch (TransformerException te) {
            throw new PatchMetadataWritingException("Failed transformation while writing out checksum.xml file " + xmlFile, (Throwable)te);
        }
        catch (IOException fnfe) {
            throw new PatchMetadataWritingException("Failed to write to file checksum.xml file " + xmlFile, (Throwable)fnfe);
        }
    }

    public void saveToDir(String destinationPatchLoc) throws PatchMetadataWritingException {
        Path dir = NioServiceFactory.getNioService().getPath(destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR, new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PatchMetadataWritingException("Cannot create directory " + dir + " for cloning checksum.xml data", (Throwable)e);
            }
        }
        if (!Files.exists(dir, new LinkOption[0]) || Files.isRegularFile(dir, new LinkOption[0])) {
            throw new PatchMetadataWritingException("Cannot create directory " + destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR + " for cloning checksum.xml data");
        }
        String fileFullName = destinationPatchLoc + Constants.PATH + Constants.CHECKSUM_XML;
        this.save(fileFullName);
    }

    public List<PatchChecksum.File> getFiles() {
        ArrayList<PatchChecksum.File> result = new ArrayList<PatchChecksum.File>();
        NodeList topList = this.doc.getElementsByTagName(CHECKSUM_INFO);
        Element topElem = (Element)topList.item(0);
        NodeList nList = topElem.getElementsByTagName(FILE);
        PatchChecksumImpl csi = new PatchChecksumImpl();
        for (int i = 0; i < nList.getLength(); ++i) {
            if (nList.item(i).getNodeType() != 1) continue;
            Element elem = (Element)nList.item(i);
            String path = elem.getAttribute(PATH);
            String checksum = elem.getAttribute(CHECKSUM);
            String appDir = elem.getAttribute(APP_DIR);
            PatchChecksumImpl patchChecksumImpl = csi;
            Objects.requireNonNull(patchChecksumImpl);
            PatchChecksumImpl.FileImpl f = patchChecksumImpl.new PatchChecksumImpl.FileImpl(path, checksum, appDir);
            result.add(f);
        }
        return result;
    }
}

