/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.mgmt;

import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class DependencyManagementHelper {
    private static final Logger _log = Logger.getLogger(DependencyManagementHelper.class.getName());
    public static final String DEFAULT_SPACE_REPLACEMENT = "_";

    public static String convertSpaces(String s) {
        return DependencyManagementHelper.convertSpaces(s, DEFAULT_SPACE_REPLACEMENT);
    }

    public static String convertSpaces(String s, String replacement) {
        if (StringUtil.isNullOrEmpty((String)s)) {
            return s;
        }
        s = s.trim();
        return s.replace(" ", replacement);
    }

    public static Collection<Dependency> getGroupFilteredDependencies(Module module, String group) {
        return DependencyManagementHelper.getFilteredDependencies(module, group, null, null, null, new String[0]);
    }

    public static <T extends Artifact> Collection<T> getGroupFilteredArtifacts(Collection<T> artifacts, String group) {
        return DependencyManagementHelper.getFilteredArtifacts(artifacts, group, null, null, null, new String[0]);
    }

    public static Collection<Dependency> getFilteredDependencies(List<Module> modules, String group, String name, String baseVersion, String type, String classifier, String ... qualifiers) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (modules != null) {
            for (Module module : modules) {
                dependencies.addAll(DependencyManagementHelper.getFilteredDependencies(module, group, name, baseVersion, type, classifier, qualifiers));
            }
        }
        return dependencies;
    }

    public static Collection<Dependency> getFilteredDependencies(Module module, String group, String name, String baseVersion, String type, String ... qualifiers) {
        return DependencyManagementHelper.getFilteredDependencies(module, group, name, baseVersion, type, null, qualifiers);
    }

    public static Collection<Dependency> getFilteredDependencies(Module module, String group, String name, String baseVersion, String type, String classifier, String ... qualifiers) {
        return DependencyManagementHelper.getFilteredArtifacts(module != null ? module.getDependencies() : null, group, name, baseVersion, type, classifier, qualifiers);
    }

    public static <T extends Artifact> Collection<T> getFilteredArtifacts(Collection<T> artifacts, String group, String name, String baseVersion, String type, String ... qualifiers) {
        return DependencyManagementHelper.getFilteredArtifacts(artifacts, group, name, baseVersion, type, null, qualifiers);
    }

    public static <T extends Artifact> Collection<T> getFilteredArtifacts(Collection<T> artifacts, String group, String name, String baseVersion, String type, String classifier, String ... qualifiers) {
        ArrayList<Artifact> matched = new ArrayList<Artifact>();
        if (artifacts != null && !artifacts.isEmpty()) {
            group = group != null ? DependencyManagementHelper.convertSpaces(group) : null;
            name = name != null ? DependencyManagementHelper.convertSpaces(name) : null;
            for (Artifact artifact : artifacts) {
                if (!DependencyManagementHelper.artifactMatches(artifact, group, name, baseVersion, type, classifier, qualifiers)) continue;
                matched.add(artifact);
            }
        }
        return matched;
    }

    public static <T extends Artifact> boolean artifactMatches(T artifact, String group, String name, String baseVersion, String type, String ... qualifiers) {
        return DependencyManagementHelper.artifactMatches(artifact, group, name, baseVersion, type, null, qualifiers);
    }

    public static <T extends Artifact> boolean artifactMatches(T artifact, String group, String name, String baseVersion, String type, String classifier, String ... qualifiers) {
        return DependencyManagementHelper.artifactMatches(artifact, group, false, name, false, baseVersion, false, type, false, classifier, false, qualifiers, false);
    }

    public static <T extends Artifact> boolean artifactMatches(T artifact, String group, boolean groupRegex, String name, boolean nameRegex, String baseVersion, boolean baseVersionRegex, String type, boolean typeRegex, String classifier, boolean classifierRegex, String[] qualifiers, boolean qualifiersRegex) {
        if (!DependencyManagementHelper.valueMatches(artifact.getGroup(), group, groupRegex)) {
            return false;
        }
        if (!DependencyManagementHelper.valueMatches(artifact.getName(), name, nameRegex)) {
            return false;
        }
        if (!DependencyManagementHelper.valueMatches(artifact.getBaseVersion(), baseVersion, baseVersionRegex)) {
            return false;
        }
        if (!DependencyManagementHelper.valueMatches(artifact.getType(), type, typeRegex)) {
            return false;
        }
        if (!DependencyManagementHelper.valueMatches(artifact.getClassifier(), classifier, classifierRegex)) {
            return false;
        }
        if (qualifiers != null && qualifiers.length > 0) {
            for (int x = 1; x < qualifiers.length + 1; ++x) {
                if (DependencyManagementHelper.valueMatches(artifact.getQualifier(x), qualifiers[x - 1], qualifiersRegex)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean valueMatches(String value, String matchValue, boolean regex) {
        if (matchValue == null) {
            return true;
        }
        if (regex) {
            if (value != null) {
                return value.matches(matchValue);
            }
        } else {
            return matchValue.equals(value);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DependencyFileType detectDependencyFileType(File file) throws IOException {
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                if (line.contains("<ivy-module")) {
                    DependencyFileType dependencyFileType = DependencyFileType.ivy;
                    return dependencyFileType;
                }
                if (!line.contains("<project")) continue;
                DependencyFileType dependencyFileType = DependencyFileType.pom;
                return dependencyFileType;
            }
        }
        return null;
    }

    public static <T extends Artifact> List<Dependency> convertToDependencies(Collection<T> artifacts) {
        return DependencyManagementHelper.convertToDependencies(artifacts, false);
    }

    public static <T extends Artifact> List<Dependency> convertToDependencies(Collection<T> artifacts, boolean dependencyManagement) {
        return DependencyManagementHelper.convertToDependencies(artifacts, dependencyManagement, null);
    }

    public static <T extends Artifact> List<Dependency> convertToDependencies(Collection<T> artifacts, boolean dependencyManagement, String scope) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (artifacts != null && !artifacts.isEmpty()) {
            for (Artifact artifact : artifacts) {
                Dependency dependency;
                if (artifact instanceof Dependency) {
                    dependency = (Dependency)artifact;
                } else {
                    dependency = DependencyManagementFactory.getInstance().getDependency(artifact.getGroup(), artifact.getName(), artifact.getVersion(), artifact.getType());
                    String classifier = artifact.getClassifier();
                    if (classifier != null) {
                        dependency.setClassifier(classifier);
                    }
                }
                if (dependencyManagement) {
                    dependency.setDependencyManagement(true);
                }
                if (!StringUtil.isNullOrEmpty((String)scope, (boolean)true)) {
                    dependency.setScope(scope);
                }
                dependencies.add(dependency);
            }
        }
        return dependencies;
    }

    public static Module mergeModules(List<Module> modules, String group, String name, String version, String type) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Module m : modules) {
            List<Dependency> deps = m.getDependencies();
            if (deps == null || deps.isEmpty()) continue;
            for (Dependency dependency : deps) {
                if (dependencies.contains(dependency)) continue;
                dependencies.add(dependency);
            }
        }
        Module module = DependencyManagementFactory.getInstance().getModule(group, name, version, type);
        module.setDependencies(dependencies);
        return module;
    }

    public static Set<Artifact> getArtifacts(Repository repository) throws IOException, DependencyManagementException {
        if (!repository.getType().isCache()) {
            throw new DependencyManagementException("The specified repository was not a local cache repository.");
        }
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        File repoDir = repository.getCacheLocation();
        if (repoDir != null && repoDir.isDirectory()) {
            Set artifactFiles = IOUtil.getFiles((File)repoDir, (boolean)true, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        return true;
                    }
                    String[] split = pathname.getAbsolutePath().replace("\\", "/").split("/");
                    if (split.length < 3) {
                        return false;
                    }
                    String version = split[split.length - 2];
                    String name = split[split.length - 3];
                    String fileName = pathname.getName();
                    return fileName.startsWith(name + "-" + version) && !fileName.endsWith(".md5") && !fileName.endsWith(".sha1") && !fileName.endsWith(".lastUpdated") && !fileName.endsWith(".tmp");
                }
            });
            for (File artifactFile : artifactFiles) {
                Artifact artifact = DependencyManagementHelper.getArtifactFromPath(repoDir, artifactFile);
                if (artifact == null) continue;
                artifacts.add(artifact);
            }
        }
        return artifacts;
    }

    public static Artifact getArtifactFromPath(File repoDir, File artifactFile) throws DependencyManagementException {
        if (repoDir == null) {
            throw new DependencyManagementException("The repository directory provided was null.");
        }
        if (artifactFile == null) {
            throw new DependencyManagementException("The artifact file provided was null.");
        }
        String repoDirPath = repoDir.getAbsolutePath();
        String path = artifactFile.getAbsolutePath();
        if (!path.startsWith(repoDirPath)) {
            throw new IllegalArgumentException("The artifact file provided (" + artifactFile + ") was not under the specified repository directory (" + repoDir.getAbsolutePath() + ").");
        }
        return DependencyManagementHelper.getArtifactFromPath(path.substring(repoDirPath.length()));
    }

    public static Artifact getArtifactFromPath(String relativePath) throws DependencyManagementException {
        if (StringUtil.isNullOrEmpty((String)relativePath, (boolean)true)) {
            throw new DependencyManagementException("The path specified was null or empty.");
        }
        String path = relativePath.replace("\\", "/");
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (StringUtil.isNullOrEmpty((String)path, (boolean)true)) {
            throw new DependencyManagementException("The path specified was invalid " + relativePath);
        }
        String[] split = path.split("/");
        int extIndex = split[split.length - 1].lastIndexOf(".");
        String type = split[split.length - 1].substring(extIndex + 1);
        String version = split[split.length - 2];
        String name = split[split.length - 3];
        String group = null;
        for (int x = 0; x < split.length - 3; ++x) {
            group = group == null ? "" : group + ".";
            group = group + split[x];
        }
        Artifact artifact = DependencyManagementFactory.getInstance().getArtifact(group, name, version, type);
        String classifier = null;
        String artifactFileName = artifact.getFileName();
        if (!artifactFileName.equals(split[split.length - 1])) {
            artifactFileName = artifactFileName.substring(0, artifactFileName.lastIndexOf("."));
            if (split[split.length - 1].length() > artifactFileName.length()) {
                classifier = split[split.length - 1].substring(artifactFileName.length() + 1, extIndex);
            }
        }
        if (classifier != null) {
            artifact.setClassifier(classifier);
        }
        if (!artifact.getRepoPath().equals(path)) {
            _log.warning("Failed to accurately create artifact from path " + path + ", the resulting artifact [" + artifact + "] will be omitted.");
            return null;
        }
        return artifact;
    }

    public static Artifact publishArtifactPom(Artifact artifact, File publishRepoDir) throws DependencyManagementException, IOException, RestException {
        return DependencyManagementHelper.publishArtifactPom(artifact, RestFactory.getRepository(null, publishRepoDir.getAbsolutePath(), null, null));
    }

    public static Artifact publishArtifactPom(Artifact artifact, Repository publishRepo) throws DependencyManagementException, IOException, RestException {
        return DependencyManagementHelper.publishArtifactModule(artifact, publishRepo, DependencyFileType.pom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Artifact publishArtifactModule(Artifact artifact, Repository publishRepo, DependencyFileType type) throws DependencyManagementException, IOException, RestException {
        File moduleFile = null;
        try {
            Module module = DependencyManagementFactory.getInstance().getModule(artifact, type.name());
            Artifact moduleArtifact = module.getModuleArtifact();
            moduleFile = new File(System.getProperty("java.io.tmpdir"), moduleArtifact.getFileName());
            _log.fine("Creating " + (Object)((Object)type) + " module file in tmp dir " + moduleFile);
            DependencyManagementFactory.getInstance().getDependencyFileHandler(DependencyFileType.pom).writeDependenciesFile(module, moduleFile);
            _log.info("Publishing artifact module pom " + module + " to " + publishRepo);
            RestFactory.getRestHandler().deployArtifact(moduleArtifact, publishRepo, moduleFile);
            Artifact artifact2 = moduleArtifact;
            return artifact2;
        }
        finally {
            if (moduleFile != null && moduleFile.exists() && !moduleFile.delete()) {
                moduleFile.deleteOnExit();
            }
        }
    }
}

