/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.mgmt.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.LegalInformation;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.dependency.mgmt.impl.GroupNameVersionImpl;
import com.oracle.cie.dependency.mgmt.impl.LegalInformationImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ModuleImpl
extends GroupNameVersionImpl
implements Module {
    protected Module _parent;
    protected List<Artifact> _artifacts;
    protected List<Dependency> _dependencies;
    protected Properties _properties;
    protected Dependency _referencingDependency;
    protected LegalInformation _legalInfo;
    protected String _moduleType;
    protected boolean _packagingTypeSet;

    public ModuleImpl(String group, String name) {
        this(group, name, (Version)null);
    }

    public ModuleImpl(String group, String name, String version) {
        this(group, name, version, null);
    }

    public ModuleImpl(String group, String name, String version, String type) {
        this(group, name, version, type, (String[])null);
    }

    public ModuleImpl(String group, String name, String baseVersion, String type, String ... qualifiers) {
        this(group, name, baseVersion != null ? DependencyManagementFactory.getInstance().getVersion(baseVersion, qualifiers) : null, type);
    }

    public ModuleImpl(String group, String name, Version version) {
        this(group, name, version, null);
    }

    public ModuleImpl(String group, String name, String version, String type, LegalInformation legalInfo, String ... qualifiers) throws IllegalArgumentException {
        this(group, name, version, type, qualifiers);
        if (legalInfo != null) {
            this._legalInfo = legalInfo;
        }
    }

    public ModuleImpl(String group, String name, Version version, String type) {
        super(group, name, version, type);
        this._packagingTypeSet = !StringUtil.isNullOrEmpty((String)type, (boolean)true);
        this._moduleType = "xml";
    }

    @Override
    public Module getParent() {
        return this._parent;
    }

    @Override
    public void setParent(Module parent) {
        this._parent = parent;
    }

    @Override
    public boolean isVersionRequired() {
        return false;
    }

    @Override
    public Artifact getArtifact() {
        return this.createDefaultArtifact(this.getType());
    }

    @Override
    public Artifact getModuleArtifact() {
        return this.createDefaultArtifact(this.getModuleType());
    }

    @Override
    public void setVersion(Version version) {
        super.setVersion(version);
        List<Artifact> artifacts = this.getArtifacts();
        if (artifacts != null && !artifacts.isEmpty()) {
            for (Artifact artifact : artifacts) {
                artifact.setVersion(this.getVersion());
            }
        }
    }

    @Override
    public List<Artifact> getArtifacts() {
        return this._artifacts;
    }

    @Override
    public void setArtifacts(List<Artifact> artifacts) {
        if (artifacts != null) {
            this._artifacts = new ArrayList<Artifact>();
            for (Artifact artifact : artifacts) {
                Module parent = artifact.getParentModule();
                if (parent == null || !parent.equals(this)) {
                    artifact = artifact.getArtifactCopy();
                    artifact.setParentModule(this);
                }
                artifact.setVersion(this.getVersion());
                this._artifacts.add(artifact);
            }
        } else {
            this._artifacts = null;
        }
    }

    @Override
    public List<Dependency> getDependencies() {
        return this._dependencies;
    }

    @Override
    public void setDependencies(List<Dependency> dependencies) {
        this._dependencies = new ArrayList<Dependency>();
        if (dependencies != null && !dependencies.isEmpty()) {
            for (Dependency dependency : dependencies) {
                Module parent = dependency.getParentModule();
                if (parent == null) {
                    dependency.setParentModule(this);
                } else if (!parent.equals(this)) {
                    dependency = dependency.getDependencyCopy();
                    dependency.setParentModule(this);
                }
                this._dependencies.add(dependency);
            }
        }
    }

    @Override
    public boolean hasDependencies() {
        return this._dependencies != null && !this._dependencies.isEmpty();
    }

    @Override
    public Module getModuleCopy() {
        ModuleImpl module = new ModuleImpl(this.getGroup(), this.getName(), this.getVersion(), this.getType());
        if (this._artifacts != null) {
            module._artifacts = new ArrayList<Artifact>();
            for (Artifact artifact : this._artifacts) {
                module._artifacts.add(artifact);
            }
        }
        if (this._properties != null) {
            module._properties = new Properties();
            for (String propertyName : this._properties.stringPropertyNames()) {
                module._properties.setProperty(propertyName, this._properties.getProperty(propertyName));
            }
        }
        return module;
    }

    @Override
    public Properties getProperties() {
        return this._properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this._properties = properties;
    }

    @Override
    public Dependency getReferencingDependency() {
        return this._referencingDependency;
    }

    @Override
    public void setReferencingDependency(Dependency dependency) {
        this._referencingDependency = dependency;
    }

    @Override
    public Module getReferencingModule() {
        return this._referencingDependency != null ? this._referencingDependency.getParentModule() : null;
    }

    @Override
    public String getModuleType() {
        return this._moduleType;
    }

    @Override
    public void setModuleType(String type) {
        this._moduleType = type;
    }

    @Override
    public boolean isPackagingTypeSet() {
        return this._packagingTypeSet;
    }

    private Artifact createDefaultArtifact(String type) {
        Artifact artifact = DependencyManagementFactory.getInstance().getArtifact(this.getGroup(), this.getName(), this.getVersion(), type);
        artifact.setParentModule(this);
        return artifact;
    }

    @Override
    public LegalInformation getLegalInformation() {
        if (this._legalInfo == null) {
            this._legalInfo = new LegalInformationImpl();
        }
        return this._legalInfo;
    }

    @Override
    public void setLegalInformation(LegalInformation legalInfo) {
        this._legalInfo = legalInfo;
    }
}

