/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.remote;

import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommonConnectionHandlerImpl
implements RemoteConnectionHandler {
    private static final Logger _logger = Logger.getLogger(CommonConnectionHandlerImpl.class.getName());
    private RemoteConnectionHost _host;
    private Set<String> _deleteOnClose = new LinkedHashSet<String>();

    @Override
    public RemoteConnectionHost getHost() {
        return this._host;
    }

    @Override
    public void setHost(RemoteConnectionHost host) {
        this._host = host;
    }

    @Override
    public void put(String location, File sourceFile) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (sourceFile == null) {
            throw new RemoteConnectionException("The source file specified was null.");
        }
        this.put(location, sourceFile, false);
    }

    @Override
    public void putObject(String location, Object object) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (object == null) {
            throw new RemoteConnectionException("The object specified was null.");
        }
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        ByteArrayInputStream bais = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            bais = new ByteArrayInputStream(baos.toByteArray());
            this.put(location, bais);
        }
        catch (IOException e) {
            throw new RemoteConnectionException("Failed to store object at " + location + " on host " + this._host, e);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void get(String location, File destination) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (destination == null) {
            throw new RemoteConnectionException("The destination specified was null.");
        }
        this.get(location, destination, false);
    }

    @Override
    public Object getObject(String location) throws RemoteConnectionException {
        return this.getObject(location, null);
    }

    @Override
    public Object getObject(String location, final ClassLoader classLoader) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            baos = new ByteArrayOutputStream();
            this.get(location, baos);
            bais = new ByteArrayInputStream(baos.toByteArray());
            ois = new ObjectInputStream(bais){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    if (classLoader != null) {
                        String name = desc.getName();
                        try {
                            return Class.forName(name, false, classLoader);
                        }
                        catch (ClassNotFoundException ex) {
                            return super.resolveClass(desc);
                        }
                    }
                    return super.resolveClass(desc);
                }
            };
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            throw new RemoteConnectionException("Failed to get object from " + location + " on host " + this._host, e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void delete(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        this.delete(location, false, false);
    }

    @Override
    public void deleteOnClose(String location) {
        if (location != null) {
            this._deleteOnClose.add(location);
        }
    }

    @Override
    public String exec(String command) throws RemoteConnectionException {
        if (command == null || command.isEmpty()) {
            throw new RemoteConnectionException("The command specified was null or empty.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.exec(command, baos);
            String string = baos.toString();
            return string;
        }
        catch (RemoteConnectionException e) {
            throw new RemoteConnectionException(e.getMessage() + " Command output: " + baos.toString(), e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void exec(String command, OutputStream output) throws RemoteConnectionException {
        this.exec(command, output, null);
    }

    @Override
    public void close() {
        if (this._deleteOnClose != null && !this._deleteOnClose.isEmpty()) {
            for (String location : this._deleteOnClose) {
                try {
                    this.delete(location, true, true);
                }
                catch (RemoteConnectionException e) {
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.log(Level.FINEST, "Ignoring issue deleting location on close : " + location, e);
                }
            }
        }
        this.closeInternal();
    }

    protected abstract void closeInternal();
}

