/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.remote;

import com.oracle.cie.remote.CommonConnectionHandlerImpl;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.linux.SSHLinuxFileTransferHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.impl.DefaultSftpClientFactory;
import org.apache.sshd.sftp.common.SftpException;

public abstract class CommonSshConnectionHandlerImpl
extends CommonConnectionHandlerImpl {
    private static final Logger _logger = Logger.getLogger(CommonSshConnectionHandlerImpl.class.getName());
    protected SshClient _sshClient;
    protected ClientSession _clientSession;
    private SftpClient _sftpClient;
    private Boolean _windows;
    private boolean _cygwin;
    private boolean _mks;
    private static final int _readBufferSize = 131072;
    private static final String _noSuchFileMsg = "No such file";
    private boolean _disablePathConversions = Boolean.getBoolean("SshConnectionHandlerImpl.disable.path.conversions");
    private SSHLinuxFileTransferHandler _linuxFileHandler;

    @Override
    public String getFileHandlerType() {
        String transferType = "sftptransfer";
        if (this.getHost().getFileTransferType() != null) {
            transferType = this.getHost().getFileTransferType();
        }
        return transferType;
    }

    @Override
    public abstract String getType();

    @Override
    public abstract void connect() throws RemoteConnectionException;

    @Override
    public boolean isConnected() {
        _logger.log(Level.FINEST, "Is Connected:" + (this._clientSession != null ? this._clientSession.isOpen() : false));
        return this._clientSession != null && this._clientSession.isOpen();
    }

    @Override
    public void put(String location, File sourceFile, boolean resume) throws RemoteConnectionException {
        block18: {
            block17: {
                if (location == null) {
                    throw new RemoteConnectionException("The location specified was null.");
                }
                if (sourceFile == null) {
                    throw new RemoteConnectionException("The source file specified was null.");
                }
                if (this.getLinuxFileHandler() != null && resume) {
                    throw new RemoteConnectionException("Feature not supported");
                }
                if (!sourceFile.isDirectory()) break block17;
                this.mkdir(location);
                File[] files = sourceFile.listFiles();
                if (files == null) break block18;
                for (File f : files) {
                    String dest = location + "/" + f.getName();
                    this.put(dest, f);
                }
                break block18;
            }
            if (this.getLinuxFileHandler() != null) {
                try {
                    String command = this.getLinuxFileHandler().getFileTransferCommandToRemote(location, sourceFile);
                    String output = this.exec(command);
                    _logger.fine("Result of transfer command: " + output);
                }
                catch (UnknownHostException e) {
                    throw new RemoteConnectionException("UnknownHostException " + e.getMessage());
                }
            }
            FilterOutputStream os = null;
            try {
                os = new BufferedOutputStream(this.getSftpClient().write(this.getSftpLocation(location), new SftpClient.OpenMode[]{resume ? SftpClient.OpenMode.Append : SftpClient.OpenMode.Create, SftpClient.OpenMode.Write}));
                Files.copy(sourceFile.toPath(), os);
            }
            catch (IOException e) {
                throw new RemoteConnectionException("Failed to store content via sftp at " + location + " on host " + this.getHost() + " due to " + e.getMessage(), e);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        _logger.warning("Failed to close OutputStream for remote location " + location + " on host " + this.getHost() + " due to " + e.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public void put(String location, InputStream is) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (is == null) {
            throw new RemoteConnectionException("The input stream specified was null.");
        }
        if (this.getLinuxFileHandler() != null) {
            File tmpLoc = null;
            try {
                String tmp = System.getProperty("user.home") + File.separator + "remoteFile_" + UUID.randomUUID().toString();
                tmpLoc = new File(tmp);
                this.getLinuxFileHandler().writeInputStreamToFile(tmpLoc, is);
                this.put(location, tmpLoc);
            }
            catch (IOException e) {
                throw new RemoteConnectionException("Transfer to " + location + " failed due to " + e.getMessage());
            }
            finally {
                if (tmpLoc != null) {
                    tmpLoc.delete();
                }
            }
        }
        FilterOutputStream os = null;
        try {
            os = new BufferedOutputStream(this.getSftpClient().write(this.getSftpLocation(location)));
            IoUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new RemoteConnectionException("Failed to store content via sftp at " + location + " on host " + this.getHost() + " due to " + e.getMessage(), e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    _logger.warning("Failed to close OutputStream for remote location " + location + " on host " + this.getHost() + " due to " + e.getMessage());
                }
            }
        }
    }

    @Override
    public void get(String location, File destination, boolean resume) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (destination == null) {
            throw new RemoteConnectionException("The destination specified was null.");
        }
        this.get(location, null, destination, resume);
    }

    private void get(String location, SftpClient.Attributes attrs, File destination, boolean resume) throws RemoteConnectionException {
        try {
            boolean wildcard = false;
            String sftpLocation = this.getSftpLocation(location);
            if (attrs != null && attrs.isDirectory() || attrs == null && ((wildcard = this.isWildcard(location)) || this.getSftpClient().stat(sftpLocation).isDirectory())) {
                if (destination.exists()) {
                    if (!destination.isDirectory()) {
                        throw new RemoteConnectionException("The source location specified was a directory or wildcard however the local destination specified was not a directory.");
                    }
                } else if (!destination.mkdirs()) {
                    throw new RemoteConnectionException("Failed to create local directory " + destination);
                }
                Iterable list = this.getSftpClient().readDir(this.getSftpLocation(location));
                for (SftpClient.DirEntry entry : list) {
                    int index;
                    String fileName = entry.getFilename();
                    if (fileName.equals(".") || fileName.equals("..")) continue;
                    File destFile = new File(destination, fileName);
                    String srcLocation = location;
                    if (wildcard && (index = srcLocation.lastIndexOf("/")) > -1) {
                        srcLocation = srcLocation.substring(0, index);
                    }
                    srcLocation = srcLocation + "/" + fileName;
                    this.get(srcLocation, entry.getAttributes(), destFile, resume);
                }
            } else {
                this.getFile(location, destination, resume);
            }
        }
        catch (IOException e) {
            throw new RemoteConnectionException("Failed to get content via sftp from " + location + " on host " + this.getHost() + " due to " + e.getMessage(), e);
        }
    }

    private void getFile(String location, File destination, boolean resume) throws RemoteConnectionException {
        if (this.getLinuxFileHandler() != null && resume) {
            throw new RemoteConnectionException("Feature not supported");
        }
        File parent = destination.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new RemoteConnectionException("Failed to create parent directory of " + destination);
        }
        if (this.getLinuxFileHandler() != null) {
            try {
                String command = this.getLinuxFileHandler().getFileTransferCommandFromRemote(location, destination);
                String output = this.exec(command);
                _logger.fine("Result of copy command: " + output);
            }
            catch (UnknownHostException e) {
                throw new RemoteConnectionException("UnknownHostException " + e.getMessage());
            }
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(this.getSftpClient().read(this.getSftpLocation(location), 131072));
            Files.copy(is, destination.toPath(), resume ? null : StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RemoteConnectionException("Failed to get content via sftp from " + location + " on host " + this.getHost() + " due to " + e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    _logger.warning("Failed to close InputStream for remote location " + location + " on host " + this.getHost() + " due to " + e.getMessage());
                }
            }
        }
    }

    private boolean isWildcard(String location) {
        int index = location.lastIndexOf("/");
        String end = index > -1 ? location.substring(index) : location;
        return end.contains("?") || end.contains("*");
    }

    @Override
    public void get(String location, OutputStream os) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (os == null) {
            throw new RemoteConnectionException("The output stream specified was null.");
        }
        if (this.getLinuxFileHandler() != null) {
            File remotFileCopyInLocal = new File(System.getProperty("user.home") + File.separator + "remotFileCopyInLocal_" + UUID.randomUUID().toString());
            this.getFile(location, remotFileCopyInLocal, false);
            try {
                this.getLinuxFileHandler().readFileToOutputStream(remotFileCopyInLocal, os);
            }
            catch (IOException e) {
                throw new RemoteConnectionException("Retrieval of " + location + " failed due to " + e.getMessage());
            }
            finally {
                remotFileCopyInLocal.delete();
            }
        }
        BufferedInputStream is = null;
        try {
            String sftpLocation = this.getSftpLocation(location);
            is = new BufferedInputStream(this.getSftpClient().read(sftpLocation, 131072));
            IoUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new RemoteConnectionException("Failed to get content via sftp from " + location + " on host " + this.getHost() + " due to " + e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    _logger.warning("Failed to close InputStream for remote location " + location + " on host " + this.getHost() + " due to " + e.getMessage());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void delete(String location, boolean force, boolean ignoreFailure) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (force || this.getLinuxFileHandler() != null) {
            String command = "rm -rf \"" + location + "\"";
            if (this.getLinuxFileHandler() != null && !force) {
                command = "rm -r \"" + location + "\"";
            }
            try {
                this.exec(command);
                return;
            }
            catch (RemoteConnectionException e) {
                if (!ignoreFailure) throw e;
                if (!_logger.isLoggable(Level.FINEST)) return;
                _logger.log(Level.FINEST, "Ignored -- " + e.getMessage(), e);
                return;
            }
        }
        try {
            this.getSftpClient().remove(this.getSftpLocation(location));
            return;
        }
        catch (IOException e) {
            String message = "Failed to delete content via sftp from " + location + " on host " + this.getHost() + " due to " + e.getMessage();
            if (!ignoreFailure) throw new RemoteConnectionException(message, e);
            if (!_logger.isLoggable(Level.FINEST)) return;
            _logger.log(Level.FINEST, "Ignored -- " + message, e);
            return;
        }
    }

    @Override
    public boolean exists(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (this.getLinuxFileHandler() != null) {
            boolean exists = true;
            try {
                this.exec("ls " + location);
            }
            catch (RemoteConnectionException e) {
                exists = false;
            }
            return exists;
        }
        try {
            this.getSftpClient().stat(this.getSftpLocation(location));
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (SftpException e) {
            if (e.getMessage().equals(_noSuchFileMsg)) {
                return false;
            }
            throw new RemoteConnectionException("Failure occurred while trying to determine existence of " + location + " on host " + this.getHost() + " due to " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RemoteConnectionException("Failure occurred while trying to determine existence of " + location + " on host " + this.getHost() + " due to " + e.getMessage(), e);
        }
    }

    @Override
    public long size(String location) throws RemoteConnectionException {
        block5: {
            if (location == null) {
                throw new RemoteConnectionException("The location specified was null.");
            }
            if (this.getLinuxFileHandler() != null) {
                throw new RemoteConnectionException("Feature not supported");
            }
            try {
                SftpClient.Attributes attrs = this.getSftpClient().stat(this.getSftpLocation(location));
                if (attrs != null && !attrs.isDirectory()) {
                    return attrs.getSize();
                }
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block5;
                throw new RemoteConnectionException("Failure occurred while trying to determine the size of " + location + " on host " + this.getHost() + " due to " + e.getMessage(), e);
            }
        }
        return -1L;
    }

    @Override
    public boolean isDirectory(String location) throws RemoteConnectionException {
        block7: {
            if (location == null) {
                throw new RemoteConnectionException("The location specified was null.");
            }
            if (this.getLinuxFileHandler() != null) {
                boolean isDirectory = true;
                try {
                    this.exec("cd " + location);
                }
                catch (RemoteConnectionException e) {
                    isDirectory = false;
                }
                return isDirectory;
            }
            try {
                SftpClient.Attributes attrs = this.getSftpClient().stat(this.getSftpLocation(location));
                if (attrs != null && attrs.isDirectory()) {
                    return true;
                }
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block7;
                throw new RemoteConnectionException("Failure occurred while trying to determine if " + location + " is a directory on host " + this.getHost() + " due to " + e.getMessage(), e);
            }
        }
        return false;
    }

    @Override
    public void mkdir(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (this.getLinuxFileHandler() != null) {
            String output = this.exec(this.getLinuxFileHandler().getMakeDirCommand(location, false));
            _logger.fine("Result of make directory: " + output);
        } else {
            try {
                this.getSftpClient().mkdir(this.getSftpLocation(this.getSftpLocation(location)));
            }
            catch (IOException e) {
                throw new RemoteConnectionException("Failure occurred while trying to create the directory " + location + " on host " + this.getHost() + " due to " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void mkdirs(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (this.getLinuxFileHandler() != null) {
            String output = this.exec(this.getLinuxFileHandler().getMakeDirCommand(location, true));
            _logger.fine("Result of make directory: " + output);
        } else {
            int index = location.replace("\\", "/").lastIndexOf("/");
            if (index > -1) {
                String parentDir = location.substring(0, index);
                if (!this.exists(parentDir)) {
                    this.mkdirs(parentDir);
                }
                this.mkdir(location);
            }
        }
    }

    @Override
    public void exec(String command, OutputStream output, Map<String, String> envVars) throws RemoteConnectionException {
        if (command == null || command.isEmpty()) {
            throw new RemoteConnectionException("The command specified was null or empty.");
        }
        if (output == null) {
            throw new RemoteConnectionException("The output stream specified was null.");
        }
        this.connect();
        ChannelExec channel = null;
        try {
            channel = this._clientSession.createExecChannel(command);
            if (envVars != null) {
                for (Map.Entry<String, String> entry : envVars.entrySet()) {
                    channel.setEnv(entry.getKey(), (Object)entry.getValue());
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            channel.setErr((OutputStream)baos);
            channel.open().verify();
            InputStream in = channel.getInvertedOut();
            byte[] tmp = new byte[1024];
            while (true) {
                int i;
                if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                    output.write(tmp, 0, i);
                    continue;
                }
                if (channel.isClosed()) {
                    if (in.available() > 0) continue;
                    int exitStatus = channel.getExitStatus();
                    if (exitStatus == 0) break;
                    throw new RemoteConnectionException("Command execution of [" + command + "] failed due to " + baos.toString() + " with exit status " + exitStatus + ".");
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
            output.flush();
        }
        catch (RemoteConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteConnectionException("Failed to exec remote command [" + command + "]: " + e.getMessage(), e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    throw new RemoteConnectionException("Failed to close the channel for command [" + command + "]: " + e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void chmod(String location, int mode) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (this.getLinuxFileHandler() != null) {
            String output = this.exec(this.getLinuxFileHandler().getChmodCommand(location, mode));
            _logger.fine("Result of chmod directory: " + output);
        } else {
            try {
                SftpClient.Attributes attrs = this.getSftpClient().stat(this.getSftpLocation(location));
                attrs.setPermissions(Integer.parseInt(mode + "", 8));
                this.getSftpClient().setStat(this.getSftpLocation(location), attrs);
            }
            catch (IOException e) {
                throw new RemoteConnectionException("Failure occurred while trying to chmod the location " + location + " on host " + this.getHost() + " due to " + e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean isWindows() throws RemoteConnectionException {
        if (this._windows == null) {
            String force = System.getProperty("SshConnectionHandlerImpl.force.isWindows");
            if (force != null && force.length() > 0) {
                this._windows = Boolean.parseBoolean(force);
            } else {
                String execCommand = System.getProperty("SshConnectionHandlerImpl.isWindows.exec");
                if (execCommand != null && execCommand.length() > 0) {
                    try {
                        String output = this.exec(execCommand);
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("Exec of " + execCommand + " successful, assuming host " + this.getHost() + " is windows. Output: " + output);
                        }
                        this._windows = true;
                    }
                    catch (RemoteConnectionException e) {
                        _logger.warning("Exec of " + execCommand + " failed, assuming host " + this.getHost() + " is not windows.");
                        if (_logger.isLoggable(Level.FINER)) {
                            _logger.log(Level.FINER, "Exec of " + execCommand + " failed, assuming host " + this.getHost() + " is not windows.", e);
                        }
                        this._windows = false;
                    }
                } else {
                    try {
                        String output = this.exec("uname -s").toLowerCase();
                        this._windows = output.contains("windows") || output.contains("cygwin");
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("Exec of \"uname -s\" on host " + this.getHost() + " returned " + output + " isWindows=" + this._windows);
                        }
                    }
                    catch (RemoteConnectionException e) {
                        _logger.warning("Exec of \"uname -s\" failed, assuming host " + this.getHost() + " is not windows.");
                        if (_logger.isLoggable(Level.FINER)) {
                            _logger.log(Level.FINER, "Exec of \"uname -s\" failed, assuming host " + this.getHost() + " is not windows.", e);
                        }
                        this._windows = false;
                    }
                }
            }
            if (!this._disablePathConversions && this._windows.booleanValue()) {
                if (this.exists("/cygdrive")) {
                    this._cygwin = true;
                } else if (this.exists("/C=")) {
                    this._mks = true;
                }
            }
        }
        if (!this.isConnected()) {
            this.closeInternal();
            this.connect();
        }
        return this._windows;
    }

    @Override
    public List<String> ls(String location) throws RemoteConnectionException {
        if (location == null) {
            throw new RemoteConnectionException("The location specified was null.");
        }
        if (this.getLinuxFileHandler() != null) {
            String output = this.exec(this.getLinuxFileHandler().getLSCommand(location));
            return this.getLinuxFileHandler().getLSList(output);
        }
        ArrayList<String> listing = new ArrayList<String>();
        try {
            Iterable list = this.getSftpClient().readDir(this.getSftpLocation(location));
            for (SftpClient.DirEntry entry : list) {
                String fileName = entry.getFilename();
                if (fileName.equals(".") || fileName.equals("..")) continue;
                listing.add(fileName);
            }
        }
        catch (IOException e) {
            throw new RemoteConnectionException("Failure occurred while trying to list files in the location " + location + " on host " + this.getHost() + " due to " + e.getMessage(), e);
        }
        return listing;
    }

    @Override
    public void closeInternal() {
        if (this._sftpClient != null && this._sftpClient.isOpen()) {
            try {
                this._sftpClient.close();
            }
            catch (IOException e) {
                _logger.warning("Failure occured while trying to close the SFTP connection.");
            }
            this._sftpClient = null;
        }
        if (this.isConnected()) {
            try {
                this._clientSession.close();
            }
            catch (IOException e) {
                _logger.warning("Failure occured while trying to close the client session.");
            }
            this._clientSession = null;
        }
        if (this._sshClient != null && this._sshClient.isStarted()) {
            try {
                this._sshClient.close();
            }
            catch (IOException e) {
                _logger.warning("Failure occured while trying to close the SSH client.");
            }
        }
    }

    private SftpClient getSftpClient() throws RemoteConnectionException {
        this.connect();
        if (this._sftpClient == null || !this._sftpClient.isOpen()) {
            try {
                this._sftpClient = DefaultSftpClientFactory.INSTANCE.createSftpClient(this._clientSession);
            }
            catch (IOException e) {
                throw new RemoteConnectionException("Failed to open sftp channel. " + e.getMessage(), e);
            }
        }
        return this._sftpClient;
    }

    private String getSftpLocation(String location) throws RemoteConnectionException {
        if (!this._disablePathConversions && this.isWindows() && (this._cygwin || this._mks)) {
            String finalLocation = location.replace("\\", "/");
            if (finalLocation.startsWith("/")) {
                finalLocation = finalLocation.substring(1);
            }
            if (finalLocation.charAt(1) == ':') {
                if (this._cygwin) {
                    String path = "/cygdrive/" + finalLocation.substring(0, 1).toLowerCase() + "/" + finalLocation.substring(2);
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.finer("Converted path from " + location + " to " + path + " for cygwin environment.");
                    }
                    return path;
                }
                if (this._mks) {
                    String path = "/" + finalLocation.substring(0, 1) + "=" + finalLocation.substring(2);
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.finer("Converted path from " + location + " to " + path + " for mks environment.");
                    }
                    return path;
                }
            }
        }
        return location;
    }

    protected SSHLinuxFileTransferHandler getLinuxFileHandler() {
        if (this._linuxFileHandler == null && this.getFileHandlerType().equals("linuxtransfer")) {
            _logger.info("Using Linux file transfer handler");
            this._linuxFileHandler = new SSHLinuxFileTransferHandler();
        }
        return this._linuxFileHandler;
    }
}

