/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.oracle.cie.rest.json.JsonException;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class JsonProcessor {
    public static final String DISTRIBUTION_NAME = "DistributionName";
    public static final String DISTRIBUTION_VERSION = "DistributionVersion";
    public static final String INSTALL_TYPE = "InstallType";
    public static final String ORACLE_HOME = "OraHome";
    public static final String LOCAL_REPO = "LocalRepo";
    public static final String REPO_URL = "RepoURL";
    public static final String REPO_BASE_DIR = "RepoBaseDir";
    public static final String DECLINE_AUTO_UPDATES = "DeclineAutoUpdates";
    public static final String AUTO_UPDATES_LOCATION = "AutoUpdatesLocation";
    public static final String MOS_USERNAME = "MosUsername";
    public static final String MOS_PASSWORD = "MosPassword";
    public static final String LOG = "Log";
    public static final String LOG_LEVEL = "LogLevel";

    public static Properties getProperties(File jsonFile, Properties defaultProperties) throws JsonException {
        JsonFactory f = new JsonFactory();
        Properties props = new Properties();
        if (defaultProperties != null) {
            props = (Properties)defaultProperties.clone();
        }
        try {
            JsonParser jp = f.createJsonParser(jsonFile);
            jp.nextToken();
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                if (jp.getText().equals(DISTRIBUTION_NAME)) {
                    props.setProperty(DISTRIBUTION_NAME, jp.nextTextValue());
                    continue;
                }
                if (jp.getText().equals(DISTRIBUTION_VERSION)) {
                    props.setProperty(DISTRIBUTION_VERSION, jp.nextTextValue());
                    continue;
                }
                if (jp.getText().equals(INSTALL_TYPE)) {
                    props.setProperty(INSTALL_TYPE, jp.nextTextValue());
                    continue;
                }
                if (jp.getText().equals(ORACLE_HOME)) {
                    props.setProperty(ORACLE_HOME, jp.nextTextValue());
                    continue;
                }
                if (jp.getText().equals(LOCAL_REPO)) {
                    props.setProperty(LOCAL_REPO, jp.nextTextValue());
                    continue;
                }
                if (jp.getText().equals(REPO_URL)) {
                    props.setProperty(REPO_URL, jp.nextTextValue());
                    continue;
                }
                if (jp.getText().equals(REPO_BASE_DIR)) {
                    props.setProperty(REPO_BASE_DIR, jp.nextTextValue());
                    continue;
                }
                if (jp.getText().equals(DECLINE_AUTO_UPDATES)) {
                    props.setProperty(DECLINE_AUTO_UPDATES, jp.nextTextValue());
                    continue;
                }
                if (jp.getText().equals(AUTO_UPDATES_LOCATION)) {
                    props.setProperty(AUTO_UPDATES_LOCATION, jp.nextTextValue());
                    continue;
                }
                if (jp.getText().equals(MOS_USERNAME)) {
                    props.setProperty(MOS_USERNAME, jp.nextTextValue());
                    continue;
                }
                if (jp.getText().equals(MOS_PASSWORD)) {
                    props.setProperty(MOS_PASSWORD, jp.nextTextValue());
                    continue;
                }
                if (jp.getText().equals(LOG)) {
                    props.setProperty(LOG, jp.nextTextValue());
                    continue;
                }
                if (!jp.getText().equals(LOG_LEVEL)) continue;
                props.setProperty(LOG_LEVEL, jp.nextTextValue());
            }
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        return props;
    }
}

