/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.wadl.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.rest.BuildInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/vnd.org.jfrog.build.BuildInfo+json"})
public class BuildBuildInfo
implements MessageBodyReader<BuildInfo> {
    private static ObjectMapper mapper = new ObjectMapper();

    public boolean isReadable(Class arg, Type type, Annotation[] annotations, MediaType mediaType) {
        return "application".equalsIgnoreCase(mediaType.getType()) && "vnd.org.jfrog.build.BuildInfo+json".equalsIgnoreCase(mediaType.getSubtype());
    }

    public BuildInfo readFrom(Class arg, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.bufferedCopy((InputStream)inputStream, (OutputStream)baos);
        baos.close();
        return (BuildInfo)mapper.readValue(baos.toByteArray(), BuildInfoImpl.class);
    }

    public static class BuildInfoImpl
    extends HashMap
    implements BuildInfo {
        private String _uri;
        private Map<String, Object> _buildInfo;

        @Override
        public String getURI() {
            Object o;
            if (this._uri == null && (o = this.get("uri")) instanceof String) {
                this._uri = (String)o;
            }
            return this._uri;
        }

        @Override
        public Map<String, Object> getBuildInfo() {
            if (this._buildInfo == null) {
                Object o = this.get("buildInfo");
                this._buildInfo = (Map)o;
            }
            return this._buildInfo;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("uri:").append(this.getURI());
            buf.append(", buildInfo:").append(this.getBuildInfo());
            return buf.toString();
        }
    }
}

