/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.wadl.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.rest.Checksum;
import com.oracle.cie.rest.ItemCreated;
import com.oracle.cie.rest.wadl.provider.ChecksumImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/vnd.org.jfrog.artifactory.storage.ItemCreated+json"})
public class StorageItemCreated
implements MessageBodyReader<ItemCreated> {
    private static ObjectMapper mapper = new ObjectMapper();

    public boolean isReadable(Class arg, Type type, Annotation[] annotations, MediaType mediaType) {
        return "application".equalsIgnoreCase(mediaType.getType()) && "vnd.org.jfrog.artifactory.storage.ItemCreated+json".equalsIgnoreCase(mediaType.getSubtype());
    }

    public ItemCreated readFrom(Class arg, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.bufferedCopy((InputStream)inputStream, (OutputStream)baos);
        baos.close();
        ItemCreated itemCreated = (ItemCreated)mapper.readValue(baos.toByteArray(), ItemCreatedImpl.class);
        return itemCreated;
    }

    public static class ItemCreatedImpl
    extends HashMap
    implements ItemCreated {
        @Override
        public String getURI() {
            return (String)this.get("uri");
        }

        @Override
        public String getRepo() {
            return (String)this.get("repo");
        }

        @Override
        public long getSize() {
            Object o = this.get("size");
            if (o != null) {
                if (o instanceof Number) {
                    return ((Number)o).longValue();
                }
                String s = o.toString();
                if (!s.isEmpty()) {
                    return Long.parseLong(s);
                }
            }
            return 0L;
        }

        @Override
        public Checksum getChecksum() {
            return ChecksumImpl.parse(this);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("ItemCreated ");
            buf.append(", uri=[" + this.getURI() + "]");
            buf.append(", repo=[" + this.getRepo() + "]");
            buf.append(", size=[" + this.getSize() + " bytes]");
            buf.append(", " + this.getChecksum());
            return buf.toString();
        }
    }
}

