/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.nio;

import com.oracle.cie.common.util.crlf.CRLFException;
import com.oracle.cie.gdr.nio.NioCRLFFileFilter;
import com.oracle.cie.gdr.nio.NioFileEncodingHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NioFixCRLF {
    protected static final Logger s_logger = Logger.getLogger(NioFixCRLF.class.getName());
    private static final int UNDEF = -1;
    private static final int NOTJAVA = 0;
    private static final int LOOKING = 1;
    private static final int IN_CHAR_CONST = 2;
    private static final int IN_STR_CONST = 3;
    private static final int IN_SINGLE_COMMENT = 4;
    private static final int IN_MULTI_COMMENT = 5;
    private static final int ASIS = 0;
    private static final int CR = 1;
    private static final int LF = 2;
    private static final int CRLF = 3;
    private static final int ADD = 1;
    private static final int REMOVE = -1;
    private static final int SPACES = -1;
    private static final int TABS = 1;
    private static final int INBUFLEN = 8192;
    private static final int LINEBUFLEN = 200;
    private static final char CTRLZ = '\u001a';
    private int tablength = 8;
    private String spaces = "        ";
    private StringBuffer linebuf = new StringBuffer(1024);
    private StringBuffer linebuf2 = new StringBuffer(1024);
    private int eol;
    private String eolstr;
    private int ctrlz;
    private int tabs;
    private boolean javafiles = false;
    private Path srcDir;
    private Path destDir = null;
    private String wildcard = null;
    private boolean recurse = true;
    private ArrayList<Path> filesArray = new ArrayList();

    public NioFixCRLF(String srcDir, String destDir, String wildcard) {
        this.srcDir = NioHelper.getInstance().getPath(srcDir, new String[0]);
        this.destDir = NioHelper.getInstance().getPath(destDir, new String[0]);
        this.wildcard = wildcard;
        this.tabs = 0;
        if (System.getProperty("path.separator").equals(":")) {
            this.ctrlz = -1;
            if (System.getProperty("os.name").contains("Mac") && !System.getProperty("os.name").equals("Mac OS X")) {
                this.eol = 1;
                this.eolstr = "\r";
            } else {
                this.eol = 2;
                this.eolstr = "\n";
            }
        } else {
            this.ctrlz = 0;
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    public NioFixCRLF(String srcDir, String wildcard) {
        this.srcDir = NioHelper.getInstance().getPath(srcDir, new String[0]);
        this.tabs = 0;
        this.wildcard = wildcard;
        if (System.getProperty("path.separator").equals(":")) {
            this.ctrlz = -1;
            if (System.getProperty("os.name").contains("Mac") && !System.getProperty("os.name").equals("Mac OS X")) {
                this.eol = 1;
                this.eolstr = "\r";
            } else {
                this.eol = 2;
                this.eolstr = "\n";
            }
        } else {
            this.ctrlz = 0;
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    public NioFixCRLF() {
        this.tabs = 0;
        if (System.getProperty("path.separator").equals(":")) {
            this.ctrlz = -1;
            if (System.getProperty("os.name").contains("Mac") && !System.getProperty("os.name").equals("Mac OS X")) {
                this.eol = 1;
                this.eolstr = "\r";
            } else {
                this.eol = 2;
                this.eolstr = "\n";
            }
        } else {
            this.ctrlz = 0;
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    public void setSrcdir(Path srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestdir(Path destDir) {
        this.destDir = destDir;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public void setRecurse(String recurse) {
        this.recurse = !recurse.equalsIgnoreCase("false");
    }

    public void setJavafiles(boolean javafiles) {
        this.javafiles = javafiles;
    }

    public void setEol(String attr) {
        String option = attr;
        if (option.equals("asis")) {
            this.eol = 0;
        } else if (option.equals("cr")) {
            this.eol = 1;
            this.eolstr = "\r";
        } else if (option.equals("lf")) {
            this.eol = 2;
            this.eolstr = "\n";
        } else {
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    public void setTab(String attr) {
        String option = attr;
        this.tabs = option.equals("remove") ? -1 : (option.equals("asis") ? 0 : 1);
    }

    public void setTablength(int tlength) throws CRLFException {
        if (tlength < 2 || tlength > 80) {
            throw new CRLFException("tablength must be between 2 and 80");
        }
        this.tablength = tlength;
        StringBuffer sp = new StringBuffer();
        for (int i = 0; i < this.tablength; ++i) {
            sp.append(' ');
        }
        this.spaces = sp.toString();
    }

    public void setEof(String attr) {
        String option = attr;
        this.ctrlz = option.equals("remove") ? -1 : (option.equals("asis") ? 0 : 1);
    }

    public void execute() throws CRLFException {
        if (this.srcDir == null) {
            throw new CRLFException("srcdir attribute must be set!");
        }
        if (!Files.exists(this.srcDir, new LinkOption[0])) {
            throw new CRLFException("srcdir does not exist!");
        }
        if (!Files.isDirectory(this.srcDir, new LinkOption[0])) {
            throw new CRLFException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!Files.exists(this.destDir, new LinkOption[0])) {
                throw new CRLFException("destdir does not exist!");
            }
            if (!Files.isDirectory(this.destDir, new LinkOption[0])) {
                throw new CRLFException("destdir is not a directory!");
            }
        }
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("options: eol=" + (this.eol == 0 ? "asis" : (this.eol == 1 ? "cr" : (this.eol == 2 ? "lf" : "crlf"))) + " tab=" + (this.tabs == 1 ? "add" : (this.tabs == 0 ? "asis" : "remove")) + " eof=" + (this.ctrlz == 1 ? "add" : (this.ctrlz == 0 ? "asis" : "remove")) + " tablength=" + this.tablength + " wildcard=" + this.wildcard);
        }
        if (this.wildcard != null) {
            NioCRLFFileFilter filter = new NioCRLFFileFilter(this.wildcard, this.recurse);
            this.generateIncludedFiles(this.srcDir, filter);
        } else {
            this.generateIncludedFiles(this.srcDir, null);
        }
        Iterator<Path> fit = this.filesArray.iterator();
        while (fit.hasNext()) {
            this.processFile(fit.next().toString());
        }
    }

    private void generateIncludedFiles(Path srcDir, NioCRLFFileFilter filter) throws CRLFException {
        block10: {
            try {
                if (Files.isDirectory(srcDir, new LinkOption[0])) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(srcDir, filter);){
                        for (Path path : stream) {
                            this.generateIncludedFiles(path, filter);
                        }
                        break block10;
                    }
                }
                this.filesArray.add(srcDir);
            }
            catch (IOException e) {
                throw new CRLFException((Exception)e);
            }
        }
    }

    private Path createTempFile(Path parentDir) {
        String name = "fixcrlf" + new Random(System.currentTimeMillis()).nextLong();
        if (parentDir != null) {
            return parentDir.resolve(name);
        }
        if (this.destDir == null) {
            if (this.srcDir != null) {
                return this.srcDir.resolve(name);
            }
            return Paths.get(System.getProperty("java.io.tmpdir"), name);
        }
        return this.destDir.resolve(name);
    }

    /*
     * Exception decompiling
     */
    private boolean filesEqual(Path file1, Path file2) throws CRLFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 18[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processFile(String file) throws CRLFException {
        Path destFile;
        Path srcFile = NioHelper.getInstance().getPath(file, new String[0]);
        Path tmpFile = this.createTempFile(srcFile.getParent());
        OneLiner lines = new OneLiner(srcFile);
        this.process(lines, tmpFile, lines.getEncoding());
        Path path = destFile = this.destDir == null ? srcFile : this.destDir.resolve(srcFile.getFileName());
        if (Files.exists(destFile, new LinkOption[0])) {
            s_logger.fine("destFile exists");
            if (!this.filesEqual(destFile, tmpFile)) {
                s_logger.fine(destFile + " is being written");
                try {
                    Files.delete(destFile);
                }
                catch (IOException e) {
                    throw new CRLFException("Unable to delete " + destFile, (Exception)e);
                }
                try {
                    Files.move(tmpFile, destFile, new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new CRLFException("Failed to transform " + srcFile + " to " + destFile + ". Couldn't rename temporary file: " + tmpFile, (Exception)e);
                }
            }
            s_logger.fine(destFile + " is not written, as the contents are identical");
            try {
                Files.delete(tmpFile);
            }
            catch (IOException e) {
                throw new CRLFException("Unable to delete " + tmpFile, (Exception)e);
            }
        }
        s_logger.fine("destFile does not exist");
        try {
            Files.move(tmpFile, destFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new CRLFException("Failed to transform " + srcFile + " to " + destFile + ". Couldn't rename temporary file: " + tmpFile, (Exception)e);
        }
        if (tmpFile != null) {
            try {
                Files.delete(tmpFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void processStream(InputStream is, Path outputFile) throws CRLFException {
        this.processStream(is, outputFile, null);
    }

    public void processStream(InputStream is, Path outputFile, String encoding) throws CRLFException {
        this.process(new OneLiner(is, encoding), outputFile, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(OneLiner lines, Path outputFile, String encoding) throws CRLFException {
        String outEncoding = encoding == null ? lines.getEncoding() : encoding;
        try {
            BufferedWriter outWriter;
            try {
                outWriter = Files.newBufferedWriter(outputFile, outEncoding != null ? Charset.forName(outEncoding) : Charset.defaultCharset(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new CRLFException((Exception)e);
            }
            while (lines.hasMoreElements()) {
                OneLiner.BufferLine line;
                try {
                    line = (OneLiner.BufferLine)lines.nextElement();
                }
                catch (NoSuchElementException e) {
                    throw new CRLFException((Exception)e);
                }
                String lineString = line.getLineString();
                int linelen = line.length();
                if (this.tabs == 0) {
                    try {
                        outWriter.write(lineString);
                    }
                    catch (IOException e) {
                        throw new CRLFException((Exception)e);
                    }
                }
                while (line.getNext() < linelen) {
                    switch (lines.getState()) {
                        case 0: {
                            this.notInConstant(line, line.length(), outWriter);
                            break;
                        }
                        case 5: {
                            int endComment = lineString.indexOf("*/", line.getNext());
                            if (endComment >= 0) {
                                endComment += 2;
                                lines.setState(1);
                            } else {
                                endComment = linelen;
                            }
                            this.notInConstant(line, endComment, outWriter);
                            break;
                        }
                        case 4: {
                            this.notInConstant(line, line.length(), outWriter);
                            lines.setState(1);
                            break;
                        }
                        case 2: 
                        case 3: {
                            int begin = line.getNext();
                            char terminator = lines.getState() == 3 ? (char)'\"' : '\'';
                            this.endOfCharConst(line, terminator);
                            while (line.getNext() < line.getLookahead()) {
                                if (line.getNextCharInc() == '\t') {
                                    line.setColumn(line.getColumn() + this.tablength - line.getColumn() % this.tablength);
                                    continue;
                                }
                                line.incColumn();
                            }
                            try {
                                outWriter.write(line.substring(begin, line.getNext()));
                            }
                            catch (IOException e) {
                                throw new CRLFException((Exception)e);
                            }
                            lines.setState(1);
                            break;
                        }
                        case 1: {
                            this.nextStateChange(line);
                            this.notInConstant(line, line.getLookahead(), outWriter);
                        }
                    }
                }
                try {
                    outWriter.write(this.eolstr);
                }
                catch (IOException e) {
                    throw new CRLFException((Exception)e);
                }
            }
            try {
                if (this.ctrlz == 0) {
                    outWriter.write(lines.getEofStr());
                } else if (this.ctrlz == 1) {
                    outWriter.write(26);
                }
                outWriter.close();
            }
            catch (IOException e) {
                throw new CRLFException((Exception)e);
            }
            try {
                lines.close();
                lines = null;
            }
            catch (IOException e) {
                throw new CRLFException("Unable to close source stream");
            }
        }
        finally {
            try {
                if (lines != null) {
                    lines.close();
                }
            }
            catch (IOException io) {
                s_logger.severe("Error closing stream");
            }
        }
    }

    private void nextStateChange(OneLiner.BufferLine bufline) {
        int eol = bufline.length();
        int ptr = bufline.getNext();
        while (ptr < eol) {
            switch (bufline.getChar(ptr++)) {
                case '\'': {
                    bufline.setState(2);
                    bufline.setLookahead(--ptr);
                    return;
                }
                case '\"': {
                    bufline.setState(3);
                    bufline.setLookahead(--ptr);
                    return;
                }
                case '/': {
                    if (ptr >= eol) break;
                    if (bufline.getChar(ptr) == '*') {
                        bufline.setState(5);
                        bufline.setLookahead(--ptr);
                        return;
                    }
                    if (bufline.getChar(ptr) != '/') break;
                    bufline.setState(4);
                    bufline.setLookahead(--ptr);
                    return;
                }
            }
        }
        bufline.setLookahead(ptr);
    }

    private void endOfCharConst(OneLiner.BufferLine bufline, char terminator) throws CRLFException {
        int ptr = bufline.getNext();
        int eol = bufline.length();
        ++ptr;
        while (ptr < eol) {
            char c;
            if ((c = bufline.getChar(ptr++)) == '\\') {
                ++ptr;
                continue;
            }
            if (c != terminator) continue;
            bufline.setLookahead(ptr);
            return;
        }
        throw new CRLFException("endOfCharConst: unterminated char constant");
    }

    private void notInConstant(OneLiner.BufferLine bufline, int end, BufferedWriter outWriter) throws CRLFException {
        int nextTab;
        String line = bufline.substring(bufline.getNext(), end);
        int place = 0;
        int col = bufline.getColumn();
        this.linebuf.setLength(0);
        while ((nextTab = line.indexOf(9, place)) >= 0) {
            this.linebuf.append(line.substring(place, nextTab));
            int tabspaces = this.tablength - (col += nextTab - place) % this.tablength;
            this.linebuf.append(this.spaces.substring(0, tabspaces));
            col += tabspaces;
            place = nextTab + 1;
        }
        this.linebuf.append(line.substring(place, line.length()));
        String linestring = new String(this.linebuf.toString());
        if (this.tabs == -1) {
            try {
                outWriter.write(linestring);
            }
            catch (IOException e) {
                throw new CRLFException((Exception)e);
            }
        }
        this.linebuf2.setLength(0);
        place = 0;
        col = bufline.getColumn();
        int placediff = col - 0;
        int nextStop = col + (this.tablength - col % this.tablength);
        if (nextStop - col < 2) {
            this.linebuf2.append(linestring.substring(place, nextStop - placediff));
            place = nextStop - placediff;
            nextStop += this.tablength;
        }
        while (nextStop - placediff <= linestring.length()) {
            int tabCol = nextStop;
            while (--tabCol - placediff >= place && linestring.charAt(tabCol - placediff) == ' ') {
            }
            if (nextStop - tabCol > 2) {
                this.linebuf2.append(linestring.substring(place, ++tabCol - placediff));
                this.linebuf2.append('\t');
            } else {
                this.linebuf2.append(linestring.substring(place, nextStop - placediff));
            }
            place = nextStop - placediff;
            nextStop += this.tablength;
        }
        this.linebuf2.append(linestring.substring(place, linestring.length()));
        try {
            outWriter.write(this.linebuf2.toString());
        }
        catch (IOException e) {
            throw new CRLFException((Exception)e);
        }
        bufline.setColumn(bufline.getColumn() + linestring.length());
        bufline.setNext(end);
    }

    class OneLiner
    implements Enumeration {
        private int state;
        private StringBuffer eolStr;
        private StringBuffer eofStr;
        private BufferedReader reader;
        private StringBuffer line;
        private boolean reachedEof;
        private String encoding;

        public OneLiner(Path srcFile) throws CRLFException {
            this.state = NioFixCRLF.this.javafiles ? 1 : 0;
            this.eolStr = new StringBuffer(200);
            this.eofStr = new StringBuffer();
            this.reader = null;
            this.reachedEof = false;
            this.encoding = null;
            try {
                try {
                    this.encoding = NioFileEncodingHelper.detect(srcFile, 1, false);
                }
                catch (IOException ioe) {
                    s_logger.log(Level.FINE, "A problem was encountered during encoding detection, the default will be used...", ioe);
                    this.encoding = null;
                }
                if (this.encoding != null) {
                    try {
                        this.reader = Files.newBufferedReader(srcFile, Charset.forName(this.encoding));
                    }
                    catch (UnsupportedEncodingException uee) {
                        s_logger.log(Level.FINE, "Unsupported encoding detected:" + this.encoding + ", the default will be used...", uee);
                    }
                }
                if (this.reader == null) {
                    this.reader = Files.newBufferedReader(srcFile, Charset.defaultCharset());
                }
                this.nextLine();
            }
            catch (IOException e) {
                throw new CRLFException((Exception)e);
            }
        }

        public OneLiner(InputStream is) throws CRLFException {
            this(is, null);
        }

        public OneLiner(InputStream is, String streamenc) throws CRLFException {
            this.state = NioFixCRLF.this.javafiles ? 1 : 0;
            this.eolStr = new StringBuffer(200);
            this.eofStr = new StringBuffer();
            this.reader = null;
            this.reachedEof = false;
            this.encoding = null;
            try {
                this.encoding = streamenc;
                this.reader = this.encoding != null ? new BufferedReader(new InputStreamReader(is, this.encoding), 8192) : new BufferedReader(new InputStreamReader(is), 8192);
                this.nextLine();
            }
            catch (IOException e) {
                throw new CRLFException((Exception)e);
            }
        }

        public String getEncoding() {
            return this.encoding;
        }

        protected void nextLine() throws CRLFException {
            int ch = -1;
            int eolcount = 0;
            this.eolStr = new StringBuffer();
            this.line = new StringBuffer();
            try {
                ch = this.reader.read();
                while (ch != -1 && ch != 13 && ch != 10) {
                    this.line.append((char)ch);
                    ch = this.reader.read();
                }
                if (ch == -1 && this.line.length() == 0) {
                    this.reachedEof = true;
                    return;
                }
                block1 : switch ((char)ch) {
                    case '\r': {
                        ++eolcount;
                        this.eolStr.append('\r');
                        this.reader.mark(2);
                        ch = this.reader.read();
                        switch (ch) {
                            case 13: {
                                ch = this.reader.read();
                                if ((char)ch == '\n') {
                                    eolcount += 2;
                                    this.eolStr.append("\r\n");
                                    break block1;
                                }
                                this.reader.reset();
                                break block1;
                            }
                            case 10: {
                                ++eolcount;
                                this.eolStr.append('\n');
                                break block1;
                            }
                            case -1: {
                                break block1;
                            }
                        }
                        this.reader.reset();
                        break;
                    }
                    case '\n': {
                        ++eolcount;
                        this.eolStr.append('\n');
                    }
                }
                if (eolcount == 0) {
                    int i = this.line.length();
                    while (--i >= 0 && this.line.charAt(i) == '\u001a') {
                    }
                    if (i < this.line.length() - 1) {
                        this.eofStr.append(this.line.toString().substring(i + 1));
                        if (i < 0) {
                            this.line.setLength(0);
                            this.reachedEof = true;
                        } else {
                            this.line.setLength(i + 1);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new CRLFException((Exception)e);
            }
        }

        public String getEofStr() {
            return this.eofStr.toString();
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        @Override
        public boolean hasMoreElements() {
            return !this.reachedEof;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("OneLiner");
            }
            BufferLine tmpLine = new BufferLine(this.line.toString(), this.eolStr.toString());
            try {
                this.nextLine();
            }
            catch (CRLFException e) {
                throw new NoSuchElementException("OneLiner");
            }
            return tmpLine;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        class BufferLine {
            private int next = 0;
            private int column = 0;
            private int lookahead = -1;
            private String line;
            private String eolStr;

            public BufferLine(String line, String eolStr) {
                this.line = line;
                this.eolStr = eolStr;
            }

            public int getNext() {
                return this.next;
            }

            public void setNext(int next) {
                this.next = next;
            }

            public int getLookahead() {
                return this.lookahead;
            }

            public void setLookahead(int lookahead) {
                this.lookahead = lookahead;
            }

            public char getChar(int i) {
                return this.line.charAt(i);
            }

            public char getNextChar() {
                return this.getChar(this.next);
            }

            public char getNextCharInc() {
                return this.getChar(this.next++);
            }

            public int getColumn() {
                return this.column;
            }

            public void setColumn(int col) {
                this.column = col;
            }

            public int incColumn() {
                return this.column++;
            }

            public int length() {
                return this.line.length();
            }

            public int getEolLength() {
                return this.eolStr.length();
            }

            public String getLineString() {
                return this.line;
            }

            public String getEol() {
                return this.eolStr;
            }

            public String substring(int begin) {
                return this.line.substring(begin);
            }

            public String substring(int begin, int end) {
                return this.line.substring(begin, end);
            }

            public void setState(int state) {
                OneLiner.this.setState(state);
            }

            public int getState() {
                return OneLiner.this.getState();
            }
        }
    }
}

