/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.ini;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.nextgen.common.ini.IniComment;
import com.oracle.cie.nextgen.common.ini.IniIterator;
import com.oracle.cie.nextgen.common.ini.IniObject;
import com.oracle.cie.nextgen.common.ini.IniPair;
import com.oracle.cie.nextgen.common.ini.IniParsingException;
import com.oracle.cie.nextgen.common.ini.IniRawText;
import com.oracle.cie.nextgen.common.ini.IniSection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Vector;
import java.util.logging.Logger;

public class IniFile {
    private static Logger _logger = Logger.getLogger(IniFile.class.getName());
    public static final String LS = System.getProperty("line.separator");
    public static final String DEFAULT_SECTION = "DEFAULT_SECTION";
    public static final String GENERAL_SECTION = "General";
    public static final String SESSION_SECTION = "SESSION";
    public static final String INCLUDE_SECTION = "INCLUDE";
    public static final String INCLUDE_KEY = "INCLUDE";
    public static final String RESPONSEFILE_VERSION_KEY = "RESPONSEFILE_VERSION";
    public static final String S_RSP_VERSION = "1.7.0";
    public static final String S_RSP_VERSION_2_2_1 = "2.2.1.0.0";
    private static final String DELIM = ",";
    private static final String LEFT_CURLY = "{";
    private static final String RIGHT_CURLY = "}";
    private Vector<IniObject> m_Contents = new Vector();
    private boolean m_bPreserveFormat = false;
    private static final int SECTION = 1;
    private static final int COMMENT = 2;
    private static final int RAW_TEXT = 3;
    private static final int VARIABLE = 4;
    private Path m_sFileName;
    private static String COMMENT_CHAR = "#";
    private static char EQUAL_CHAR = (char)61;
    private Vector<String> m_vIncludeFiles = null;
    private String m_rspVersion = null;

    public IniFile(String fileName) {
        this(fileName, false);
    }

    public IniFile(File fileName) {
        this(NioHelper.getInstance().getPath(fileName));
    }

    public IniFile(Path fileName) {
        this(fileName, false);
    }

    public IniFile(String fileName, boolean bPreserveFormat) {
        this(new File(fileName), bPreserveFormat);
    }

    public IniFile(File fileName, boolean bPreserveFormat) {
        this(NioHelper.getInstance().getPath(fileName), bPreserveFormat);
    }

    public IniFile(Path fileName, boolean bPreserveFormat) {
        this.m_sFileName = fileName;
        this.m_bPreserveFormat = bPreserveFormat;
    }

    public Vector<String> getIncludeFiles() {
        return this.m_vIncludeFiles;
    }

    public void setHeader(String sHeader) {
        int i;
        if (this.m_Contents == null || this.m_Contents.isEmpty()) {
            try {
                this.m_bPreserveFormat = true;
                this.readIniFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int firstSectionIdx = 0;
        for (i = 0; i < this.m_Contents.size(); ++i) {
            IniObject item = this.m_Contents.elementAt(i);
            if (!(item instanceof IniSection)) continue;
            firstSectionIdx = i;
            break;
        }
        for (i = 0; i < firstSectionIdx; ++i) {
            this.m_Contents.removeElementAt(0);
        }
        this.m_Contents.insertElementAt(new IniComment(sHeader), 0);
    }

    public String getHeader() {
        Object item;
        if (this.m_Contents == null || this.m_Contents.isEmpty()) {
            try {
                this.m_bPreserveFormat = true;
                this.readIniFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String sHeader = "";
        IniIterator iterator = this.getIterator(false);
        while (iterator.hasMoreItems() && !((item = iterator.nextItem()) instanceof IniSection)) {
            sHeader = sHeader + item.toString();
            sHeader = sHeader + LS;
        }
        return sHeader;
    }

    public String getRSPVersion() {
        return this.m_rspVersion;
    }

    public Vector<String> getVarsInSection(String sectionName) {
        IniSection section = this.getSection(sectionName);
        if (section == null) {
            return null;
        }
        Vector<String> varNames = new Vector<String>();
        IniIterator iterator = section.getIterator(true);
        while (iterator.hasMoreItems()) {
            IniPair pair = (IniPair)iterator.nextItem();
            varNames.addElement(pair.getName());
        }
        return varNames;
    }

    public String getProfileString(String sectionName, String variable, String defValue) throws IOException {
        IniPair pair;
        if (this.m_Contents == null || this.m_Contents.isEmpty()) {
            this.m_bPreserveFormat = true;
            this.readIniFile();
        }
        if ((pair = this.getPair(sectionName, variable)) == null) {
            return defValue;
        }
        return pair.getValue();
    }

    public String[] getProfileStringList(String section, String var, String[] defs) throws IOException {
        IniPair pair;
        if (this.m_Contents == null || this.m_Contents.isEmpty()) {
            this.m_bPreserveFormat = true;
            this.readIniFile();
        }
        if ((pair = this.getPair(section, var)) == null) {
            return defs;
        }
        String value = pair.getValue();
        return this.extractStringList(value);
    }

    public String[] extractStringList(String value) {
        if (value == null) {
            return null;
        }
        if (!(value = value.trim()).startsWith(LEFT_CURLY) || !value.endsWith(RIGHT_CURLY)) {
            return null;
        }
        value = value.substring(1, value.length() - 1);
        String[] arr = value.split(DELIM);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = arr[i].trim();
            if (arr[i].startsWith("\"") && arr[i].endsWith("\"")) {
                arr[i] = arr[i].substring(1, arr[i].length() - 1);
                continue;
            }
            if (!arr[i].startsWith("\"") || arr[i].endsWith("\"")) continue;
            return null;
        }
        return arr;
    }

    public void setProfileString(String sectionName, String variable, String value) {
        IniPair pair;
        if (this.m_Contents == null || this.m_Contents.isEmpty()) {
            try {
                this.m_bPreserveFormat = true;
                this.readIniFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((pair = this.getPair(sectionName, variable)) != null) {
            pair.setValue(value);
        } else {
            try {
                this.addPair(sectionName, variable, value);
            }
            catch (IniParsingException e) {
                _logger.warning(StringUtil.getStackTrace((Throwable)e));
            }
        }
    }

    public void setRSPVersion(String version) {
        this.m_rspVersion = version;
    }

    public void setProfileString(String sectionName, String variable, String value, String sDesc) {
        this.setProfileString(sectionName, variable, value);
        IniSection section = this.getSection(sectionName);
        if (sDesc != null && sDesc.length() != 0) {
            section.setPairDesc(variable, sDesc);
        }
    }

    public void writeFile() throws IOException {
        this.writeFileTo(this.m_sFileName);
    }

    public void writeFileTo(String sFullPath) throws IOException {
        this.writeFileTo(new File(sFullPath));
    }

    public void writeFileTo(File dest) throws IOException {
        this.writeFileTo(NioHelper.getInstance().getPath(dest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFileTo(Path dest) throws IOException {
        OutputStream outStream = null;
        OutputStreamWriter outWriter = null;
        BufferedWriter writer = null;
        try {
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            outStream = Files.newOutputStream(dest, new OpenOption[0]);
            outWriter = new OutputStreamWriter(outStream);
            writer = new BufferedWriter(outWriter);
            IniIterator iterator = this.getIterator(false);
            while (iterator.hasMoreItems()) {
                IniObject item = (IniObject)iterator.nextItem();
                item.write(writer);
                writer.write(LS);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (outWriter != null) {
                outWriter.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    public void writeIniFile() throws IOException {
        this.writeFile();
    }

    public void addItem(IniObject item) {
        if (item instanceof IniPair) {
            throw new IllegalArgumentException("Not a valid INI item");
        }
        this.m_Contents.addElement(item);
    }

    public IniSection addSection(String sName) {
        IniSection section = this.getSection(sName);
        if (section == null) {
            section = new IniSection(sName);
            this.m_Contents.addElement(section);
        }
        return section;
    }

    public IniSection getSection(String sName) {
        IniIterator iterator = this.getIterator(true);
        while (iterator.hasMoreItems()) {
            IniSection section = (IniSection)iterator.nextItem();
            if (!section.getName().equalsIgnoreCase(sName)) continue;
            return section;
        }
        return null;
    }

    public void addPair(String sSection, String sName, String sValue) throws IniParsingException {
        IniSection section = this.getSection(sSection);
        if (section == null) {
            section = this.addSection(sSection);
        }
        section.addItem(new IniPair(sName, sValue, true));
    }

    public IniPair getPair(String sSection, String sName) {
        IniSection section = this.getSection(sSection);
        if (section == null) {
            return null;
        }
        return section.getPair(sName);
    }

    public String getValue(String sSection, String sName) {
        String sValue = null;
        IniPair pair = this.getPair(sSection, sName);
        if (pair != null) {
            sValue = pair.getValue();
        }
        return sValue;
    }

    public void readFile() throws IOException, IniParsingException {
        String[] includes;
        String currentLine;
        this.m_Contents = new Vector();
        int currentContext = -1;
        IniComment currentComment = null;
        IniRawText currentRawText = null;
        IniPair currentPair = null;
        int lineNumber = 0;
        String sectionName = DEFAULT_SECTION;
        IniSection currentSection = new IniSection(sectionName, lineNumber);
        this.addItem(currentSection);
        IniSection defaultSection = currentSection;
        lineNumber = 0;
        InputStream fis = null;
        try {
            fis = Files.newInputStream(this.m_sFileName, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
        while ((currentLine = reader.readLine()) != null) {
            ++lineNumber;
            String currentLineCopy = currentLine;
            if ((currentLine = currentLine.trim()).startsWith("[") && currentLine.endsWith("]")) {
                sectionName = currentLine.substring(1, currentLine.length() - 1);
                if (sectionName.equals(DEFAULT_SECTION)) continue;
                currentSection = new IniSection(sectionName, lineNumber);
                this.addItem(currentSection);
                currentContext = 1;
                continue;
            }
            if (currentLine.startsWith(COMMENT_CHAR)) {
                if (!this.m_bPreserveFormat) {
                    currentContext = 2;
                    continue;
                }
                if (currentContext == 2 && currentComment != null) {
                    currentComment.addLine(currentLine);
                    continue;
                }
                currentComment = new IniComment(currentLine, lineNumber);
                if (currentSection != null) {
                    currentSection.addItem(currentComment);
                } else {
                    this.addItem(currentComment);
                }
                currentContext = 2;
                continue;
            }
            if (currentContext == 4 && currentPair != null && !currentPair.isValueFinal()) {
                currentPair.addValueLine(currentLineCopy);
                continue;
            }
            if (currentLine.indexOf(EQUAL_CHAR) != -1) {
                int idx = currentLine.indexOf(EQUAL_CHAR);
                String sLHSName = currentLine.substring(0, idx);
                String sRHSValue = currentLine.substring(idx + 1);
                if (currentSection != null) {
                    currentPair = new IniPair(sLHSName, sRHSValue, this.m_bPreserveFormat, lineNumber);
                    currentSection.addItem(currentPair);
                }
                currentContext = 4;
                continue;
            }
            if (!this.m_bPreserveFormat) {
                currentContext = 3;
                continue;
            }
            if (currentContext == 3 && currentRawText != null) {
                currentRawText.addLine(currentLine);
                continue;
            }
            currentRawText = new IniRawText(currentLine, lineNumber);
            if (currentSection != null) {
                currentSection.addItem(currentRawText);
            } else {
                this.addItem(currentRawText);
            }
            currentContext = 3;
        }
        IniSection section = this.getSection(GENERAL_SECTION);
        if (section == null) {
            section = this.getSection(DEFAULT_SECTION);
        }
        String key = RESPONSEFILE_VERSION_KEY;
        String val = null;
        if (section != null) {
            val = this.getValue(section.getName(), key);
        }
        if (val != null) {
            this.setRSPVersion(val);
        }
        key = "INCLUDE";
        val = defaultSection.getValue("INCLUDE");
        if (val != null && (includes = this.extractStringList(key)) != null) {
            for (String inc : includes) {
                this.m_vIncludeFiles.add(inc);
            }
        }
        reader.close();
        fis.close();
    }

    private void readIniFile() throws IOException {
        try {
            this.readFile();
        }
        catch (IniParsingException e) {
            _logger.warning(e.getMessage());
        }
    }

    public IniIterator getIterator(boolean bSectionsOnly) {
        return new IniFileIterator(bSectionsOnly);
    }

    class IniFileIterator
    implements IniIterator {
        private int m_nCurrent = 0;
        private boolean m_bSectionsOnly;

        public IniFileIterator(boolean bSectionsOnly) {
            this.m_bSectionsOnly = bSectionsOnly;
        }

        @Override
        public Object nextItem() {
            return IniFile.this.m_Contents.elementAt(this.m_nCurrent++);
        }

        @Override
        public boolean hasMoreItems() {
            if (!this.m_bSectionsOnly) {
                return this.m_nCurrent < IniFile.this.m_Contents.size();
            }
            while (this.m_nCurrent < IniFile.this.m_Contents.size()) {
                Object item = IniFile.this.m_Contents.elementAt(this.m_nCurrent);
                if (item instanceof IniSection) {
                    return true;
                }
                ++this.m_nCurrent;
            }
            return false;
        }

        @Override
        public void insertBefore(Object item) {
            if (!(item instanceof IniObject)) {
                throw new IllegalArgumentException("Not a valid INI element");
            }
            if (this.m_nCurrent == 0) {
                IniFile.this.m_Contents.insertElementAt((IniObject)item, 0);
            } else {
                IniFile.this.m_Contents.insertElementAt((IniObject)item, this.m_nCurrent - 1);
            }
            ++this.m_nCurrent;
        }

        @Override
        public void insertAfter(Object item) {
            if (!(item instanceof IniObject)) {
                throw new IllegalArgumentException("Not a valid section element");
            }
            IniFile.this.m_Contents.insertElementAt((IniObject)item, this.m_nCurrent);
        }

        @Override
        public void remove() {
            IniFile.this.m_Contents.removeElementAt(this.m_nCurrent - 1);
        }
    }
}

