/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.ini;

import com.oracle.cie.nextgen.common.ini.IniComment;
import com.oracle.cie.nextgen.common.ini.IniIterator;
import com.oracle.cie.nextgen.common.ini.IniObject;
import com.oracle.cie.nextgen.common.ini.IniPair;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import java.util.logging.Logger;

public class IniSection
extends IniObject {
    private static final Logger _logger = Logger.getLogger(IniObject.class.getName());
    private String m_sName;
    private Vector<IniObject> m_Contents;

    public IniSection(String name) {
        this(name, 0);
    }

    public IniSection(String name, int lineNumber) {
        this.m_sName = name;
        this.setStartLineNumber(lineNumber);
        this.m_Contents = new Vector(10, 10);
    }

    public void addItem(IniObject item) {
        if (item instanceof IniSection) {
            _logger.finer("Ini section declared within another section at line " + item.getStartLineNumber());
            return;
        }
        this.m_Contents.addElement(item);
    }

    public IniPair getPair(String sName) {
        IniIterator iterator = this.getIterator(true);
        while (iterator.hasMoreItems()) {
            IniPair pair = (IniPair)iterator.nextItem();
            if (!pair.getName().equalsIgnoreCase(sName)) continue;
            return pair;
        }
        return null;
    }

    public void setPairDesc(String sName, String sDesc) {
        int currentIdx;
        int lastVarIdx = 0;
        for (currentIdx = 0; currentIdx < this.m_Contents.size(); ++currentIdx) {
            IniObject item = this.m_Contents.elementAt(currentIdx);
            if (!(item instanceof IniPair)) continue;
            String s = ((IniPair)item).getName();
            if (s.equalsIgnoreCase(sName)) break;
            lastVarIdx = currentIdx;
        }
        for (int i = lastVarIdx + 1; i < currentIdx; ++i) {
            this.m_Contents.removeElementAt(lastVarIdx + 1);
        }
        if (currentIdx == 0) {
            this.m_Contents.insertElementAt(new IniComment(sDesc), 0);
        } else {
            this.m_Contents.insertElementAt(new IniComment(sDesc), lastVarIdx + 1);
        }
    }

    public String getName() {
        return this.m_sName;
    }

    public String getValue(String sName) {
        IniPair pair = this.getPair(sName);
        if (pair == null) {
            return null;
        }
        return pair.getValue();
    }

    public IniIterator getIterator(boolean bVarsOnly) {
        return new SectionIterator(bVarsOnly);
    }

    @Override
    public void write(Writer writer) throws IOException {
        super.write(writer);
        SectionIterator iterator = new SectionIterator(false);
        while (iterator.hasMoreItems()) {
            IniObject item = (IniObject)iterator.nextItem();
            item.write(writer);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.m_sName);
        sb.append(']');
        sb.append(NEW_LINE);
        return sb.toString();
    }

    class SectionIterator
    implements IniIterator {
        private int m_nCurrent = 0;
        private boolean m_bVarsOnly;

        private SectionIterator(boolean bVarsOnly) {
            this.m_bVarsOnly = bVarsOnly;
        }

        @Override
        public boolean hasMoreItems() {
            if (!this.m_bVarsOnly) {
                return this.m_nCurrent < IniSection.this.m_Contents.size();
            }
            while (this.m_nCurrent < IniSection.this.m_Contents.size()) {
                Object item = IniSection.this.m_Contents.elementAt(this.m_nCurrent);
                if (item instanceof IniPair) {
                    return true;
                }
                ++this.m_nCurrent;
            }
            return false;
        }

        @Override
        public Object nextItem() {
            return IniSection.this.m_Contents.elementAt(this.m_nCurrent++);
        }

        @Override
        public void insertBefore(Object item) {
            if (!(item instanceof IniObject)) {
                throw new IllegalArgumentException("Not a valid section element");
            }
            if (this.m_nCurrent == 0) {
                IniSection.this.m_Contents.insertElementAt((IniObject)item, 0);
            } else {
                IniSection.this.m_Contents.insertElementAt((IniObject)item, this.m_nCurrent - 1);
            }
            ++this.m_nCurrent;
        }

        @Override
        public void insertAfter(Object item) {
            if (!(item instanceof IniObject)) {
                throw new IllegalArgumentException("Not a valid section element");
            }
            IniSection.this.m_Contents.insertElementAt((IniObject)item, this.m_nCurrent);
        }

        @Override
        public void remove() {
            IniSection.this.m_Contents.removeElementAt(this.m_nCurrent - 1);
        }
    }
}

