/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.iniMerger;

import com.oracle.cie.nextgen.common.iniMerger.SectionResolver;
import com.oracle.cie.nextgen.common.version.VersionHelper;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class OracleSectionResolver
implements SectionResolver {
    private static final Logger _log = Logger.getLogger(OracleSectionResolver.class.getName());
    private HashMap<String, Set<String>> unresolvedParams;
    private HashMap<String, Set<String>> cachedParams;

    @Override
    public void resolve(HashMap<String, Set<String>> sectionMap) {
        if (this.unresolvedParams == null) {
            this.unresolvedParams = new HashMap();
        }
        if (this.cachedParams == null) {
            this.cachedParams = new HashMap();
        }
        for (Map.Entry<String, Set<String>> entry : sectionMap.entrySet()) {
            String single;
            Object value2;
            String key = entry.getKey();
            LinkedHashSet values = (LinkedHashSet)entry.getValue();
            if (key.equals("JAVA_VERSION")) {
                String topVersion = "0.0";
                for (Object value2 : values) {
                    if (!VersionHelper.isValidVersion((String)value2) || VersionHelper.compare(topVersion, (String)value2) != -1) continue;
                    topVersion = value2;
                }
                values.clear();
                values.add(topVersion);
                continue;
            }
            if (key.equals("USEJDKONLY") || key.equals("USEJREONLY") || key.equals("USE_PREREQ_CHECKER") || key.equals("NLS_ENABLED") || key.equals("FEATURESET_UNINSTALL_SUPPORTED")) {
                boolean setTrue = false;
                if (values.size() > 1) {
                    for (Object value2 : values) {
                        if (!Boolean.parseBoolean((String)value2)) continue;
                        setTrue = true;
                    }
                    if (setTrue) {
                        values.clear();
                        values.add("TRUE");
                    }
                }
                this.cachedParams.put(key, values);
                continue;
            }
            if (key.equals("EXT_CLASSPATH") || key.equals("VM_TYPES") || key.equals("THIN_JDBC_FILENAME")) {
                StringBuilder csv = new StringBuilder();
                LinkedHashSet<String> singles = new LinkedHashSet<String>();
                for (String value3 : values) {
                    for (String single2 : value3.split(",")) {
                        singles.add(single2);
                    }
                }
                value2 = singles.iterator();
                while (value2.hasNext()) {
                    single = (String)value2.next();
                    csv.append(single + ",");
                }
                values.clear();
                values.add(csv.substring(0, csv.length() - 1));
                continue;
            }
            if (key.equals("IBM_JAVA_OPTIONS") || key.equals("HOTSPOT_JAVA_OPTIONS") || key.equals("JROCKIT_JAVA_OPTIONS")) {
                StringBuilder ssv = new StringBuilder();
                LinkedHashSet<String> singles = new LinkedHashSet<String>();
                for (String value3 : values) {
                    for (String single2 : value3.split(" ")) {
                        singles.add(single2);
                    }
                }
                value2 = singles.iterator();
                while (value2.hasNext()) {
                    single = (String)value2.next();
                    ssv.append(single + " ");
                }
                values.clear();
                values.add(ssv.substring(0, ssv.length() - 1));
                continue;
            }
            if (key.equals("INSTALL_CLASS")) {
                Set<String> cachedValues = this.cachedParams.get("FEATURESET_UNINSTALL_SUPPORTED");
                if (values.size() <= 1) continue;
                values.clear();
                if (cachedValues == null || !cachedValues.contains("TRUE")) continue;
                values.add("com.oracle.cie.wizard.WizardController");
                _log.warning("The INSTALL_CLASS will be replaced by [com.oracle.cie.wizard.WizardController] in favor of enable the Feature-Set Uninstall Support.");
                continue;
            }
            if (key.equals("LOG_LOCATION")) {
                values.clear();
                values.add("CENTRAL_INVENTORY");
                _log.info("The LOG_LOCATION will be replaced by [CENTRAL_INVENTORY] If it's the one you are using omit this warning.");
                continue;
            }
            if (key.equals("UMASK")) {
                StringBuilder sb = new StringBuilder();
                int umask = 27;
                value2 = values.iterator();
                while (value2.hasNext()) {
                    String value3;
                    value3 = (String)value2.next();
                    int current = Integer.parseInt(value3);
                    if (current >= umask) continue;
                    umask = current;
                }
                String line = sb.append(umask).toString();
                while (line.length() < 4) {
                    line = "0" + line;
                }
                values.clear();
                values.add(line);
                continue;
            }
            _log.info("The next key and value are not supported. Key=" + key + " Value=" + values);
            this.unresolvedParams.put(key, values);
        }
    }

    @Override
    public void setUnresolvedParams(HashMap<String, Set<String>> params) {
        this.unresolvedParams = params;
    }

    @Override
    public HashMap<String, Set<String>> getUnresolvedParams() {
        return this.unresolvedParams;
    }
}

