/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.enums;

import com.oracle.cie.nextgen.common.utils.Util;

public enum OperationModeType {
    INSTALL("install", "OperationModeType_INSTALL"),
    DEINSTALL("deinstall", "OperationModeType_DEINSTALL"),
    CLONE("clone", "OperationModeType_CLONE"),
    CREATE_CLONE_ARCHIVE("createCloneArchive", "OperationModeType_CREATE_CLONE_ARCHIVE"),
    APPLY_CLONE_ARCHIVE("applyCloneArchive", "OperationModeType_APPLY_CLONE_ARCHIVE"),
    ADDNODE("addNode", "OperationModeType_ADDNODE"),
    ATTACH_HOME("attachHome", "OperationModeType_ATTACH_HOME"),
    DETACH_HOME("detachHome", "OperationModeType_DETACH_HOME"),
    LANG_ADDON("addLangs", "OperationModeType_LANG_ADDON"),
    PRE_REQ_CHECK("prereqchecker", "OperationModeType_PRE_REQ_CHECK"),
    INSTALLER_UPDATE("updateInstaller", "OperationModeType_UPDATE_INSTALLER");

    private String mode;
    private String i18NKey;

    private OperationModeType(String mode, String i18NKey) {
        this.mode = mode;
        this.i18NKey = i18NKey;
    }

    public String getMode() {
        return this.mode;
    }

    public String getI18NKey() {
        return this.i18NKey;
    }

    public static OperationModeType getEnum(String str) {
        for (OperationModeType type : OperationModeType.values()) {
            if (!Util.equals(str, type.getMode())) continue;
            return type;
        }
        return null;
    }

    public String getName() {
        return this.name();
    }

    public boolean isInstall() {
        return this == INSTALL;
    }

    public boolean isDeinstall() {
        return this == DEINSTALL;
    }

    public boolean isClone() {
        return this == CLONE;
    }

    public boolean isCreateCloneArchive() {
        return this == CREATE_CLONE_ARCHIVE;
    }

    public boolean isApplyCloneArchive() {
        return this == APPLY_CLONE_ARCHIVE;
    }

    public boolean isAttachHome() {
        return this == ATTACH_HOME;
    }

    public boolean isDetachHome() {
        return this == DETACH_HOME;
    }

    public boolean isInstallerUpdate() {
        return this == INSTALLER_UPDATE;
    }
}

