/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.impl;

import com.oracle.cie.nextgen.common.inputs.apis.Option;
import com.oracle.cie.nextgen.common.inputs.enums.DataType;
import com.oracle.cie.nextgen.common.inputs.impl.InputImpl;
import com.oracle.xmlns.oui.options.InputType;

public class OptionImpl
extends InputImpl
implements Option {
    private InputType type;
    private String _prefix;

    public OptionImpl(String name, InputType type, String prefix) {
        super(name, OptionImpl.computeDataType(type));
        this.type = type;
        this._prefix = prefix;
    }

    @Override
    public boolean validate() {
        switch (this.type) {
            case PATH_EXISTS: 
            case FILE_EXISTS: {
                return this.validateFile((String)this.getValue());
            }
        }
        return true;
    }

    private static DataType computeDataType(InputType type) {
        switch (type) {
            case DATETIME: {
                return DataType.DATE;
            }
            case BOOLEAN: {
                return DataType.BOOLEAN;
            }
            case NUMBER: {
                return DataType.INTEGER;
            }
        }
        return DataType.STRING;
    }

    @Override
    public String getOptionPrefix() {
        return this._prefix;
    }

    @Override
    public String getJavaSystemPropertyName() {
        return this.getOptionPrefix() + this.getName();
    }
}

