/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.patchsdk;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import model.bundle_xml.Subpatch;
import model.bundle_xml.SystemPatchBundleXML;
import model.bundle_xml.TargetType;
import model.patchmodel.CompositePatch;
import model.patchmodel.EngineeredSystemPatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.OPatchSingleton;
import model.patchmodel.PatchPackage;
import model.patchmodel.PatchingTool;
import model.util.BundleValidationException;
import model.util.BundleXmlException;
import model.util.BundleXmlHelper;
import model.util.BundleXmlUtil;
import oracle.osysmodel.engineeredsystem.EngineeredSystemPatchValidatorAndGenerator;
import oracle.osysmodel.patchsdk.PatchPackageException;
import oracle.osysmodel.patchsdk.PatchValidatorAndGenerator;
import oracle.osysmodel.patchsdk.TarArchiveStreamMapConstructor;
import oracle.osysmodel.patchsdk.ZipStreamMapConstructor;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchFactory {
    static Logger logger = Logger.getLogger(PatchFactory.class.getName());
    private Map<String, List<PatchValidatorAndGenerator>> constructables = new HashMap<String, List<PatchValidatorAndGenerator>>();
    private ZipStreamMapConstructor constructor = null;
    private TarArchiveStreamMapConstructor tarArchiveConstructor = null;
    private boolean defaultESysPatchValidatorAndGeneratorAdded = true;

    public PatchFactory() {
        this(true);
    }

    public PatchFactory(boolean addDefault) {
        this.defaultESysPatchValidatorAndGeneratorAdded = addDefault;
    }

    public void addPatchValidatorAndGenerator(PatchValidatorAndGenerator vg) {
        logger.entering(PatchFactory.class.getName(), "getInstance()");
        String ptool = vg.getPatchTool();
        if (this.constructables.containsKey(ptool)) {
            this.constructables.get(ptool).add(vg);
        } else {
            ArrayList<PatchValidatorAndGenerator> vgList = new ArrayList<PatchValidatorAndGenerator>();
            vgList.add(vg);
            this.constructables.put(ptool, vgList);
        }
    }

    public Map<String, List<String>> getPatchIDSFromBundleXML(String patchLocation, List<String> filters) throws PatchPackageException {
        EngineeredSystemPatchValidatorAndGenerator esysvg = new EngineeredSystemPatchValidatorAndGenerator();
        SystemPatchBundleXML esysBundle = esysvg.validateAndGenerateSystemBundleXml(patchLocation);
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        if (esysBundle == null) {
            return resultMap;
        }
        for (Subpatch subPatchXml : esysBundle.getSubpatches()) {
            List<String> targetTypeList = this.makeApplicableTargetsList(subPatchXml.getTargetTypes());
            for (String targetType : targetTypeList) {
                if (filters != null && !filters.isEmpty() && !filters.contains(targetType)) continue;
                if (!resultMap.containsKey(targetType)) {
                    resultMap.put(targetType, new ArrayList());
                }
                List patchIds = (List)resultMap.get(targetType);
                patchIds.add(subPatchXml.getPatchID());
            }
        }
        return resultMap;
    }

    public String getSystemPatchID(String patchLocation) throws PatchPackageException {
        EngineeredSystemPatchValidatorAndGenerator esysvg = new EngineeredSystemPatchValidatorAndGenerator();
        SystemPatchBundleXML esysBundle = esysvg.validateAndGenerateSystemBundleXml(patchLocation);
        return esysBundle == null ? null : esysBundle.getPatchID();
    }

    public PatchPackage getInstance(String patchLocation) throws PatchPackageException {
        EngineeredSystemPatchValidatorAndGenerator esysvg;
        logger.entering(PatchFactory.class.getName(), "getInstance()");
        logger.entering(PatchFactory.class.getName(), "patchLocation " + patchLocation);
        assert (patchLocation != null);
        PatchPackage patch = null;
        boolean patchAlreadyValidated = false;
        if (this.defaultESysPatchValidatorAndGeneratorAdded && (esysvg = new EngineeredSystemPatchValidatorAndGenerator()).isPatchValid(patchLocation)) {
            patch = esysvg.generate(patchLocation);
            patchAlreadyValidated = true;
        }
        if (!patchAlreadyValidated) {
            for (PatchValidatorAndGenerator vg : this.constructables.get(PatchingTool.OPATCH.toString())) {
                if (!vg.isPatchValid(patchLocation)) continue;
                logger.log(Level.INFO, "Given patch location was validated by " + vg.getClass().getName());
                if (patchAlreadyValidated) {
                    throw new PatchPackageException("This patch is invalid as it can be matched with two patch                             patterns.");
                }
                patch = vg.generate(patchLocation);
                patchAlreadyValidated = true;
            }
        }
        if (patch instanceof EngineeredSystemPatch) {
            logger.log(Level.FINE, "Patch represented by the given patch location " + patchLocation + " is an Engineered System Patch.");
            EngineeredSystemPatch esysPatch = (EngineeredSystemPatch)patch;
            try {
                BundleXmlHelper bxh = new BundleXmlHelper();
                SystemPatchBundleXML esysBundle = bxh.readBundle(esysPatch.getBundleXml());
                esysPatch.setSystemPatchBundleXML(esysBundle);
                esysPatch.setMinOPlanVersion(esysBundle.getAutomation().getOplanVersion());
                BundleXmlUtil.populateDelpoyOrder((SystemPatchBundleXML)esysBundle, (EngineeredSystemPatch)esysPatch);
                esysPatch.setScripts(esysBundle.getScripts());
                boolean areAllSubPatchesRolling = true;
                for (Subpatch subPatchXml : esysBundle.getSubpatches()) {
                    String patchingTool = subPatchXml.getPatchingTool().toString();
                    List<PatchValidatorAndGenerator> patchValidatorAndGenerators = this.constructables.get(patchingTool);
                    if (!(patchValidatorAndGenerators != null && !patchValidatorAndGenerators.isEmpty() || (patchValidatorAndGenerators = this.constructables.get(patchingTool = PatchingTool.NONOPATCH.toString())) != null && !patchValidatorAndGenerators.isEmpty())) continue;
                    for (PatchValidatorAndGenerator vg : patchValidatorAndGenerators) {
                        logger.log(Level.INFO, "Trying to create sub patch with the PatchValidatorAndGenerator " + vg.getClass().getName());
                        StringBuffer esysSubPatchLocation = new StringBuffer(esysPatch.getPatchLocation());
                        esysSubPatchLocation.append(File.separator);
                        esysSubPatchLocation.append(subPatchXml.getLocation());
                        if (!vg.isPatchValid(esysSubPatchLocation.toString())) continue;
                        PatchPackage subPatch = vg.generate(esysSubPatchLocation.toString());
                        if (!(subPatch instanceof GenericPatch)) {
                            throw new PatchPackageException("The given esys patch contains a patch thatis not a singleton. ");
                        }
                        GenericPatch subpatch = (GenericPatch)subPatch;
                        subpatch.setApplicableTargets(this.makeApplicableTargetsList(subPatchXml.getTargetTypes()));
                        subpatch.setVersion(this.getTargetVersion(subPatchXml.getTargetTypes()));
                        subpatch.setPatchID(subPatchXml.getPatchID());
                        BundleXmlUtil.setMetadata((Subpatch)subPatchXml, (GenericPatch)subpatch);
                        if (subpatch instanceof OPatchSingleton) {
                            OPatchSingleton opatchSubPatch = (OPatchSingleton)subpatch;
                            subpatch = opatchSubPatch;
                        }
                        if (subpatch instanceof CompositePatch) {
                            CompositePatch compositePatch = (CompositePatch)subpatch;
                            subpatch = compositePatch;
                        }
                        esysPatch.getSubPatches().add(subpatch);
                        if (subPatch.getRollingPatch() != null && subPatch.getRollingPatch().booleanValue()) continue;
                        areAllSubPatchesRolling = false;
                    }
                }
                esysPatch.setRollingPatch(new Boolean(areAllSubPatchesRolling));
                return esysPatch;
            }
            catch (BundleXmlException e) {
                throw new PatchPackageException("Couldn't instantiate the Bundle helper because of " + e.getMessage(), e);
            }
            catch (BundleValidationException e) {
                throw new PatchPackageException("The patch is of type EngineeredSystemPatch however, bundleXmlcannot be validated by Esys Patch BundleXSD.");
            }
        }
        logger.exiting(PatchFactory.class.getName(), "getInstance()");
        return patch;
    }

    public void addZipStreamMapConstructor(ZipStreamMapConstructor constructor) {
        this.constructor = constructor;
    }

    public void addTarArchiveStreamMapConstructor(TarArchiveStreamMapConstructor constructor) {
        this.tarArchiveConstructor = constructor;
    }

    public PatchPackage getInstance(InputStream iStream) throws PatchPackageException {
        EngineeredSystemPatchValidatorAndGenerator esysvg;
        logger.entering(PatchFactory.class.getName(), "getInstance()");
        assert (iStream != null);
        if (this.constructor == null && this.tarArchiveConstructor == null) {
            throw new PatchPackageException("Before the method getInstance is invokded, the map constructor that parses the patch zip stream must be initialized.");
        }
        HashMap<Object, Object> map = new HashMap();
        if (iStream instanceof ZipInputStream) {
            map = this.constructor.ConstructMap((ZipInputStream)iStream);
        }
        if (iStream instanceof TarArchiveInputStream) {
            map = this.tarArchiveConstructor.ConstructMap((TarArchiveInputStream)iStream);
        }
        PatchPackage patch = null;
        boolean patchAlreadyValidated = false;
        if (this.defaultESysPatchValidatorAndGeneratorAdded && (esysvg = new EngineeredSystemPatchValidatorAndGenerator()).isPatchValid(map)) {
            patch = esysvg.generate(map);
            patchAlreadyValidated = true;
        }
        if (!patchAlreadyValidated) {
            for (PatchValidatorAndGenerator vg : this.constructables.get(PatchingTool.OPATCH.toString())) {
                if (!vg.isPatchValid(map)) continue;
                logger.log(Level.INFO, "Given patch was validated by " + vg.getClass().getName());
                if (patchAlreadyValidated) {
                    throw new PatchPackageException("This patch is invalid as it can be matched with two patch                             patterns.");
                }
                patch = vg.generate(map);
                patchAlreadyValidated = true;
            }
        }
        if (patch instanceof EngineeredSystemPatch) {
            logger.log(Level.FINE, "The patch zip file is an Engineered System Patch.");
            EngineeredSystemPatch esysPatch = (EngineeredSystemPatch)patch;
            try {
                BundleXmlHelper bxh = new BundleXmlHelper();
                SystemPatchBundleXML esysBundle = bxh.readBundle(esysPatch.getBundleXml());
                esysPatch.setSystemPatchBundleXML(esysBundle);
                esysPatch.setMinOPlanVersion(esysBundle.getAutomation().getOplanVersion());
                List subPatchList = esysPatch.getSubPatches();
                for (Subpatch subPatch : esysBundle.getSubpatches()) {
                    for (GenericPatch genericSubPatch : subPatchList) {
                        BundleXmlUtil.setRebootRequired((Subpatch)subPatch, (GenericPatch)genericSubPatch);
                        if (!genericSubPatch.getPatchLocation().endsWith(subPatch.getLocation())) continue;
                        genericSubPatch.setApplicableTargets(this.makeApplicableTargetsList(subPatch.getTargetTypes()));
                        genericSubPatch.setVersion(this.getTargetVersion(subPatch.getTargetTypes()));
                        if (!(genericSubPatch instanceof OPatchSingleton)) continue;
                        OPatchSingleton opatchSubPatch = (OPatchSingleton)genericSubPatch;
                        genericSubPatch = opatchSubPatch;
                    }
                }
                BundleXmlUtil.populateDelpoyOrder((SystemPatchBundleXML)esysBundle, (EngineeredSystemPatch)esysPatch);
                return esysPatch;
            }
            catch (BundleXmlException e) {
                throw new PatchPackageException("Couldn't instantiate the Bundle helper because of " + e.getMessage(), e);
            }
            catch (BundleValidationException e) {
                throw new PatchPackageException("The patch is of type EngineeredSystemPatch however, bundleXmlcannot be validated by Esys Patch BundleXSD.");
            }
        }
        logger.exiting(PatchFactory.class.getName(), "getInstance()");
        return patch;
    }

    public Map<String, List<PatchValidatorAndGenerator>> getAllPatchValidatorsAndGenerators() {
        return this.constructables;
    }

    public List<String> makeApplicableTargetsList(List<TargetType> subPatchTargetTypes) throws PatchPackageException {
        ArrayList<String> applicableTargets = new ArrayList<String>();
        if (subPatchTargetTypes != null && !subPatchTargetTypes.isEmpty()) {
            for (TargetType subPatchTarget : subPatchTargetTypes) {
                applicableTargets.add(subPatchTarget.getType().toString());
            }
        } else {
            throw new PatchPackageException("The given patch has no target types.");
        }
        return applicableTargets;
    }

    private String getTargetVersion(List<TargetType> subPatchTargetTypes) throws PatchPackageException {
        String version = null;
        if (subPatchTargetTypes != null && !subPatchTargetTypes.isEmpty()) {
            Iterator<TargetType> i$ = subPatchTargetTypes.iterator();
            if (i$.hasNext()) {
                TargetType subPatchTarget = i$.next();
                version = subPatchTarget.getVersion();
            }
        } else {
            throw new PatchPackageException("The given patch has no target types.");
        }
        return version;
    }
}

