/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.session;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.session.PatchInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchFactory;
import oracle.glcm.opatch.common.helpers.PatchHelper;

public class PatchInfoImpl
implements PatchInfo {
    private String _patchLocation;
    private String _patchBaseDirectory;
    private String _patchId;
    private List<Patch> _patches;

    public PatchInfoImpl(String patchLocation, String patchBaseDirectory, String patchId) throws OPatchAutoException {
        this._patchLocation = patchLocation;
        this._patchBaseDirectory = patchBaseDirectory;
        this._patchId = patchId;
        if (patchLocation != null && patchBaseDirectory != null) {
            throw new OPatchAutoException("68143", new Object[0]);
        }
    }

    @Override
    public String getPatchLocation() {
        return this._patchLocation;
    }

    public void setPatchLocation(String patchLocation) {
        this._patchLocation = patchLocation;
    }

    @Override
    public String getPatchBaseDirectory() {
        return this._patchBaseDirectory;
    }

    public void setPatchBaseDirectory(String patchDirectory) {
        this._patchBaseDirectory = patchDirectory;
    }

    @Override
    public String getPatchId() {
        return this._patchId;
    }

    public void setPatchId(String id) {
        this._patchId = id;
    }

    @Override
    public List<Patch> getPatches() throws OPatchAutoException {
        if (this._patches == null) {
            this.createPatches();
        }
        return this._patches;
    }

    private void createPatches() throws OPatchAutoException {
        PatchFactory patchFactory = BasePatchFactory.instance();
        if (this._patchLocation != null) {
            try {
                Patch patch = patchFactory.createPatch(this._patchLocation);
                if (this._patches == null) {
                    this._patches = new ArrayList<Patch>();
                }
                this._patches.add(patch);
            }
            catch (Exception e) {
                throw new OPatchAutoException("68142", (Throwable)e, this._patchLocation);
            }
        }
        if (this._patchBaseDirectory != null) {
            this._patches = new ArrayList<Patch>();
            try {
                File[] patchDirs = new File(this._patchBaseDirectory).listFiles();
                if (patchDirs != null) {
                    for (File patchDir : patchDirs) {
                        Patch patch = patchFactory.createPatch(patchDir.getAbsolutePath());
                        if (this._patches == null) {
                            this._patches = new ArrayList<Patch>();
                        }
                        this._patches.add(patch);
                    }
                }
            }
            catch (Exception e) {
                throw new OPatchAutoException("68142", (Throwable)e, this._patchBaseDirectory);
            }
        }
        if (this._patches != null) {
            for (Patch patch : this._patches) {
                PatchHelper.cachePatch((Patch)patch);
            }
        }
    }
}

