/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.fsc.DistributionGroup;
import com.oracle.cie.gdr.dao.fsc.FeatureSetConsumption;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.FeatureSetConsumptionHelper;
import com.oracle.cie.gdr.packaging.Packager;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeatureConsumptionLoader {
    private static final Logger _log = Logger.getLogger(FeatureConsumptionLoader.class.getName());
    private Set<FeatureSetConsumption> _featuresConsumptions;
    private Set<FeatureSet> _nonConsumableFeaturesRefs;
    protected MetaDataHome _metaDataHome;

    public FeatureConsumptionLoader(MetaDataHome metaDataHome, Set<FeatureSet> features) throws GdrException {
        this(metaDataHome, features, null);
    }

    public FeatureConsumptionLoader(MetaDataHome metaDataHome, Set<FeatureSet> features, Set<FeatureSetConsumption> featuresConsumptions) throws GdrException {
        this._metaDataHome = metaDataHome;
        this.init(features, featuresConsumptions);
    }

    public Set<FeatureSetConsumption> getFeaturesConsumptions() {
        return this._featuresConsumptions;
    }

    public Set<FeatureSet> getNonConsumableFeatures() {
        return this._nonConsumableFeaturesRefs;
    }

    protected void init(Set<FeatureSet> features, Set<FeatureSetConsumption> featuresConsumptions) throws GdrException {
        if ((features == null || features.isEmpty()) && (featuresConsumptions == null || featuresConsumptions.isEmpty())) {
            GdrException ex = new GdrException("No features were provided.");
            _log.throwing(FeatureConsumptionLoader.class.getName(), "init", ex);
            throw ex;
        }
        if (this._metaDataHome == null) {
            GdrException ex = new GdrException("The meta-data home provided was null.");
            _log.throwing(FeatureConsumptionLoader.class.getName(), "init", ex);
            throw ex;
        }
        this.loadMetaData(features, featuresConsumptions);
    }

    protected void loadMetaData(Set<FeatureSet> features, Set<FeatureSetConsumption> featuresConsumptions) throws GdrException {
        if (features != null && !features.isEmpty()) {
            this.loadFeaturesConsumptions(features);
        }
        if (featuresConsumptions != null && !featuresConsumptions.isEmpty()) {
            if (this._featuresConsumptions == null) {
                this._featuresConsumptions = new LinkedHashSet<FeatureSetConsumption>();
            }
            this._featuresConsumptions.addAll(featuresConsumptions);
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Loaded " + this._featuresConsumptions.size() + " feature sets consumptions.");
        }
    }

    private void loadFeaturesConsumptions(Set<FeatureSet> features) throws GdrException {
        if (this._featuresConsumptions == null) {
            this._featuresConsumptions = new LinkedHashSet<FeatureSetConsumption>();
        } else {
            this._featuresConsumptions.clear();
        }
        if (this._nonConsumableFeaturesRefs == null) {
            this._nonConsumableFeaturesRefs = new LinkedHashSet<FeatureSet>();
        } else {
            this._nonConsumableFeaturesRefs.clear();
        }
        FeatureSetConsumption featureConsumption = null;
        for (FeatureSet feature : features) {
            try {
                featureConsumption = FeatureSetConsumptionHelper.getInstance().getFeatureSetConsumption(this._metaDataHome.getGdrMetaDataHome(), feature);
                boolean hasDistributions = false;
                boolean hasFeatures = false;
                for (DistributionGroup distGroup : featureConsumption.getDistributionGroups()) {
                    if (distGroup.getDistributions().isEmpty()) continue;
                    hasDistributions = true;
                    break;
                }
                for (FeatureSetGroup ftrGroup : featureConsumption.getFeatureSetGroups()) {
                    if (ftrGroup.getFeatures().isEmpty()) continue;
                    hasFeatures = true;
                    break;
                }
                if (hasDistributions || hasFeatures) {
                    this._featuresConsumptions.add(featureConsumption);
                    continue;
                }
                this._nonConsumableFeaturesRefs.add(feature);
            }
            catch (GdrException gdrException) {
                if (!feature.getConsumptionType().equals("restricted")) continue;
                this._nonConsumableFeaturesRefs.add(feature);
            }
        }
    }

    public FeatureSetConsumption getFeatureConsumption(String name, String version) {
        if (!StringUtil.isNullOrEmpty((String)name) && !StringUtil.isNullOrEmpty((String)version)) {
            for (FeatureSetConsumption featureConsumption : this.getFeaturesConsumptions()) {
                if (!name.equals(featureConsumption.getName()) || !version.equals(featureConsumption.getVersion())) continue;
                return featureConsumption;
            }
        }
        return null;
    }

    public void saveFeaturesConsumptions(File dir) throws GdrException {
        if (!dir.exists() && !dir.mkdirs()) {
            GdrException ex = new GdrException("Directory specified did not exist and could not be created: " + dir);
            _log.throwing(Packager.class.getName(), "saveFeatures", ex);
            throw ex;
        }
        if (!dir.isDirectory()) {
            GdrException ex = new GdrException("Directory specified was not a directory: " + dir);
            _log.throwing(Packager.class.getName(), "saveFeatures", ex);
            throw ex;
        }
        Set<FeatureSetConsumption> featuresConsumptions = this.getFeaturesConsumptions();
        for (FeatureSetConsumption featureConsumption : featuresConsumptions) {
            try {
                FeatureSetConsumptionHelper.getInstance().save((IDataHandlerWrapper)featureConsumption, new File(dir, FeatureSetConsumptionHelper.getInstance().getFeatureSetConsumptionFileName(featureConsumption)));
            }
            catch (DataHandlerException e) {
                throw new GdrException((Throwable)e);
            }
        }
    }
}

