/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.DiffReport;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.JarUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.xmldiff.XmlDiff;
import com.oracle.cie.common.xmldiff.XmlDiffApplicator;
import com.oracle.cie.common.xmldiff.XmlDiffAspect;
import com.oracle.cie.common.xmldiff.XmlDiffException;
import com.oracle.cie.common.xmldiff.XmlDiffTree;
import com.oracle.cie.common.xmldiff.XmlDiffTreeFilter;
import com.oracle.cie.dependency.mgmt.impl.VersionImpl;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.carbdiff.CarbDiffException;
import com.oracle.cie.gdr.carbdiff.CarbDiffUtils;
import com.oracle.cie.gdr.carbdiff.DefaultCarbDiffHandler;
import com.oracle.cie.gdr.carbdiff.FileMapFilterer;
import com.oracle.cie.gdr.carbdiff.FilteredCarbDiffHandler;
import com.oracle.cie.gdr.carbdiff.Strategy;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.pad.TextFileDiffFilter;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class CarbDiff {
    public static String DIST_PATCHED = "distPatched";
    public static String DIST_BASE = "distBase";
    private Component _deltaComponent;
    private XmlDiffTree _carbXmlDiffTree;
    private FileMapFilterer _fileMapFilterer;
    private XmlDiffTreeFilter _xmlDiffTreeFilter;
    private TextFileDiffFilter _textFileDiffFilter;
    private File _carbXDiff;
    private boolean _bypassDiff = false;
    private boolean _isXmlDiffEnabled = false;
    private boolean _includeParentClass;
    private static final Logger _logger = Logger.getLogger(CarbDiff.class.getName());
    private DiffReport _report;
    private Boolean _required;
    private List<FileTarget> _fileTargetsToDelete;

    public boolean diff(File baseCarb, File patchCarb, File deltaCarbDestination, Strategy strategy, String platform, boolean excludeGeneric) throws CarbDiffException {
        return this.diff(baseCarb, patchCarb, deltaCarbDestination, strategy, platform, excludeGeneric, null);
    }

    public boolean diff(File baseCarb, File patchCarb, File deltaCarbDestination, Strategy strategy, String platform, boolean excludeGeneric, String uid) throws CarbDiffException {
        return this.diff(baseCarb, patchCarb, null, deltaCarbDestination, strategy, platform, excludeGeneric, uid);
    }

    private void updatePatchLevel(Strategy strategy, Component baseComponent, Component deltaComponent) {
        if (!strategy.isUpgrade()) {
            if (!StringUtil.isNullOrEmpty((String)baseComponent.getPatchLevel())) {
                VersionImpl basePatchLevel = new VersionImpl(baseComponent.getPatchLevel());
                VersionImpl deltaPatchLevel = null;
                if (!StringUtil.isNullOrEmpty((String)deltaComponent.getPatchLevel())) {
                    deltaPatchLevel = new VersionImpl(deltaComponent.getPatchLevel());
                }
                if (deltaPatchLevel != null) {
                    if (basePatchLevel.compareTo(deltaPatchLevel) < 0) {
                        _logger.warning("The patch level from the delta component is lower than the base component.");
                    } else if (basePatchLevel.compareTo((Object)deltaPatchLevel) > 0) {
                        _logger.warning("The patch level from the delta component is higher than the base component.");
                    }
                }
                deltaComponent.setPatchLevel(baseComponent.getPatchLevel());
                _logger.info("Setting delta component patch level to: " + baseComponent.getPatchLevel());
            } else {
                _logger.info("No patch level in base carb: " + baseComponent.getName() + " " + baseComponent.getVersion());
            }
        }
    }

    public boolean diff(File baseCarb, File patchCarb, File releaseCarb, File deltaCarbDestination, Strategy strategy, String platform, boolean excludeGeneric, String uid) throws CarbDiffException {
        try {
            _logger.entering(CarbDiff.class.getName(), "diff", new Object[]{baseCarb, patchCarb, releaseCarb, deltaCarbDestination, strategy, platform, excludeGeneric});
            if (StringUtil.isNullOrEmpty((String)uid, (boolean)true)) {
                uid = "unknown";
            }
            Component baseComponent = CarbDiffUtils.getComponentFromCarb(baseCarb);
            Component patchComponent = CarbDiffUtils.getComponentFromCarb(patchCarb);
            this._deltaComponent = patchComponent.copy();
            this.updatePatchLevel(strategy, baseComponent, this._deltaComponent);
            this.createStagingLocation(deltaCarbDestination);
            Map<String, File> patchedDataFiles = this.extractDataFiles(patchCarb, new File(deltaCarbDestination, "distPatched" + File.separator + this._deltaComponent.getName() + File.separator + this._deltaComponent.getVersion()));
            Map<String, File> releaseDataFiles = this.extractDataFiles(baseCarb, new File(deltaCarbDestination, "distBase" + File.separator + baseComponent.getName() + File.separator + baseComponent.getVersion()));
            this.processUpdatePatchMetadata(deltaCarbDestination, releaseCarb, baseCarb, baseComponent);
            DefaultCarbDiffHandler diffHandler = !this._bypassDiff ? new DefaultCarbDiffHandler(strategy, deltaCarbDestination, platform, excludeGeneric, releaseDataFiles, patchedDataFiles) : new FilteredCarbDiffHandler(strategy, deltaCarbDestination, platform, excludeGeneric, releaseDataFiles, patchedDataFiles);
            diffHandler.setDiffReport(this._report);
            diffHandler.setIncludeParentClass(this._includeParentClass);
            if (this._fileMapFilterer != null) {
                diffHandler.setFileMapFilterer(this._fileMapFilterer);
            }
            if (this._textFileDiffFilter != null) {
                diffHandler.setTextFileDiffFilter(this._textFileDiffFilter);
            }
            if (diffHandler.diff(baseComponent, patchComponent)) {
                List<FileMap> deltaFileMaps = diffHandler.getDeltaFileMaps();
                if (deltaFileMaps != null && !deltaFileMaps.isEmpty()) {
                    for (FileMap deltaFileMap : deltaFileMaps) {
                        deltaFileMap.setPatch(uid);
                    }
                }
                this._deltaComponent.setFileMaps(deltaFileMaps);
                this._deltaComponent.setLibraries(null);
                File diffFile = new File(deltaCarbDestination + File.separator + ComponentHelper.getInstallDir() + File.separator + "components" + File.separator + this._deltaComponent.getName() + File.separator + this._deltaComponent.getVersion(), "compDef.xml");
                _logger.info("Saving delta component at " + diffFile);
                ComponentHelper.getInstance().save((IDataHandlerWrapper)this._deltaComponent, diffFile);
                this._deltaComponent.setCompDefLocation(diffFile);
                if (diffHandler.hasFilesToDelete()) {
                    this._fileTargetsToDelete = diffHandler.getFileTargetsToDelete();
                }
                _logger.exiting(CarbDiff.class.getName(), "diff");
                return true;
            }
        }
        catch (Exception exception) {
            throw new CarbDiffException("Failed to diff base carb " + baseCarb + " and patch carb " + patchCarb, exception);
        }
        _logger.exiting(CarbDiff.class.getName(), "diff");
        return false;
    }

    public void processPatchMetadata(Strategy strategy, File deltaCarbDestination, File releaseCarb, File baseCarb, Component baseComponent) throws CarbDiffException {
        if (!strategy.isUpgrade()) {
            this.processUpdatePatchMetadata(deltaCarbDestination, releaseCarb, baseCarb, baseComponent);
        } else {
            this.processUpgradePatchMetadata();
        }
    }

    public void processUpgradePatchMetadata() {
        _logger.info("Processing upgrade patch metadata.");
    }

    public void processUpdatePatchMetadata(File deltaCarbDestination, File releaseCarb, File baseCarb, Component baseComponent) throws CarbDiffException {
        if (!this._isXmlDiffEnabled) {
            _logger.fine("Skipping xml diff on components.");
        } else {
            _logger.fine("Starting xml diff on components.");
            try {
                this._carbXmlDiffTree = XmlDiff.diffAspects((XmlDiffAspect)baseComponent.getDataHandler(), (XmlDiffAspect)this._deltaComponent.getDataHandler(), (XmlDiffTreeFilter)this._xmlDiffTreeFilter);
            }
            catch (XmlDiffException e1) {
                throw new CarbDiffException(e1);
            }
            if (this._carbXmlDiffTree.hasChange()) {
                Component testComponent;
                _logger.info("Components have changes, saving xml diff tree.");
                this._carbXDiff = new File(deltaCarbDestination, this._deltaComponent.getName() + "_" + this._deltaComponent.getVersion() + "." + "xdiff");
                File testCarb = releaseCarb != null ? releaseCarb : baseCarb;
                try {
                    testComponent = CarbDiffUtils.getComponentFromCarb(testCarb);
                }
                catch (Exception e1) {
                    throw new CarbDiffException(e1);
                }
                if (releaseCarb != null) {
                    _logger.info("Executing fix up of the xml diff tree based on the released carb " + releaseCarb);
                    try {
                        XmlDiffApplicator.fixupDiff((XmlDiffAspect)testComponent.getDataHandler(), (XmlDiffTree)this._carbXmlDiffTree, (XmlDiffTreeFilter)this._xmlDiffTreeFilter);
                    }
                    catch (XmlDiffException e) {
                        throw new CarbDiffException(e);
                    }
                }
                try {
                    this._carbXmlDiffTree.save(this._carbXDiff);
                }
                catch (IOException e1) {
                    throw new CarbDiffException(e1);
                }
                try {
                    XmlDiffApplicator.applyDiff((XmlDiffAspect)testComponent.getDataHandler(), (XmlDiffTree)this._carbXmlDiffTree);
                }
                catch (Exception e) {
                    throw new CarbDiffException("A failure occurred while testing application of the generated xdiff on the release/base carb " + testCarb, e);
                }
            }
        }
    }

    private void createStagingLocation(File deltaCarbLocation) throws DataHandlerException, IllegalArgumentException, IOException {
        File nginstall = new File(deltaCarbLocation, ComponentHelper.getInstallDir());
        File components = new File(nginstall, "components");
        File distPatched = new File(deltaCarbLocation, DIST_PATCHED);
        File distBase = new File(deltaCarbLocation, DIST_BASE);
        File baseCompDir = new File(distBase, this._deltaComponent.getName() + File.separator + this._deltaComponent.getVersion());
        File patchedCompDir = new File(distPatched, this._deltaComponent.getName() + File.separator + this._deltaComponent.getVersion());
        _logger.fine("Creating staging location in " + deltaCarbLocation.getCanonicalPath());
        if (!deltaCarbLocation.exists()) {
            deltaCarbLocation.mkdirs();
        }
        if (!components.exists()) {
            components.mkdirs();
        }
        if (!baseCompDir.exists()) {
            baseCompDir.mkdirs();
        }
        if (!patchedCompDir.exists()) {
            patchedCompDir.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, File> extractDataFiles(File carb, File location) throws IllegalArgumentException, IOException {
        JarHelper patchHelper = new JarHelper(carb);
        String DATAFILES = "DataFiles";
        File dataFile = null;
        HashMap<String, File> jars = new HashMap<String, File>();
        _logger.fine("Extracting data files for " + carb.getCanonicalPath() + " to location " + location.getCanonicalPath());
        try {
            for (String entry : patchHelper.getEntries()) {
                String dataFileName;
                if (entry.contains("DataFiles") && !entry.endsWith("/")) {
                    dataFile = JarUtils.extractIntoTempFile((JarHelper)patchHelper, (String)entry);
                    dataFileName = entry.substring(entry.lastIndexOf("/") + 1);
                    jars.put(dataFileName, dataFile);
                    dataFile.deleteOnExit();
                    continue;
                }
                if (!entry.contains(ComponentHelper.getDataFilesExtractedDir()) || !entry.endsWith(".jar/")) continue;
                dataFileName = entry.substring(entry.lastIndexOf(ComponentHelper.getDataFilesExtractedDir()) + ComponentHelper.getDataFilesExtractedDir().length() + 1, entry.length() - 1);
                jars.put(dataFileName, carb);
            }
        }
        finally {
            patchHelper.close();
        }
        return jars;
    }

    private String getAfterComponentsEntry(String entry) {
        if (!StringUtil.isNullOrEmpty((String)entry)) {
            int start = entry.lastIndexOf("DataFiles/");
            if ((start += "DataFiles/".length()) == -1) {
                start = 0;
            }
            return entry.substring(start, entry.length());
        }
        return null;
    }

    public Component getDeltaComponent() {
        return this._deltaComponent;
    }

    public String getComponentName() {
        return this._deltaComponent.getName();
    }

    public String getComponentVersion() {
        return this._deltaComponent.getVersion();
    }

    public File getCarbXDiff() {
        return this._carbXDiff;
    }

    public boolean bypassDiff() {
        return this._bypassDiff;
    }

    public void setBypassDiff(boolean bypassDiff) {
        this._bypassDiff = bypassDiff;
    }

    public boolean isXmlDiffEnabled() {
        return this._isXmlDiffEnabled;
    }

    public void setXmlDiffEnabled(boolean xmlDiffEnabled) {
        this._isXmlDiffEnabled = xmlDiffEnabled;
    }

    public FileMapFilterer getFileMapFilterer() {
        return this._fileMapFilterer;
    }

    public void setFileMapFilterer(FileMapFilterer fileMapFilterer) {
        this._fileMapFilterer = fileMapFilterer;
    }

    public void setXmlDiffTreeFilter(XmlDiffTreeFilter xmlDiffTreeFilter) {
        this._xmlDiffTreeFilter = xmlDiffTreeFilter;
    }

    public boolean hasCarbXDiff() {
        return this._carbXDiff != null;
    }

    public void setTextFileDiffFilter(TextFileDiffFilter textFileDiffFilter) {
        this._textFileDiffFilter = textFileDiffFilter;
    }

    public TextFileDiffFilter getTextFileDiffFilter() {
        return this._textFileDiffFilter;
    }

    public void setDiffReport(DiffReport report) {
        this._report = report;
    }

    public void setIncludeParentClass(boolean includeParentClass) {
        this._includeParentClass = includeParentClass;
    }

    public Boolean getRequired() {
        return this._required;
    }

    public void setRequired(Boolean required) {
        this._required = required;
    }

    public List<FileTarget> getFileTargetsToDelete() {
        return this._fileTargetsToDelete;
    }

    public boolean hasFilesToDelete() {
        return null != this._fileTargetsToDelete && !this._fileTargetsToDelete.isEmpty();
    }
}

