/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff.handlers;

import com.oracle.cie.common.util.DiffReport;
import com.oracle.cie.common.util.ElfDiffHelper;
import com.oracle.cie.common.util.JarDiff;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.JarUtils;
import com.oracle.cie.common.util.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class ElfDiffHandler
implements JarDiff.DiffHandler {
    private static Logger _log = Logger.getLogger(ElfDiffHandler.class.getName());
    private List<String> _handledTypes;
    private DiffReport _report;

    public ElfDiffHandler(String[] handledTypes, DiffReport report) {
        this._report = report;
        this._handledTypes = Arrays.asList(handledTypes);
    }

    public ElfDiffHandler(DiffReport report) {
        this._report = report;
    }

    public boolean isHandled(File jarFile, String entryName) throws Exception {
        boolean handled = this.isExtensionFound(entryName);
        if (handled) {
            if (JarUtils.isArchive((File)jarFile) && JarUtils.contains((File)jarFile, (String)entryName)) {
                File tempFile = JarUtils.extractIntoTempFile((File)jarFile, (String)entryName);
                handled = ElfDiffHelper.getInstance().isElfFile(tempFile);
                tempFile.deleteOnExit();
            } else {
                handled = ElfDiffHelper.getInstance().isElfFile(jarFile);
            }
        }
        return handled;
    }

    public boolean isHandled(JarHelper jarHandler, String entryName) throws Exception {
        boolean handled = this.isExtensionFound(entryName);
        if (handled && JarUtils.contains((JarHelper)jarHandler, (String)entryName)) {
            File tempFile = JarUtils.extractIntoTempFile((JarHelper)jarHandler, (String)entryName);
            handled = ElfDiffHelper.getInstance().isElfFile(tempFile);
        }
        return handled;
    }

    private boolean isExtensionFound(String entryName) throws Exception {
        if (StringUtil.isNullOrEmpty((String)entryName)) {
            throw new Exception("The entry name is not provided.");
        }
        if (entryName.lastIndexOf(".") == -1) {
            return true;
        }
        String extension = entryName.substring(entryName.lastIndexOf(".") + 1);
        if (StringUtil.isNullOrEmpty((String)extension)) {
            return false;
        }
        if (this._handledTypes != null && this._handledTypes.contains(extension)) {
            _log.finest(entryName + " is handled by ElfDiffHandler.");
            return true;
        }
        return false;
    }

    public boolean diff(String entryName, File file1, File file2) throws Exception {
        boolean isDifferent = false;
        if (ElfDiffHelper.getInstance().isLoaded()) {
            isDifferent = ElfDiffHelper.getInstance().validateDiff(file1, file2);
            if (isDifferent) {
                _log.finest("Elfdiff binary indicates files are different.");
            }
            if (this._report != null && isDifferent) {
                this._report.addDiff(entryName, " Binary file: elfdiff binary indicates files are different", null);
            }
        }
        return isDifferent;
    }

    public void setDiffReport(DiffReport report) {
        this._report = report;
    }
}

