/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.ftr;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.selection.Status;
import java.util.LinkedHashMap;
import java.util.Map;

public class ComponentReference
extends Reference {
    private Status _status = Status.notinstalled;
    private boolean _packaged = true;
    Map<String, Status> _componentTargetStatuses = new LinkedHashMap<String, Status>();
    private String _originalVersion;
    private boolean _singleton = false;
    private String _patch = null;
    private String _patchLevel;

    public ComponentReference(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public ComponentReference() {
        this(FeatureSetHelper.getInstance().create("component-ref"));
    }

    public ComponentReference(ClassLoader classLoader) {
        this(FeatureSetHelper.getInstance(classLoader).create("component-ref"));
    }

    public ComponentReference(String name, String version) {
        this();
        this.setName(name);
        this.setVersion(version);
    }

    public ComponentReference(String name, String version, ClassLoader classLoader) {
        this(classLoader);
        this.setName(name);
        this.setVersion(version);
    }

    public boolean isOptional() {
        return this.getBooleanAttribute("optional");
    }

    public void setOptional(Boolean optional) {
        this.setAttribute("optional", optional);
    }

    public boolean hasPomGen() {
        return this.getBooleanAttribute("pom-gen");
    }

    public void setPomGen(boolean pomGen) {
        this.setAttribute("pom-gen", pomGen);
    }

    public Status getStatus() {
        return this._status;
    }

    public void setStatus(Status status) {
        this._status = status;
        if (this._status.isNotInstalled()) {
            for (String qualifier : this._componentTargetStatuses.keySet()) {
                this._componentTargetStatuses.put(qualifier, status);
            }
        }
    }

    public boolean isPackaged() {
        return this._packaged;
    }

    public void setPackaged(boolean packaged) {
        this._packaged = packaged;
    }

    public void setComponentTargetStatus(String qualifier, Status status) {
        this._componentTargetStatuses.put(qualifier, status);
    }

    public Status getComponentTargetStatus(String qualifier) {
        Status status = this._componentTargetStatuses.get(qualifier);
        return status != null ? status : Status.notinstalled;
    }

    public String getOriginalVersion() {
        return this.hasOriginalVersion() ? this._originalVersion : this.getVersion();
    }

    public void setOriginalVersion(String currentVersion) {
        this._originalVersion = currentVersion;
    }

    public boolean hasOriginalVersion() {
        return !StringUtil.isNullOrEmpty((String)this._originalVersion, (boolean)true);
    }

    public void setSingleton(boolean singleton) {
        this._singleton = singleton;
    }

    public boolean isSingleton() {
        return this._singleton;
    }

    public boolean isPatch() {
        return !StringUtil.isNullOrEmpty((String)this._patch, (boolean)true);
    }

    public String getPatch() {
        return this._patch;
    }

    public void setPatch(String patch) {
        this._patch = patch;
    }

    public String getPatchLevel() {
        return this._patchLevel;
    }

    public void setPatchLevel(String patchLevel) {
        this._patchLevel = patchLevel;
    }

    public void resetState() {
        this.setStatus(Status.notinstalled);
        this.setSingleton(false);
        this.setPatchLevel(null);
        if (this.hasOriginalVersion()) {
            this.setVersion(this.getOriginalVersion());
            this.setOriginalVersion(null);
        }
        this._componentTargetStatuses.clear();
    }
}

