/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.inv;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.gdr.dao.inv.FeatureSetGroupReference;
import com.oracle.cie.gdr.helpers.InventoryHelper;

public class DistributionReference
extends AbstractDataHandlerWrapper {
    public DistributionReference(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public DistributionReference(String name, String version) {
        this(InventoryHelper.getInstance().create("distribution"));
        this.setName(name);
        this.setVersion(version);
    }

    public DistributionReference(String name, String version, FeatureSetGroupReference featureSetGroup) {
        this(InventoryHelper.getInstance().create("distribution"));
        this.setName(name);
        this.setVersion(version);
        this.setFeatureSetGroup(featureSetGroup);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public String getVersion() {
        return this.getStringAttribute("version");
    }

    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public void setOracleHomeDiff(String oracleHomeDiff) {
        this.setAttribute("oh-diff", oracleHomeDiff);
    }

    public String getOracleHomeDiff() {
        return this.getStringAttribute("oh-diff");
    }

    public FeatureSetGroupReference getFeatureSetGroup() {
        return (FeatureSetGroupReference)((Object)this.getSingleOccuranceComplexValueWrapped("feature-sets", FeatureSetGroupReference.class));
    }

    public void setFeatureSetGroup(FeatureSetGroupReference featureSetGroup) {
        this.setSingleOccuranceComplexValueWrapped("feature-sets", (IDataHandlerWrapper)featureSetGroup);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !DistributionReference.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        DistributionReference reference = (DistributionReference)((Object)o);
        String name = this.getName();
        String version = this.getVersion();
        String otherName = reference.getName();
        String otherVersion = reference.getVersion();
        return !(name == null ? otherName != null : !name.equals(otherName)) && !(version == null ? otherVersion != null : !version.equals(otherVersion));
    }

    public int hashCode() {
        String name = this.getName();
        String version = this.getVersion();
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (version != null ? version.hashCode() : 0);
        return result;
    }

    public String toString() {
        String version = this.getVersion();
        if (version == null) {
            return this.getName();
        }
        return this.getName() + " " + version;
    }
}

