/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.inv;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.helpers.InventoryHelper;

public class PatchReference
extends AbstractDataHandlerWrapper {
    public PatchReference(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public PatchReference(String patchId, String uniquePatchId) {
        this(InventoryHelper.getInstance().create("patch"));
        this.setPatchId(patchId);
        this.setUniquePatchId(uniquePatchId);
    }

    public String getPatchId() {
        return this.getStringAttribute("patch-id");
    }

    public void setPatchId(String patchId) {
        this.setAttribute("patch-id", patchId);
    }

    public String getUniquePatchId() {
        return this.getStringAttribute("unique-patch-id");
    }

    public void setUniquePatchId(String uniquePatchId) {
        this.setAttribute("unique-patch-id", uniquePatchId);
    }

    public void setOracleHomeDiff(String oracleHomeDiff) {
        this.setAttribute("oh-diff", oracleHomeDiff);
    }

    public String getOracleHomeDiff() {
        return this.getStringAttribute("oh-diff");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !PatchReference.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        PatchReference patchRef = (PatchReference)((Object)o);
        String patchId = this.getPatchId();
        String uniquePatchId = this.getUniquePatchId();
        String otherPatchId = patchRef.getPatchId();
        String otherUniquePatchId = patchRef.getUniquePatchId();
        return !(patchId == null ? otherPatchId != null : !patchId.equals(otherPatchId)) && !(uniquePatchId == null ? otherUniquePatchId != null : !uniquePatchId.equals(otherUniquePatchId));
    }

    public int hashCode() {
        String patchId = this.getPatchId();
        String uniquePatchId = this.getUniquePatchId();
        int result = patchId != null ? patchId.hashCode() : 0;
        result = 31 * result + (uniquePatchId != null ? uniquePatchId.hashCode() : 0);
        return result;
    }

    public String toString() {
        String uniquePatchId = this.getUniquePatchId();
        if (uniquePatchId == null) {
            return this.getPatchId();
        }
        return this.getPatchId() + " " + uniquePatchId;
    }
}

