/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.pad;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.gdr.helpers.PatchArtifactDefinitionHelper;
import com.oracle.cie.gdr.utils.GdrException;

public class Artifact
extends AbstractDataHandlerWrapper {
    public Artifact(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public Artifact() {
        this(PatchArtifactDefinitionHelper.getInstance().create("artifact"));
    }

    public Artifact(com.oracle.cie.dependency.mgmt.Artifact artifact) {
        this(PatchArtifactDefinitionHelper.getInstance().create("artifact"));
        this.setGroupId(artifact.getGroup());
        this.setArtifactId(artifact.getName());
        this.setVersion(artifact.getVersion().getVersion());
    }

    public void setGroupId(String groupId) {
        this.setAttribute("groupId", groupId);
    }

    public String getGroupId() {
        return this.getStringAttribute("groupId");
    }

    public void setArtifactId(String artifactId) {
        this.setAttribute("artifactId", artifactId);
    }

    public String getArtifactId() {
        return this.getStringAttribute("artifactId");
    }

    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public String getVersion() {
        return this.getStringAttribute("version");
    }

    public com.oracle.cie.dependency.mgmt.Artifact getArtifact(String type) throws GdrException {
        if (StringUtil.isNullOrEmpty((String)type, (boolean)true)) {
            throw new GdrException("The patch definition artifact type provided was null or empty.");
        }
        String groupId = this.getGroupId();
        if (StringUtil.isNullOrEmpty((String)groupId, (boolean)true)) {
            throw new GdrException("The patch definition artifact provided had a null or empty group id " + (Object)((Object)this));
        }
        String artifactId = this.getArtifactId();
        if (StringUtil.isNullOrEmpty((String)artifactId, (boolean)true)) {
            throw new GdrException("The patch definition artifact provided had a null or empty artifact id " + (Object)((Object)this));
        }
        String version = this.getVersion();
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            throw new GdrException("The patch definition artifact provided had a null or empty version " + (Object)((Object)this));
        }
        return DependencyManagementFactory.getInstance().getArtifact(groupId, artifactId, version, type);
    }
}

