/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.deinstallation;

import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTargetFactory;
import com.oracle.cie.gdr.external.FederatedRelationship;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeInstallationValidator {
    private static final Logger _log = Logger.getLogger(DeInstallationValidator.class.getName());
    private DistributionLoader _distributionLoader;
    private Home _home;
    private Set<FeatureSet> _selectedFeatures;

    public DeInstallationValidator(DistributionLoader distributionLoader, Set<FeatureSet> selectedFeatures, Home home) {
        this._distributionLoader = distributionLoader;
        this._selectedFeatures = selectedFeatures;
        this._home = home;
    }

    public DistributionLoader getDistributionLoader() {
        return this._distributionLoader;
    }

    public Home getHome() {
        return this._home;
    }

    public static void validate(DistributionLoader distributionLoader, Set<FeatureSet> selectedFeatures, Home home) throws DependencyException {
        new DeInstallationValidator(distributionLoader, selectedFeatures, home).validate();
    }

    public void validate() throws DependencyException {
        this.validateDependencies();
    }

    public Set<FeatureSet> getDependencyFeatureSets() throws DependencyException {
        LinkedHashSet<FeatureSet> dependencyFeatureSets = new LinkedHashSet<FeatureSet>();
        Collection<DistributionTarget> distributionTargets = this.getHome().getInstalledDistributions();
        if (this.getHome().isFederatedHome()) {
            try {
                distributionTargets.addAll(this.getHome().getFederatedInstalledDistributions(FederatedRelationship.BIDIRECTIONAL_CHAINED, false));
            }
            catch (Exception e) {
                throw new DependencyException("Failed to get installed distributions.", (Throwable)e);
            }
        }
        for (DistributionTarget distributionTarget : distributionTargets) {
            dependencyFeatureSets.addAll(distributionTarget.getInstalledFeatureSets());
        }
        return dependencyFeatureSets;
    }

    public Set<FeatureSet> getInstalledFeatureSets() throws DependencyException {
        Set<FeatureSet> installedItems = this.getHome().getInstalledFeatures();
        if (this.getHome().isFederatedHome()) {
            try {
                installedItems.addAll(this.getHome().getFederatedInstalledFeatures(FederatedRelationship.BIDIRECTIONAL_CHAINED, false));
            }
            catch (Exception e) {
                throw new DependencyException("Failed to get installed feature sets.", (Throwable)e);
            }
        }
        for (FeatureSet feature : this.getDistributionLoader().getFeatureSets()) {
            installedItems.remove(feature);
        }
        return installedItems;
    }

    protected void validateDependencies() throws DependencyException {
        if (this._selectedFeatures != null && !this._selectedFeatures.isEmpty()) {
            LinkedHashSet<FeatureSet> selectedFeaturesFiltered = new LinkedHashSet<FeatureSet>(this._selectedFeatures);
            if (this.getHome().isFederatedHome()) {
                try {
                    selectedFeaturesFiltered.removeAll(this.getHome().getFederatedInstalledFeatures(FederatedRelationship.BIDIRECTIONAL_CHAINED, false));
                }
                catch (Exception e) {
                    throw new DependencyException("Failed to get installed feature sets.", (Throwable)e);
                }
            }
            Set<FeatureSet> featureSets = this.getDependencyFeatureSets();
            FeatureSelectionTarget selectionTarget = FeatureSelectionTargetFactory.getFeatureSelectionTarget(featureSets, this.getInstalledFeatureSets(), Mode.DEINSTALL);
            selectionTarget.setSelectableItems(featureSets);
            for (FeatureSet feature : selectedFeaturesFiltered) {
                if (!feature.getStatus().isInstalled() || selectionTarget.isSelected(feature)) continue;
                selectionTarget.selectWithPrerequisites(feature, true);
            }
            for (FeatureSet feature : selectedFeaturesFiltered) {
                if (!feature.getStatus().isInstalled() || !selectionTarget.isSelected(feature)) continue;
                try {
                    selectionTarget.unselectWithDependents(feature, true);
                }
                catch (DependencyException e) {
                    _log.log(Level.FINEST, "Encountered dependency exception while attempting to select the feature set " + feature + " for de-installation.", e);
                    throw e;
                }
            }
        }
    }
}

