/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.deinstallation.DistributionDeInstallationSession;
import com.oracle.cie.gdr.deinstallation.FeatureSetDeInstallationSession;
import com.oracle.cie.gdr.external.DeInstallerSession;
import com.oracle.cie.gdr.external.InstallType;
import com.oracle.cie.gdr.external.InstallerSession;
import com.oracle.cie.gdr.external.Session;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.installation.DistributionInstallationSession;
import com.oracle.cie.gdr.installation.FeatureArchiveInstallationSession;
import com.oracle.cie.gdr.selection.SelectableFeatureSet;
import com.oracle.cie.gdr.selection.SelectableFeatureSetGroup;
import com.oracle.cie.gdr.session.CommonSession;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.tree.TreeModel;

public class InstallerConfig {
    private static final Logger _log = Logger.getLogger(InstallerConfig.class.getName());

    public static InstallerSession getInstallerSession(File shipHomeDir) throws GdrException, DependencyException, IOException, DataHandlerException {
        return InstallerConfig.getInstallerSession(shipHomeDir, null);
    }

    public static InstallerSession getInstallerSession(File shipHomeDir, Set<Integer> platforms, Set<Integer> locales) throws GdrException, DependencyException, IOException, DataHandlerException {
        return InstallerConfig.getInstallerSession(shipHomeDir, null, platforms, locales);
    }

    public static InstallerSession getInstallerSession(File shipHomeDir, File homeDir) throws GdrException, DependencyException, IOException, DataHandlerException {
        return InstallerConfig.getInstallerSession(shipHomeDir, homeDir, null, null);
    }

    public static InstallerSession getInstallerSession(File shipHomeDir, File homeDir, Set<Integer> platforms, Set<Integer> locales) throws GdrException, DependencyException, IOException, DataHandlerException {
        return new DistributionInstallationSession(shipHomeDir, homeDir, platforms, locales);
    }

    public static DeInstallerSession getDeInstallerSession(File homeDir, Reference distributionReference) throws IOException, DataHandlerException, GdrException {
        return new DistributionDeInstallationSession(homeDir, distributionReference);
    }

    public static DeInstallerSession getDeInstallerSession(File homeDir, Map<Distribution, Set<FeatureSet>> mixedReferencesMap) throws IOException, DataHandlerException, GdrException {
        return new FeatureSetDeInstallationSession(homeDir, mixedReferencesMap);
    }

    public static InstallerSession getFeatureArchiveInstallerSession(File featureArchive) throws GdrException, DependencyException, IOException, DataHandlerException {
        return InstallerConfig.getFeatureArchiveInstallerSession(featureArchive, null, null, null);
    }

    public static InstallerSession getFeatureArchiveInstallerSession(File featureArchive, File homeDir, Set<Integer> platforms, Set<Integer> locales) throws GdrException, DependencyException, IOException, DataHandlerException {
        return InstallerConfig.getFeatureArchiveInstallerSession(featureArchive, homeDir, (String)null, platforms, locales);
    }

    public static InstallerSession getFeatureArchiveInstallerSession(File featureArchive, File homeDir, Map<String, Set<String>> dirMap, Set<Integer> platforms, Set<Integer> locales) throws GdrException, DependencyException, IOException, DataHandlerException {
        return new FeatureArchiveInstallationSession(featureArchive, homeDir, DistributionHelper.getInstance().createDirectoryMap(dirMap), platforms, locales, null);
    }

    public static InstallerSession getFeatureArchiveInstallerSession(File featureArchive, File homeDir, String directory, Set<Integer> platforms, Set<Integer> locales) throws GdrException, DependencyException, IOException, DataHandlerException {
        return new FeatureArchiveInstallationSession(featureArchive, homeDir, DistributionHelper.getInstance().createRegexDirectoryMap(directory, null), platforms, locales, null);
    }

    public static String getDistributionLocalizedExternalName(Session session) {
        if (CommonSession.class.isAssignableFrom(session.getClass())) {
            return ((CommonSession)session).getDistributionLocalizedExternalName();
        }
        throw new UnsupportedOperationException("The session object provided does not support this operation.");
    }

    public static String getDistributionLocalizedExternalShortName(Session session) {
        if (CommonSession.class.isAssignableFrom(session.getClass())) {
            return ((CommonSession)session).getDistributionLocalizedExternalShortName();
        }
        throw new UnsupportedOperationException("The session object provided does not support this operation.");
    }

    public static String getDistributionExternalVersion(Session session) {
        if (CommonSession.class.isAssignableFrom(session.getClass())) {
            return ((CommonSession)session).getDistributionExternalVersion();
        }
        throw new UnsupportedOperationException("The session object provided does not support this operation.");
    }

    public static String getDistributionLocalizedDescription(Session session) {
        if (CommonSession.class.isAssignableFrom(session.getClass())) {
            return ((CommonSession)session).getDistributionLocalizedDescription();
        }
        throw new UnsupportedOperationException("The session object provided does not support this operation.");
    }

    public static Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>> getFeatureSelectionWrappers(Session session) {
        if (CommonSession.class.isAssignableFrom(session.getClass())) {
            return ((CommonSession)session).getFeatureSelectionWrappers();
        }
        throw new UnsupportedOperationException("The session object provided does not support this operation.");
    }

    public static TreeModel getFeatureSelectionTreeModel(Session session) {
        if (CommonSession.class.isAssignableFrom(session.getClass())) {
            return ((CommonSession)session).getFeatureSelectionTreeModel();
        }
        throw new UnsupportedOperationException("The session object provided does not support this operation.");
    }

    public static void setSelectedFeatures(Session session, Set<Reference> featureRefs) throws GdrException, DependencyException {
        if (!CommonSession.class.isAssignableFrom(session.getClass())) {
            throw new UnsupportedOperationException("The session object provided does not support this operation.");
        }
        ((CommonSession)session).setSelectedFeatures(featureRefs);
    }

    public static Set<String> getInstallTypes(InstallerSession session) {
        LinkedHashSet<String> installTypeNames = new LinkedHashSet<String>();
        Set<InstallType> installTypes = session.getInstallTypes();
        if (installTypes != null && !installTypes.isEmpty()) {
            for (InstallType installType : installTypes) {
                installTypeNames.add(installType.getName());
            }
        }
        return installTypeNames;
    }

    public static String getInstallTypeLocalizedExternalName(InstallerSession session, String installTypeName) {
        Set<InstallType> installTypes = session.getInstallTypes();
        for (InstallType installType : installTypes) {
            if (!installType.getName().equals(installTypeName)) continue;
            return installType.getLocalizedExternalName();
        }
        return installTypeName;
    }

    public static String getDefaultInstallType(InstallerSession session) {
        InstallType installType = session.getDefaultInstallType();
        return installType != null ? installType.getName() : null;
    }

    public static void setInstallType(InstallerSession session, String name) throws DependencyException, GdrException {
        InstallType installType = null;
        Set<InstallType> installTypes = session.getInstallTypes();
        if (installTypes != null && !installTypes.isEmpty()) {
            for (InstallType it : installTypes) {
                if (!it.getName().equals(name)) continue;
                installType = it;
                break;
            }
        }
        if (installType == null) {
            GdrException ex = new GdrException("The specified install type did not exist: " + name);
            _log.throwing(InstallerConfig.class.getName(), "setInstallType", ex);
            throw ex;
        }
        session.setInstallType(installType);
    }

    public static Map<Reference, Map<SelectableFeatureSetGroup, List<SelectableFeatureSet>>> getInstalledDistributionInfo(Session session) {
        if (CommonSession.class.isAssignableFrom(session.getClass())) {
            return ((CommonSession)session).getInstalledDistributionInfo();
        }
        throw new UnsupportedOperationException("The session object provided does not support this operation.");
    }

    public static long getFeatureSize(InstallerSession session, Reference featureRef) {
        return session.getFeatureSize(featureRef);
    }

    public static long getTotalInstallationSize(InstallerSession session) {
        return session.getTotalInstallationSize();
    }

    public static Reference createReference(String name, String version) {
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            NullPointerException ex = new NullPointerException("The name specified was null or empty");
            _log.throwing(InstallerConfig.class.getName(), "createReference", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            NullPointerException ex = new NullPointerException("The version specified was null or empty");
            _log.throwing(InstallerConfig.class.getName(), "createReference", ex);
            throw ex;
        }
        return new QuickReference(name, version);
    }

    public static Map<Distribution, Set<FeatureSet>> createMixedReference(File ohDir, String name, String version) throws IOException, DataHandlerException, GdrException {
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            NullPointerException ex = new NullPointerException("The name specified was null or empty");
            _log.throwing(InstallerConfig.class.getName(), "createMixedReference", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            NullPointerException ex = new NullPointerException("The version specified was null or empty");
            _log.throwing(InstallerConfig.class.getName(), "createMixedReference", ex);
            throw ex;
        }
        DistributionTarget distTarget = Home.getHome(ohDir).getInstalledDistribution(name, version);
        if (distTarget == null) {
            NullPointerException ex = new NullPointerException("There is no installed distribution with given name and version");
            _log.throwing(InstallerConfig.class.getName(), "createMixedReference", ex);
            throw ex;
        }
        Set<FeatureSet> installedFeatures = distTarget.getInstalledFeatureSets();
        HashMap<Distribution, Set<FeatureSet>> mixedReferenceMap = new HashMap<Distribution, Set<FeatureSet>>();
        mixedReferenceMap.put(distTarget.getDistribution(), installedFeatures);
        return mixedReferenceMap;
    }
}

