/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.builder.impl;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.Checksum;
import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.ManifestBuilder;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.TempFileHandler;
import com.oracle.cie.dependency.dao.ConditionalOp;
import com.oracle.cie.dependency.dao.Dependency;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.dependency.dao.VersionRange;
import com.oracle.cie.gdr.Version;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.Components;
import com.oracle.cie.gdr.dao.ftr.FeatureLibrary;
import com.oracle.cie.gdr.dao.ftr.FeatureReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.external.builder.BuilderFactory;
import com.oracle.cie.gdr.external.builder.BuilderReference;
import com.oracle.cie.gdr.external.builder.FeatureLibraryBuilder;
import com.oracle.cie.gdr.external.builder.FeatureSetBuilder;
import com.oracle.cie.gdr.external.builder.impl.FeatureLibraryBuilderImpl;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class FeatureSetBuilderImpl
implements FeatureSetBuilder {
    private FeatureSet _featureSet;
    private Components _defaultComponents;
    private List<FeatureLibrary> _cachedFeatureLibraries;
    private List<Components> _components;
    private Map<Locale, Properties> _properties = new HashMap<Locale, Properties>();

    public FeatureSetBuilderImpl(String name, String version) throws BuilderException {
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            throw new BuilderException("The feature set name was null or empty.");
        }
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            throw new BuilderException("The feature set version was null or empty.");
        }
        this._featureSet = new FeatureSet(name, version);
        this.setDisplayName(name);
    }

    @Override
    public String getName() {
        return this._featureSet.getName();
    }

    @Override
    public String getVersion() {
        return this._featureSet.getVersion();
    }

    @Override
    public String getDisplayName() {
        return this._featureSet.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) {
        this._featureSet.setDisplayName(displayName);
    }

    @Override
    public String getDisplayNameKey() {
        return this._featureSet.getDisplayNameKey();
    }

    @Override
    public void setDisplayNameKey(String key) {
        this._featureSet.setDisplayNameKey(key);
    }

    @Override
    public String getDescription() {
        return this._featureSet.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this._featureSet.setDescription(description);
    }

    @Override
    public String getDescriptionKey() {
        return this._featureSet.getDescriptionKey();
    }

    @Override
    public void setDescriptionKey(String key) {
        this._featureSet.setDescriptionKey(key);
    }

    @Override
    public String getConsumptionType() {
        return this._featureSet.getConsumptionType();
    }

    @Override
    public void setConsumptionType(String consumptionType) {
        this._featureSet.setConsumptionType(consumptionType);
    }

    @Override
    public String getType() {
        return this._featureSet.getType();
    }

    @Override
    public void setType(String type) {
        this._featureSet.setType(type);
    }

    @Override
    public String getSubType() {
        return this._featureSet.getSubType();
    }

    @Override
    public void setSubType(String subType) {
        this._featureSet.setSubType(subType);
    }

    @Override
    public void setThirdParty(String thirdParty) {
        if (!StringUtil.isNullOrEmpty((String)thirdParty)) {
            this._featureSet.setThirdParty(Boolean.valueOf(thirdParty));
        }
    }

    @Override
    public boolean isSingleton() {
        return this._featureSet.isSingleton();
    }

    @Override
    public void setSingleton(String singleton) {
        if (!StringUtil.isNullOrEmpty((String)singleton)) {
            this._featureSet.setSingleton(Boolean.valueOf(singleton));
        }
    }

    @Override
    public String getPomGen() {
        return this._featureSet.hasPomGen() + "";
    }

    @Override
    public void setPomGen(boolean pomGen) {
        this._featureSet.setPomGen(pomGen);
    }

    @Override
    public void setPomGen(String pomGen) {
        if (!StringUtil.isNullOrEmpty((String)pomGen)) {
            this.setPomGen(Boolean.parseBoolean(pomGen));
        }
    }

    @Override
    public void setMultiVersion(String multiVersion) {
        if (!StringUtil.isNullOrEmpty((String)multiVersion)) {
            this._featureSet.setMultiVersion(Boolean.parseBoolean(multiVersion));
        }
    }

    @Override
    public void addComponent(String name, String version) {
        this.addComponent(name, version, false);
    }

    @Override
    public void addComponent(String name, String version, boolean optional) {
        if (this._defaultComponents == null) {
            this._defaultComponents = new Components();
        }
        List<ComponentReference> componentReferences = this._defaultComponents.getComponentReferences();
        ComponentReference componentReference = new ComponentReference(name, version);
        if (optional) {
            componentReference.setOptional(true);
        }
        componentReferences.add(componentReference);
        this._defaultComponents.setComponentReferences(componentReferences);
    }

    @Override
    public void addLibrary(FeatureLibraryBuilder library) {
        if (this._cachedFeatureLibraries == null) {
            this._cachedFeatureLibraries = new ArrayList<FeatureLibrary>();
        }
        this._cachedFeatureLibraries.add(((FeatureLibraryBuilderImpl)library).getFeatureLibrary());
    }

    @Override
    public List<FeatureLibrary> getLibraries() {
        return this._cachedFeatureLibraries;
    }

    @Override
    public void addComponents(List<BuilderReference> references) {
        this.addComponents(references, null);
    }

    @Override
    public void addComponents(List<BuilderReference> references, String constraint) {
        if (references != null && !references.isEmpty()) {
            if (this._components == null) {
                this._components = new ArrayList<Components>();
            }
            Components components = new Components();
            this._components.add(components);
            if (!StringUtil.isNullOrEmpty((String)constraint, (boolean)true)) {
                components.setConstraint(constraint);
            }
            ArrayList<ComponentReference> componentReferences = new ArrayList<ComponentReference>();
            for (BuilderReference reference : references) {
                ComponentReference componentReference = new ComponentReference(reference.getName(), reference.getVersion());
                if (reference.isOptional()) {
                    componentReference.setOptional(true);
                }
                componentReferences.add(componentReference);
            }
            components.setComponentReferences(componentReferences);
        }
    }

    @Override
    public void addCompatibility(BuilderReference reference) {
        this.addCompatibility(reference, false);
    }

    @Override
    public void addCompatibility(BuilderReference reference, boolean reciprocal) {
        List<FeatureReference> featureReferences = this._featureSet.getCompatibleFeatures();
        FeatureReference featureReference = new FeatureReference(reference.getName(), reference.getVersion());
        List<VersionRange> versionRanges = this.getVersionRanges(reference);
        if (versionRanges != null) {
            featureReference.setVersionRanges(versionRanges);
        }
        if (reciprocal) {
            featureReference.setReciprocal(true);
        }
        featureReferences.add(featureReference);
        this._featureSet.setCompatibleFeatures(featureReferences);
    }

    @Override
    public void addAndDependency(String name, String version) {
        ArrayList<BuilderReference> references = new ArrayList<BuilderReference>();
        references.add(BuilderFactory.getBuilderReference(name, version));
        this.addAndDependencies(references);
    }

    @Override
    public void addAndDependencies(List<BuilderReference> references) {
        if (references != null && !references.isEmpty()) {
            Dependency dependency = this._featureSet.getDependency(true);
            if (!dependency.isSetRequires() && references.size() == 1) {
                dependency.setRequires(this.getDependencyRef(references.get(0)));
            } else {
                ConditionalOp and;
                ArrayList<DependencyRef> dependencyRefs = new ArrayList<DependencyRef>();
                if (dependency.isSetRequires()) {
                    dependencyRefs.add(dependency.getRequires());
                    dependency.setRequires(null);
                    and = new ConditionalOp(FeatureSetHelper.getInstance().create("http://xmlns.oracle.com/cie/gdr/ftr", "ConditionalOp"));
                    dependency.setAnd(and);
                } else {
                    and = dependency.getAnd();
                    if (and == null) {
                        and = new ConditionalOp(FeatureSetHelper.getInstance().create("http://xmlns.oracle.com/cie/gdr/ftr", "ConditionalOp"));
                        dependency.setAnd(and);
                    } else {
                        dependencyRefs.addAll(and.getRequires());
                    }
                }
                for (BuilderReference builderReference : references) {
                    dependencyRefs.add(this.getDependencyRef(builderReference));
                }
                and.setRequires(dependencyRefs);
            }
        }
    }

    protected DependencyRef getDependencyRef(BuilderReference builderReference) {
        DependencyRef dependencyRef = null;
        if (builderReference != null) {
            dependencyRef = new DependencyRef(FeatureSetHelper.getInstance().create("http://xmlns.oracle.com/cie/gdr/ftr", "DependencyRef"));
            dependencyRef.setName(builderReference.getName());
            dependencyRef.setVersion(builderReference.getVersion());
            List<VersionRange> versionRanges = this.getVersionRanges(builderReference);
            if (versionRanges != null) {
                dependencyRef.setVersionRanges(versionRanges);
            }
        }
        return dependencyRef;
    }

    protected List<VersionRange> getVersionRanges(BuilderReference builderReference) {
        ArrayList<VersionRange> versionRanges = null;
        if (builderReference != null) {
            String min = builderReference.getVersionRangeMin();
            String max = builderReference.getVersionRangeMax();
            if (!StringUtil.isNullOrEmpty((String)min, (boolean)true) || !StringUtil.isNullOrEmpty((String)max, (boolean)true)) {
                VersionRange versionRange = new VersionRange(FeatureSetHelper.getInstance().create("http://xmlns.oracle.com/cie/gdr/ftr", "VersionRange"));
                if (!StringUtil.isNullOrEmpty((String)min, (boolean)true)) {
                    versionRange.setMin(min);
                }
                if (!StringUtil.isNullOrEmpty((String)max, (boolean)true)) {
                    versionRange.setMax(max);
                }
                if (builderReference.isVersionRangeMinInclusiveSet()) {
                    versionRange.setMinInclusive(Boolean.valueOf(builderReference.isVersionRangeMinInclusive()));
                }
                if (builderReference.isVersionRangeMaxInclusiveSet()) {
                    versionRange.setMaxInclusive(Boolean.valueOf(builderReference.isVersionRangeMaxInclusive()));
                }
                versionRanges = new ArrayList<VersionRange>();
                versionRanges.add(versionRange);
            }
        }
        return versionRanges;
    }

    @Override
    public String getFeatureSetFileName() {
        return FeatureSetHelper.getInstance().getFeatureSetFileName(this._featureSet);
    }

    @Override
    public void addLocalizedProperty(String key, String value) {
        this.addLocalizedProperty(key, value, null);
    }

    @Override
    public void addLocalizedProperty(String key, String value, Locale locale) {
        Properties properties = this._properties.get(locale);
        if (properties == null) {
            properties = new Properties();
            this._properties.put(locale, properties);
        }
        properties.setProperty(key, value);
    }

    @Override
    public Properties getLocalizedProperties() {
        return this.getLocalizedProperties(null);
    }

    @Override
    public Properties getLocalizedProperties(Locale locale) {
        return this._properties.get(locale);
    }

    @Override
    public void setLocalizedProperties(Properties properties) {
        this.setLocalizedProperties(properties, null);
    }

    @Override
    public void setLocalizedProperties(Properties properties, Locale locale) {
        this._properties.put(locale, properties);
    }

    @Override
    public void save(File directory) throws BuilderException {
        if (directory == null) {
            throw new BuilderException("The specified save location was null.");
        }
        if (directory.exists() && !directory.isDirectory()) {
            throw new BuilderException("The specified save location was not a directory " + directory);
        }
        this.prepareToSave();
        File featuresDir = new File(directory, FeatureSetHelper.getInstance().getPath());
        featuresDir.mkdirs();
        File featureSetFile = new File(featuresDir, FeatureSetHelper.getInstance().getFeatureSetFileName(this._featureSet));
        try {
            FeatureSetHelper.getInstance().save((IDataHandlerWrapper)this._featureSet, featureSetFile);
        }
        catch (DataHandlerException e) {
            throw new BuilderException("Failed to save feature set file to " + featureSetFile, e);
        }
        if (this._properties != null && !this._properties.isEmpty()) {
            String baseName = FeatureSetHelper.getInstance().getResourceBundleBaseName(this._featureSet.getName(), this._featureSet.getVersion());
            File featureResourcesJar = new File(featuresDir, FeatureSetHelper.getInstance().getResourceLocation(this._featureSet.getName(), this._featureSet.getVersion()));
            try {
                File tmpDir = TempFileHandler.getTempFolder((String)"ftrRsc", (String)".tmp", (boolean)false);
                HashSet<File> resourceFiles = new HashSet<File>();
                File featureResourcesDir = new File(tmpDir, "resources/" + FeatureSetHelper.getFormattedNameVersion(this._featureSet.getName(), this._featureSet.getVersion()));
                resourceFiles.add(featureResourcesDir.getParentFile());
                resourceFiles.add(featureResourcesDir);
                for (Map.Entry<Locale, Properties> entry : this._properties.entrySet()) {
                    Locale locale = entry.getKey();
                    Properties properties = entry.getValue();
                    String jarEntry = baseName;
                    String comment = "Resource Bundle For " + this._featureSet.getName() + " " + this._featureSet.getVersion() + " Feature Set";
                    if (locale != null) {
                        jarEntry = jarEntry + "_" + locale.toString();
                        comment = locale.toString().toUpperCase() + " " + comment;
                    }
                    jarEntry = jarEntry + ".properties";
                    File propertiesFile = new File(tmpDir, jarEntry);
                    propertiesFile.getParentFile().mkdirs();
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(propertiesFile)){
                        int count;
                        {
                            this.count = 0;
                        }

                        @Override
                        public void write(String str) throws IOException {
                            if (str != null && str.startsWith("#")) {
                                ++this.count;
                                if (this.count != 2) {
                                    super.write(str);
                                }
                            } else {
                                super.write(str);
                            }
                        }
                    };
                    properties.store(bufferedWriter, comment);
                    bufferedWriter.close();
                    resourceFiles.add(propertiesFile);
                }
                featureResourcesJar.getParentFile().mkdirs();
                String contentsChecksum = Checksum.getMultiFileChecksum(resourceFiles, (int)(tmpDir.getAbsolutePath().length() + 1), (String)"MD5");
                JarHelper jarHelper = new JarHelper(featureResourcesJar, 1, this.getResourceJarManifest(contentsChecksum));
                jarHelper.append(tmpDir, false);
                jarHelper.close();
                Delete.delete((File)tmpDir, (boolean)true);
            }
            catch (Exception e) {
                throw new BuilderException("Failed to create feature set localized resources jar " + featureResourcesJar, e);
            }
        }
    }

    protected Manifest getResourceJarManifest(String contentsChecksum) throws IOException {
        HashMap<Attributes.Name, String> attribs = new HashMap<Attributes.Name, String>();
        attribs.put(Attributes.Name.SPECIFICATION_TITLE, "GDR L10N Resources");
        attribs.put(Attributes.Name.SPECIFICATION_VERSION, Version.getVersion());
        attribs.put(Attributes.Name.SPECIFICATION_VENDOR, Version.getVendor());
        attribs.put(new Attributes.Name(Attributes.Name.SPECIFICATION_VENDOR.toString() + "-Id"), Version.getVendorId());
        attribs.put(Attributes.Name.IMPLEMENTATION_TITLE, this._featureSet.getName());
        attribs.put(Attributes.Name.IMPLEMENTATION_VERSION, this._featureSet.getVersion());
        attribs.put(Attributes.Name.IMPLEMENTATION_VENDOR, Version.getVendor());
        attribs.put(Attributes.Name.IMPLEMENTATION_VENDOR_ID, Version.getVendorId());
        HashMap sectionAttribsMap = new HashMap();
        HashMap sectionAttribs = new HashMap(attribs);
        sectionAttribsMap.put(FeatureSetHelper.getInstance().getFeatureSetBaseFileName(this._featureSet.getName(), this._featureSet.getVersion()), sectionAttribs);
        attribs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attribs.put(new Attributes.Name("Created-By"), System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        attribs.put(new Attributes.Name("Contents-Checksum"), contentsChecksum != null ? contentsChecksum : "");
        return ManifestBuilder.getManifest(attribs, sectionAttribsMap);
    }

    protected void prepareToSave() {
        ArrayList<Components> components = new ArrayList<Components>();
        if (this._defaultComponents != null) {
            components.add(this._defaultComponents);
        }
        if (this._components != null && !this._components.isEmpty()) {
            components.addAll(this._components);
        }
        this._featureSet.setComponents(components);
        if (this._cachedFeatureLibraries != null && !this._cachedFeatureLibraries.isEmpty()) {
            this._featureSet.setLibraries(this._cachedFeatureLibraries);
        }
    }

    public String toString() {
        return this._featureSet.toString(false);
    }
}

