/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.aru.PatchType;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.external.ARUPatchMetadata;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ARUPatchMetadataImpl
implements ARUPatchMetadata {
    private PatchType _patch;
    private boolean _bootstrap;
    private List<Reference> _components = new ArrayList<Reference>();
    private String _description;

    ARUPatchMetadataImpl(PatchType patch) {
        this._patch = patch;
    }

    @Override
    public BigInteger getBug() {
        return this._patch.getBug();
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public String getPatchUrl() {
        return this._patch.getPatchUrl();
    }

    @Override
    public BigInteger getSize() {
        return this._patch.getSize();
    }

    public String toString() {
        return this._patch.getBug() + " - " + this._patch.getAbstract();
    }

    @Override
    public BigInteger getPatchId() {
        return this._patch.getPatchId();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ARUPatchMetadata)) {
            return false;
        }
        ARUPatchMetadata objARU = (ARUPatchMetadata)obj;
        return objARU.getDescription().equals(this.getDescription()) && objARU.getBug().equals(this.getBug()) && objARU.getPatchId().equals(this.getPatchId()) && objARU.getPatchUrl().equals(this.getPatchUrl()) && objARU.getSize().equals(this.getSize());
    }

    @Override
    public String getFileName() {
        return this.getPatchUrl().substring(this.getPatchUrl().lastIndexOf("=") + 1);
    }

    @Override
    public boolean isBootstrap() {
        return this._bootstrap;
    }

    @Override
    public void setBootstrap(boolean isBootstrap) {
        this._bootstrap = isBootstrap;
    }

    @Override
    public List<Reference> getComponents() {
        return this._components;
    }

    @Override
    public void setComponents(List<Reference> components) {
        if (components != null) {
            this._components = components;
        }
    }

    @Override
    public void addComponent(Reference component) {
        if (component != null) {
            this._components.add(component);
        }
    }
}

