/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionLoaderFactory;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.DummyHome;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.Version;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.FederatedRelationship;
import com.oracle.cie.gdr.external.FederatedSorting;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import com.oracle.cie.gdr.external.Patch;
import com.oracle.cie.gdr.external.impl.BaseInventoryImpl;
import com.oracle.cie.gdr.external.impl.ComponentImpl;
import com.oracle.cie.gdr.external.impl.DistributionImpl;
import com.oracle.cie.gdr.external.impl.FeatureSetImpl;
import com.oracle.cie.gdr.external.impl.InventoryCache;
import com.oracle.cie.gdr.external.impl.OracleHomeInventoryImpl;
import com.oracle.cie.gdr.external.impl.PatchImpl;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DummyOracleHomeInventoryImpl
extends BaseInventoryImpl
implements OracleHomeInventory {
    private static final Logger _log = Logger.getLogger(OracleHomeInventoryImpl.class.getName());
    private Set<ComponentReference> _componentReferences;
    private FeatureLoader _featureLoader;
    private com.oracle.cie.gdr.dao.dbd.Distribution _distribution;
    private Path _homePath;

    DummyOracleHomeInventoryImpl(File homeDir) throws InventoryException {
        this(NioHelper.getInstance().getPath(homeDir));
    }

    DummyOracleHomeInventoryImpl(Path homeDir) throws InventoryException {
        this._homePath = homeDir;
        String startupLocation = System.getProperty("oracle.installer.startup_location");
        File Disk1 = new File(startupLocation).getParentFile().getParentFile();
        com.oracle.cie.gdr.dao.ftr.FeatureSet dummyFeatureSet = null;
        try {
            this._metaDataHome = new MetaDataHome(new File(Disk1, ComponentHelper.getStageDir()), false);
            this._componentReferences = DummyHome.getInstance().getCachedBootstrapComponents(homeDir);
            HashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet> dummyFeature = null;
            if (this._componentReferences != null && !this._componentReferences.isEmpty()) {
                dummyFeature = new HashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet>();
                dummyFeatureSet = FeatureSetHelper.getInstance().createFeatureSet("DummyFeature", Version.getVersion(), this._componentReferences);
                dummyFeature.add(dummyFeatureSet);
            }
            this._featureLoader = new FeatureLoader(this._metaDataHome);
            this._featureLoader.addFeatureSet(dummyFeatureSet);
            FeatureSetGroup fsg = new FeatureSetGroup("DummyFeatureSetGroup");
            fsg.setFeatures(DistributionHelper.getInstance().getFeatureSetReferences(dummyFeature));
            ArrayList<FeatureSetGroup> fsgs = new ArrayList<FeatureSetGroup>();
            fsgs.add(fsg);
            Home home = Home.getHome(homeDir);
            Registry registry = home.getRegistry();
            SessionInfo registrySession = home.getRegistryHelper().getRegistrySession(registry, Mode.INSTALL);
            Set<com.oracle.cie.gdr.dao.dbd.Distribution> distributions = DistributionHelper.getInstance().getDistributions(this._metaDataHome.getGdrMetaDataHomePath());
            for (com.oracle.cie.gdr.dao.dbd.Distribution distribution : distributions) {
                DistributionLoader distLoader = DistributionLoaderFactory.getDistributionLoader(this._metaDataHome, distribution);
                HashSet<Reference> hashSet = new HashSet<Reference>();
                for (com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet : distLoader.getFeatureSets()) {
                    for (Reference reference : this._componentReferences) {
                        if (!featureSet.getComponentReferences().contains((Object)reference)) continue;
                        hashSet.add(reference);
                    }
                }
                if (!hashSet.equals(this._componentReferences)) continue;
                this._distribution = distribution;
            }
            DistributionInfo dinfo = home.getRegistryHelper().getDistributionInfo(registry, this._distribution.getName(), this._distribution.getVersion());
            if (dinfo == null) {
                dinfo = registry.addDistribution(this._distribution, registrySession, true);
                dinfo.setDynamic(true);
            } else {
                dinfo.addSession(registrySession);
            }
            dinfo.setStatus(Status.installed);
            FeatureInfo finfo = new FeatureInfo(home.getClassLoader(), dummyFeatureSet.getName(), dummyFeatureSet.getVersion());
            finfo.setDynamic(true);
            dinfo.addFeature(finfo);
            finfo.setStatus(Status.installed);
            for (Reference reference : this._componentReferences) {
                ComponentInfo cinfo = new ComponentInfo(home.getClassLoader(), reference.getName(), reference.getVersion());
                cinfo.setDynamic(true);
                finfo.addComponent(cinfo);
                cinfo.setStatus(Status.installed);
            }
            DummyHome.getInstance().setRegistry(homeDir, registry);
        }
        catch (DataHandlerException | GdrException | IOException anyException) {
            _log.log(Level.SEVERE, "A problem occurred while creating dummy home.", anyException);
            throw new InventoryException(anyException);
        }
    }

    @Override
    public Collection<Component> getComponents() throws InventoryException {
        HashSet<Component> components = new HashSet<Component>();
        Component cachedComponent = null;
        for (Reference reference : this._componentReferences) {
            cachedComponent = ComponentImpl.newInstance(reference.getName(), reference.getVersion(), this._metaDataHome, this._mode);
            InventoryCache.getInstance().putComponent(this._metaDataHome, cachedComponent);
            components.add(cachedComponent);
        }
        return components;
    }

    @Override
    public Component getComponent(String name, String version) throws InventoryException {
        for (Component component : this.getComponents()) {
            if (!component.getName().equals(name) || !component.getVersion().equals(version)) continue;
            return component;
        }
        return null;
    }

    @Override
    public File getHomeDir() {
        return this._homePath.toFile();
    }

    @Override
    public void enableInventoryCache() {
        InventoryCache.enableCache();
    }

    @Override
    public void disableInventoryCache() {
        InventoryCache.disableCache();
    }

    @Override
    public void cleanInventoryCache() {
        InventoryCache.getInstance().clearCache();
    }

    @Override
    public Path getHomeDirPath() {
        return this._homePath;
    }

    @Override
    public Collection<FeatureSet> getInstalledFeatureSets() throws InventoryException {
        LinkedHashSet<FeatureSet> featureSetsWrappers = new LinkedHashSet<FeatureSet>();
        FeatureSet cachedFeatureSet = null;
        for (com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet : this._featureLoader.getFeatureSets()) {
            cachedFeatureSet = InventoryCache.getInstance().getFeatureSet(this._metaDataHome, featureSet.getName(), featureSet.getVersion());
            if (null == cachedFeatureSet) {
                cachedFeatureSet = new FeatureSetImpl(featureSet, this._metaDataHome, Mode.DEINSTALL);
                InventoryCache.getInstance().putFeatureSet(this._metaDataHome, cachedFeatureSet);
            }
            featureSetsWrappers.add(cachedFeatureSet);
        }
        return featureSetsWrappers;
    }

    @Override
    public Collection<Component> getInstalledComponents() throws InventoryException {
        try {
            return this.getComponents();
        }
        catch (Exception exception) {
            throw new InventoryException(exception);
        }
    }

    @Override
    Collection<Component> getComponents(Collection<ComponentReference> componentsReferences) throws InventoryException {
        HashSet<Component> components = new HashSet<Component>();
        Component cachedComponent = null;
        for (ComponentReference componentReference : componentsReferences) {
            cachedComponent = InventoryCache.getInstance().getComponent(this._metaDataHome, componentReference.getName(), componentReference.getVersion());
            if (null == cachedComponent) {
                cachedComponent = ComponentImpl.newInstance(componentReference.getName(), componentReference.getVersion(), this._metaDataHome, this._mode);
                InventoryCache.getInstance().putComponent(this._metaDataHome, cachedComponent);
            }
            components.add(cachedComponent);
        }
        return components;
    }

    @Override
    public Collection<Distribution> getInstalledDistributions() throws InventoryException {
        LinkedHashSet<Distribution> distributions = new LinkedHashSet<Distribution>();
        Distribution cachedDistribution = InventoryCache.getInstance().getDistribution(this._metaDataHome, this._distribution.getName(), this._distribution.getVersion());
        if (null == cachedDistribution) {
            DistributionTarget distributionTarget = new DistributionTarget(this._distribution, this._featureLoader.getFeatureSets());
            cachedDistribution = new DistributionImpl(distributionTarget, this._metaDataHome);
            InventoryCache.getInstance().putDistribution(this._metaDataHome, cachedDistribution);
        }
        distributions.add(cachedDistribution);
        return distributions;
    }

    @Override
    public FeatureSet getInstalledFeatureSet(String name, String version) throws InventoryException {
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required to retrieve the installed feature set.");
        }
        for (FeatureSet featureSet : this.getInstalledFeatureSets()) {
            if (!name.equals(featureSet.getName()) || !version.equals(featureSet.getVersion())) continue;
            return featureSet;
        }
        return null;
    }

    @Override
    public Component getInstalledComponent(String name, String version) throws InventoryException {
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required for retrieving an installed component.");
        }
        for (Component component : this.getInstalledComponents()) {
            if (!name.equals(component.getName()) || !version.equals(component.getVersion())) continue;
            return component;
        }
        return null;
    }

    @Override
    public Distribution getInstalledDistribution(String name, String version) throws InventoryException {
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required for retrieving an installed distribution.");
        }
        for (Distribution distribution : this.getInstalledDistributions()) {
            if (!name.equals(distribution.getName()) || !version.equals(distribution.getVersion())) continue;
            return distribution;
        }
        return null;
    }

    @Override
    public Collection<Distribution> getInstalledDistributions(FeatureSet featureSet) throws InventoryException {
        if (null == featureSet) {
            throw new InventoryException("The feature set is required for retrieving the installed distributions.");
        }
        try {
            Collection<Distribution> distributionsTargets = this.getDistributionsTargets(featureSet);
            LinkedHashSet<Distribution> distributions = new LinkedHashSet<Distribution>();
            for (Distribution distributionTarget : distributionsTargets) {
                Distribution cachedDistribution = InventoryCache.getInstance().getDistribution(this._metaDataHome, distributionTarget.getName(), distributionTarget.getVersion());
                if (null == cachedDistribution) {
                    cachedDistribution = distributionTarget;
                    InventoryCache.getInstance().putDistribution(this._metaDataHome, cachedDistribution);
                }
                distributions.add(cachedDistribution);
            }
            return distributions;
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when retrieving the installed distributions.", anyException);
            throw new InventoryException(anyException);
        }
    }

    @Override
    public Collection<Distribution> getInstalledDistributions(Component component) throws InventoryException {
        return null;
    }

    public Collection<Distribution> getDistributionsTargets(FeatureSet featureSet) throws GdrException {
        if (null == featureSet) {
            GdrException ex = new GdrException("Method Argument featureSet is Null");
            _log.throwing(Home.class.getName(), "getInstalledDistributions", ex);
            throw ex;
        }
        HashSet<Distribution> parentDistributions = new HashSet<Distribution>();
        for (Distribution installedDistribution : this.getInstalledDistributions()) {
            for (com.oracle.cie.gdr.dao.ftr.FeatureSet installedFeatureSet : this._featureLoader.getFeatureSets()) {
                if (!featureSet.getName().equals(installedFeatureSet.getName()) || !featureSet.getVersion().equals(installedFeatureSet.getVersion())) continue;
                parentDistributions.add(installedDistribution);
            }
        }
        return parentDistributions;
    }

    @Override
    public Collection<FeatureSet> getInstalledFeatureSets(Component component) throws InventoryException {
        return null;
    }

    @Override
    public Patch getInstalledPatch(String patchId) throws InventoryException {
        if (StringUtil.isNullOrEmpty((String)patchId)) {
            throw new InventoryException("The patch Id is required.");
        }
        try {
            for (com.oracle.cie.gdr.dao.pch.Patch patch : DummyHome.getInstance().getCachedPatches(this._homePath)) {
                if (!patch.getPatchId().equals(patchId)) continue;
                return this.getPatch(patch);
            }
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when loading installed patch.", anyException);
            throw new InventoryException(anyException);
        }
        return null;
    }

    Patch getPatch(com.oracle.cie.gdr.dao.pch.Patch patch) {
        if (patch != null) {
            return new PatchImpl(patch, this._metaDataHome, Mode.DEINSTALL);
        }
        return null;
    }

    @Override
    public Collection<Patch> getInstalledPatches() throws InventoryException {
        try {
            return this.getPatches(DummyHome.getInstance().getCachedPatches(this._homePath));
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when loading installed patches.", anyException);
            throw new InventoryException(anyException);
        }
    }

    Collection<Patch> getPatches(Collection<com.oracle.cie.gdr.dao.pch.Patch> patches) throws InventoryException {
        ArrayList<Patch> patchesWrappers = new ArrayList<Patch>();
        Patch cachedPatch = null;
        for (com.oracle.cie.gdr.dao.pch.Patch patch : patches) {
            cachedPatch = InventoryCache.getInstance().getPatch(this._metaDataHome, patch.getPatchId());
            if (null == cachedPatch) {
                cachedPatch = new PatchImpl(patch, this._metaDataHome, Mode.DEINSTALL);
                InventoryCache.getInstance().putPatch(this._metaDataHome, cachedPatch);
            }
            patchesWrappers.add(cachedPatch);
        }
        return patchesWrappers;
    }

    @Override
    public Collection<Patch> getInstalledPatches(Distribution distribution) throws InventoryException {
        return null;
    }

    @Override
    public boolean isPatchInstalled(String patchId) throws InventoryException {
        if (StringUtil.isNullOrEmpty((String)patchId)) {
            throw new InventoryException("The name and version parameters are required.");
        }
        try {
            for (com.oracle.cie.gdr.dao.pch.Patch patch : DummyHome.getInstance().getCachedPatches(this._homePath)) {
                if (!patch.getPatchId().equals(patchId)) continue;
                return true;
            }
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when loading installed patch.", anyException);
            throw new InventoryException(anyException);
        }
        return false;
    }

    @Override
    public boolean isFeatureSetinstalled(String name, String version) throws InventoryException {
        return false;
    }

    @Override
    public boolean isComponentInstalled(String name, String version) throws InventoryException {
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required for verifying if the component is installed.");
        }
        for (Component component : this.getInstalledComponents()) {
            if (!name.equals(component.getName()) || !version.equals(component.getVersion())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDistributionInstalled(String name, String version) throws InventoryException {
        return false;
    }

    @Override
    public void refresh() throws InventoryException {
    }

    @Override
    public Collection<FeatureSet> getInstalledFeatureSets(String type, String subtype) throws InventoryException {
        return null;
    }

    @Override
    public Collection<FeatureSet> getInstalledFeatureSets(String type) throws InventoryException {
        return null;
    }

    @Override
    public String getGlobalUniqueID() throws InventoryException {
        return null;
    }

    @Override
    public boolean isFederatedHome() throws InventoryException {
        return false;
    }

    @Override
    public Collection<OracleHomeInventory> getFederatedOracleHomeInventories(FederatedRelationship relationship, boolean includeSelf) throws InventoryException {
        return null;
    }

    @Override
    public Collection<OracleHomeInventory> getFederatedOracleHomeInventories(FederatedRelationship relationship, FederatedSorting sorting, boolean includeSelf) throws InventoryException {
        return null;
    }

    @Override
    public Collection<Patch> getInstalledPatches(Component component) throws InventoryException {
        return null;
    }

    @Override
    public Collection<Patch> getInstalledPatches(FeatureSet featureSet) throws InventoryException {
        return null;
    }

    @Override
    protected MetaDataHome loadMetaDataHome(File metaDataHome) throws InventoryException {
        return null;
    }

    @Override
    protected MetaDataHome loadMetaDataHome(Path metaDataHome) throws InventoryException {
        return null;
    }
}

