/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureLibrary;
import com.oracle.cie.gdr.dao.ftr.FeatureReference;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.Library;
import com.oracle.cie.gdr.external.impl.ComponentImpl;
import com.oracle.cie.gdr.external.impl.InventoryCache;
import com.oracle.cie.gdr.external.impl.LibraryImpl;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeatureSetImpl
implements FeatureSet {
    private static final Logger _log = Logger.getLogger(FeatureSetImpl.class.getName());
    protected com.oracle.cie.gdr.dao.ftr.FeatureSet _featureSet;
    private MetaDataHome _metaDataHome;
    private Mode _mode;

    FeatureSetImpl() {
    }

    FeatureSetImpl(com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet, MetaDataHome metaDataHome, Mode mode) {
        this._featureSet = featureSet;
        this._metaDataHome = metaDataHome;
        this._mode = mode;
    }

    public static FeatureSet newInstance(com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet, MetaDataHome metaDatHome, Mode mode) {
        return new FeatureSetImpl(featureSet, metaDatHome, mode);
    }

    @Override
    public List<Component> getComponents() throws InventoryException {
        List<ComponentReference> componentRefs = this._featureSet.getComponentReferences();
        ArrayList<Component> components = new ArrayList<Component>();
        Component cachedComponent = null;
        for (ComponentReference componentRef : componentRefs) {
            cachedComponent = InventoryCache.getInstance().getComponent(this._metaDataHome, componentRef.getName(), componentRef.getVersion());
            if (null == cachedComponent) {
                cachedComponent = ComponentImpl.newInstance(componentRef.getName(), componentRef.getVersion(), this._metaDataHome, this._mode);
                InventoryCache.getInstance().putComponent(this._metaDataHome, cachedComponent);
            }
            components.add(cachedComponent);
        }
        return components;
    }

    @Override
    public List<FeatureSet> getCompatibleFeatures() throws InventoryException {
        return this.getFeatureSets(this._featureSet.getCompatibleFeatures());
    }

    List<FeatureSet> getFeatureSets(Collection<FeatureReference> featureSets) throws InventoryException {
        ArrayList<FeatureSet> featureSetsWrappers = new ArrayList<FeatureSet>();
        FeatureSet cachedFeatureSet = null;
        for (FeatureReference featureSet : featureSets) {
            cachedFeatureSet = InventoryCache.getInstance().getFeatureSet(this._metaDataHome, featureSet.getName(), featureSet.getVersion());
            if (null == cachedFeatureSet) {
                try {
                    cachedFeatureSet = new FeatureSetImpl(FeatureSetHelper.getInstance().getFeatureSet(this._metaDataHome.getGdrMetaDataHomePath(), featureSet.getName(), featureSet.getVersion()), this._metaDataHome, Mode.DEINSTALL);
                }
                catch (Exception anyException) {
                    _log.log(Level.SEVERE, "A problem occurred when loading the features.", anyException);
                    throw new InventoryException(anyException);
                }
                InventoryCache.getInstance().putFeatureSet(this._metaDataHome, cachedFeatureSet);
            }
            featureSetsWrappers.add(cachedFeatureSet);
        }
        return featureSetsWrappers;
    }

    @Override
    public String getName() {
        return this._featureSet.getName();
    }

    @Override
    public String getVersion() {
        return this._featureSet.getVersion();
    }

    @Override
    public String getDisplayName() {
        return this._featureSet.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this._featureSet.getDescription();
    }

    @Override
    public boolean isExternal() {
        return this._featureSet.isExternal();
    }

    @Override
    public boolean isSelected() {
        return this._featureSet.isSelected();
    }

    @Override
    public boolean isRequired() {
        return this._featureSet.isRequired();
    }

    @Override
    public boolean isVisible() {
        return this._featureSet.isVisible();
    }

    @Override
    public boolean isGeneric() {
        return this._featureSet.isGeneric();
    }

    @Override
    public String getType() {
        return this._featureSet.getType();
    }

    @Override
    public String getSubType() {
        return this._featureSet.getSubType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureSet that = (FeatureSet)o;
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        String thatName = that.getName();
        String thatVersion = that.getVersion();
        return !(thisName == null ? thatName != null : !thisName.equals(thatName)) && !(thisVersion == null ? thatVersion != null : !thisVersion.equals(thatVersion));
    }

    public int hashCode() {
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        int result = thisName != null ? thisName.hashCode() : 0;
        result = 31 * result + (thisVersion != null ? thisVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        String name = this.getDisplayName();
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            name = this.getName();
        }
        return name + " " + this.getVersion();
    }

    @Override
    public List<Library> getLibraries() {
        ArrayList<Library> libs = new ArrayList<Library>();
        List<FeatureLibrary> fLibs = this._featureSet.getLibraries();
        for (FeatureLibrary lib : fLibs) {
            LibraryImpl ext_lib = new LibraryImpl(new com.oracle.cie.gdr.dao.cpd.Library(lib.getDataHandler()), this.getVersion());
            libs.add(ext_lib);
        }
        return libs;
    }
}

