/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.external.BaseInventoryFactory;
import com.oracle.cie.gdr.external.GdrInventory;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.impl.GdrInventoryImpl;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class GdrInventoryFactory
implements BaseInventoryFactory {
    private static Map<Path, GdrInventory> _cache = new HashMap<Path, GdrInventory>();

    @Override
    public GdrInventory createInventory(File metaDataHome) throws InventoryException {
        return this.createInventory(NioHelper.getInstance().getPath(metaDataHome));
    }

    @Override
    public GdrInventory createInventory(Path metaDataHome) throws InventoryException {
        GdrInventory gdrInventory = _cache.get(metaDataHome);
        if (null == gdrInventory) {
            gdrInventory = new GdrInventoryImpl(metaDataHome);
            _cache.put(metaDataHome, gdrInventory);
        }
        return gdrInventory;
    }
}

