/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.ComponentMapping;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.LabelMap;
import com.oracle.cie.gdr.external.LabelMapComponent;
import com.oracle.cie.gdr.external.impl.ComponentMappingImpl;
import com.oracle.cie.gdr.services.TopLevelDirectoryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

public class LabelMapImpl
implements LabelMap {
    private com.oracle.cie.gdr.dao.lbm.LabelMap _labelMap;
    private static final Logger _log = Logger.getLogger(LabelMapImpl.class.getName());
    private MetaDataHome _metaDataHome;

    LabelMapImpl(com.oracle.cie.gdr.dao.lbm.LabelMap labelMap, MetaDataHome metaDataHome) {
        this._labelMap = labelMap;
        this._metaDataHome = metaDataHome;
        this._labelMap = labelMap;
    }

    public List<ComponentMapping> getMappings() {
        ArrayList<ComponentMapping> componentMappings = new ArrayList<ComponentMapping>();
        for (com.oracle.cie.gdr.dao.lbm.ComponentMapping componentMappingDao : this._labelMap.getMappings()) {
            componentMappings.add(new ComponentMappingImpl(componentMappingDao, this._metaDataHome, this._labelMap));
        }
        return componentMappings;
    }

    private boolean doesComponentMappingMatchesAdeLabel(ComponentMapping componentMapping, Collection<TopLevelDirectoryService.AdeLabel> labels) {
        if (labels == null) {
            return true;
        }
        for (TopLevelDirectoryService.AdeLabel adeLabel : labels) {
            if (!adeLabel.matches(componentMapping.getLabel()) && !adeLabel.matches(componentMapping.getSeries()) && !adeLabel.matches(componentMapping.getProduct())) continue;
            return true;
        }
        return false;
    }

    private boolean doesComponentMappingMatchFilterValues(ComponentMapping componentMapping, Collection<String> filters) throws InventoryException {
        String product;
        if (filters == null || filters.isEmpty()) {
            return true;
        }
        String label = null;
        String series = null;
        String mappingLabel = componentMapping.getLabel();
        if (!StringUtil.isNullOrEmpty((String)mappingLabel, (boolean)true)) {
            String[] split = mappingLabel.split("_");
            if (split.length != 4) {
                throw new InventoryException("Label value in label-map was not the correct format: " + mappingLabel);
            }
            label = mappingLabel;
            series = split[0] + "_" + split[1] + "_" + split[2];
            product = split[0];
        } else {
            String mappingSeries = componentMapping.getSeries();
            if (!StringUtil.isNullOrEmpty((String)mappingSeries, (boolean)true)) {
                String[] split = mappingSeries.split("_");
                if (split.length != 3) {
                    throw new InventoryException("Series value in label-map was not the correct format: " + mappingSeries);
                }
                series = mappingSeries;
                product = split[0];
            } else {
                product = componentMapping.getProduct();
            }
        }
        for (String filter : filters) {
            String[] split = filter.split("_");
            if (split.length == 1) {
                return filter.equals(product);
            }
            if (split.length == 2) continue;
            if (split.length == 3) {
                return filter.equals(series);
            }
            if (split.length != 4) continue;
            return filter.equals(label);
        }
        return false;
    }

    @Override
    public Collection<LabelMapComponent> getComponents(String labelMappingFilter) throws InventoryException {
        return this.getComponents(labelMappingFilter, false);
    }

    @Override
    public Collection<LabelMapComponent> getComponents(String labelMappingFilter, boolean inCurrentView) throws InventoryException {
        return this.getComponentsFromLabelMap(null, labelMappingFilter, inCurrentView);
    }

    @Override
    public Collection<LabelMapComponent> getComponents(FeatureSet featureSet, String mappingFilter) throws InventoryException {
        return this.getComponents(featureSet, mappingFilter, false);
    }

    @Override
    public Collection<LabelMapComponent> getComponents(FeatureSet featureSet, String mappingFilter, boolean inCurrentView) throws InventoryException {
        if (null == featureSet) {
            throw new InventoryException("The feature set is required.");
        }
        return this.getComponentsFromLabelMap(featureSet.getComponents(), mappingFilter, inCurrentView);
    }

    @Override
    public Collection<LabelMapComponent> getComponents(Distribution distribution, String labelMappingFilter) throws InventoryException {
        return this.getComponents(distribution, labelMappingFilter, false);
    }

    @Override
    public Collection<LabelMapComponent> getComponents(Distribution distribution, String labelMappingFilter, boolean inCurrentView) throws InventoryException {
        if (null == distribution) {
            throw new InventoryException("The distribution is required.");
        }
        return this.getComponentsFromLabelMap(distribution.getComponents(), labelMappingFilter, inCurrentView);
    }

    private Collection<LabelMapComponent> getComponentsFromLabelMap(Collection<Component> components, String labelMappingFilter, boolean inCurrentView) throws InventoryException {
        if (inCurrentView && !TopLevelDirectoryService.isInAdeEnv()) {
            throw new InventoryException("Not currently in ADE view.");
        }
        Collection<TopLevelDirectoryService.AdeLabel> labels = inCurrentView ? TopLevelDirectoryService.getAdeLabels(labelMappingFilter) : null;
        ArrayList<String> filters = null;
        if (!StringUtil.isNullOrEmpty((String)labelMappingFilter, (boolean)true)) {
            String[] split;
            filters = new ArrayList<String>();
            for (String filter : split = labelMappingFilter.split(",")) {
                if ((filter = filter.trim()).length() <= 0) continue;
                filters.add(filter);
            }
        }
        HashSet<LabelMapComponent> labelMapComponents = new HashSet<LabelMapComponent>();
        for (ComponentMapping componentMapping : this.getMappings()) {
            if (!this.doesComponentMappingMatchFilterValues(componentMapping, filters) || inCurrentView && !this.doesComponentMappingMatchesAdeLabel(componentMapping, labels)) continue;
            if (components != null) {
                for (LabelMapComponent component : componentMapping.getComponents()) {
                    if (!components.contains(component)) continue;
                    labelMapComponents.add(component);
                }
                continue;
            }
            labelMapComponents.addAll(componentMapping.getComponents());
        }
        return labelMapComponents;
    }

    @Override
    public Collection<LabelMapComponent> getComponents() throws InventoryException {
        return this.getComponents((String)null);
    }

    @Override
    public Collection<LabelMapComponent> getComponents(FeatureSet featureSet) throws InventoryException {
        return this.getComponents(featureSet, null);
    }

    @Override
    public Collection<LabelMapComponent> getComponents(Distribution distribution) throws InventoryException {
        return this.getComponents(distribution, null);
    }
}

