/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dei.DeInstallComponent;
import com.oracle.cie.gdr.dao.dei.DeInstallFeature;
import com.oracle.cie.gdr.dao.dei.DeInstallInfo;
import com.oracle.cie.gdr.dao.dei.DeInstallInfoFile;
import com.oracle.cie.gdr.dao.dei.DeInstallRefCount;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.deinstallation.DeInstallerShutdownHook;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.nio.NioFileLockService;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DeInstallInfoHelper
extends GdrHelper<DeInstallInfo> {
    private static final Logger _log = Logger.getLogger(DeInstallInfoHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/dei";
    public static final String DEINSTALL_INFO = "deinstall-info";
    public static final String DEINSTALL_INFO_FILE_NAME = "deinstall-info.xml";
    public static final String DEINSTALL_DIRECTORY = "deinstall";
    private static DeInstallInfoHelper _instance;
    private static final Object _deInstallInfoSaveLock;

    public static DeInstallInfoHelper getInstance() {
        if (_instance == null) {
            _instance = new DeInstallInfoHelper(null);
        }
        return _instance;
    }

    public static DeInstallInfoHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return DeInstallInfoHelper.getInstance();
        }
        return new DeInstallInfoHelper(classLoader);
    }

    private DeInstallInfoHelper(ClassLoader classLoader) {
        super(DeInstallInfo.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return DEINSTALL_INFO;
    }

    public String getPath() {
        return DEINSTALL_DIRECTORY;
    }

    public File getDeInstallInfoFile(File metaDataRoot) {
        return this.getDeInstallInfoFilePath(metaDataRoot).toFile();
    }

    public Path getDeInstallInfoFilePath(File metaDataRoot) {
        return this.getDeInstallInfoFilePath(metaDataRoot.toPath());
    }

    public Path getDeInstallInfoFilePath(Path metaDataRoot) {
        return metaDataRoot.resolve(this.getPath()).resolve(DEINSTALL_INFO_FILE_NAME);
    }

    public DeInstallInfo getDeInstallInfo(File deinstallInfoFile) throws IOException, DataHandlerException, GdrException {
        return this.getDeInstallInfo(NioHelper.getInstance().getPath(deinstallInfoFile));
    }

    public DeInstallInfo getDeInstallInfo(Path deinstallInfoPath) throws IOException, DataHandlerException, GdrException {
        if (deinstallInfoPath == null || !Files.isRegularFile(deinstallInfoPath, new LinkOption[0])) {
            GdrException ex = new GdrException("DeInstall info file specified was invalid: " + deinstallInfoPath);
            _log.throwing(DeInstallInfoHelper.class.getName(), "getDeInstallInfo", ex);
            throw ex;
        }
        return (DeInstallInfo)this.getRootWrapper(deinstallInfoPath);
    }

    public DeInstallInfo getDeInstallInfo(FileChannel deInstallInfoFile) throws IOException, DataHandlerException, GdrException {
        return (DeInstallInfo)this.getRootWrapper(deInstallInfoFile);
    }

    public DeInstallInfo getDeInstallInfoFromHome(File homeDir) throws IOException, DataHandlerException, GdrException {
        return this.getDeInstallInfoFromHome(NioHelper.getInstance().getPath(homeDir));
    }

    public DeInstallInfo getDeInstallInfoFromHome(Path homeDir) throws IOException, DataHandlerException, GdrException {
        DeInstallInfo deInstallInfo = null;
        Path deInstallInfoFilePath = this.getDeInstallInfoFilePath(Home.getInventoryDirectory(homeDir));
        if (Files.exists(deInstallInfoFilePath, new LinkOption[0])) {
            deInstallInfo = this.getDeInstallInfo(deInstallInfoFilePath);
        }
        return deInstallInfo;
    }

    public void saveDeInstallInfoToHome(DeInstallInfo deInstallInfo, File homeDir) throws IOException, DataHandlerException, GdrException {
        this.saveDeInstallInfoToHome(deInstallInfo, NioHelper.getInstance().getPath(homeDir));
    }

    public void saveDeInstallInfoToHome(DeInstallInfo deInstallInfo, Path homeDir) throws IOException, DataHandlerException, GdrException {
        if (deInstallInfo != null && homeDir != null) {
            this.saveDeInstallInfo(deInstallInfo, this.getDeInstallInfoFilePath(Home.getInventoryDirectory(homeDir)));
        }
    }

    public void saveDeInstallInfo(DeInstallInfo deInstallInfo, File deInstallInfoFile) throws IOException, DataHandlerException, GdrException {
        this.saveDeInstallInfo(deInstallInfo, NioHelper.getInstance().getPath(deInstallInfoFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDeInstallInfo(DeInstallInfo deInstallInfo, Path deInstallInfoPath) throws IOException, DataHandlerException, GdrException {
        if (deInstallInfoPath == null) {
            GdrException ex = new GdrException("DeInstallInfo file was null.");
            _log.throwing(DeInstallInfoHelper.class.getName(), "saveDeInstallInfo", ex);
            throw ex;
        }
        if (deInstallInfo != null) {
            if (!NioFileLockService.getFileLock((Path)deInstallInfoPath)) {
                GdrException ex = new GdrException("Unable to obtain lock on deinsatll-info.");
                _log.throwing(DeInstallInfoHelper.class.getName(), "saveDeInstallInfo", ex);
                throw ex;
            }
            boolean removed = false;
            List<DeInstallRefCount> refCounts = deInstallInfo.getRefCounts();
            Iterator<DeInstallRefCount> it = refCounts.iterator();
            while (it.hasNext()) {
                DeInstallRefCount refCount = it.next();
                if (refCount.getCount() >= 2) continue;
                it.remove();
                removed = true;
            }
            if (removed) {
                deInstallInfo.setRefCounts(refCounts);
            }
            Object object = _deInstallInfoSaveLock;
            synchronized (object) {
                if (deInstallInfo.isEmpty()) {
                    _log.fine("DeInstall info is empty, deleting deinstall-info file " + deInstallInfoPath);
                    NioFileLockService.releaseFileLock((Path)deInstallInfoPath);
                    Files.delete(deInstallInfoPath);
                    if (Files.exists(deInstallInfoPath, new LinkOption[0])) {
                        _log.warning("Unable to delete deinstall-info file " + deInstallInfoPath);
                    }
                } else {
                    this.sortDeInstallInfo(deInstallInfo);
                    FileChannel fileChannel = NioFileLockService.getFileChannel((Path)deInstallInfoPath);
                    this.save((IDataHandlerWrapper)deInstallInfo, fileChannel);
                    NioFileLockService.releaseFileLock((Path)deInstallInfoPath);
                }
            }
        }
        if (Files.exists(deInstallInfoPath, new LinkOption[0])) {
            Object object = _deInstallInfoSaveLock;
            synchronized (object) {
                Files.delete(deInstallInfoPath);
                if (Files.exists(deInstallInfoPath, new LinkOption[0])) {
                    _log.warning("Unable to delete deinstall-info file " + deInstallInfoPath);
                }
            }
        }
    }

    public void sortDeInstallInfo(DeInstallInfo deInstallInfo) {
        if (deInstallInfo != null) {
            List<DeInstallFeature> features;
            List<DeInstallRefCount> refCounts = deInstallInfo.getRefCounts();
            if (!refCounts.isEmpty()) {
                Collections.sort(refCounts);
                deInstallInfo.setRefCounts(refCounts);
            }
            Comparator<Reference> referenceComparator = new Comparator<Reference>(){

                @Override
                public int compare(Reference o1, Reference o2) {
                    String ref1 = GdrHelper.getFormattedNameVersion(o1.getName(), o1.getVersion());
                    String ref2 = GdrHelper.getFormattedNameVersion(o2.getName(), o2.getVersion());
                    return ref1.compareTo(ref2);
                }
            };
            List<DeInstallComponent> components = deInstallInfo.getComponents();
            if (!components.isEmpty()) {
                for (DeInstallComponent component : components) {
                    List<DeInstallInfoFile> files = component.getFiles();
                    Collections.sort(files);
                    component.setFiles(files);
                }
                Collections.sort(components, referenceComparator);
                deInstallInfo.setComponents(components);
            }
            if (!(features = deInstallInfo.getFeatures()).isEmpty()) {
                for (DeInstallFeature feature : features) {
                    List<DeInstallInfoFile> files = feature.getFiles();
                    Collections.sort(files);
                    feature.setFiles(files);
                }
                Collections.sort(features, referenceComparator);
                deInstallInfo.setFeatures(features);
            }
        }
    }

    public void mergeDeInstallInfos(DeInstallInfo deInstallInfo, DeInstallInfo additionalInfo) {
        if (deInstallInfo != null && additionalInfo != null) {
            List<DeInstallRefCount> addRefCounts = additionalInfo.getRefCounts();
            if (addRefCounts != null && !addRefCounts.isEmpty()) {
                List<DeInstallRefCount> currRefCounts = deInstallInfo.getRefCounts();
                if (currRefCounts != null && !currRefCounts.isEmpty()) {
                    for (DeInstallRefCount deInstallRefCount : addRefCounts) {
                        int index = currRefCounts.indexOf(deInstallRefCount);
                        if (index > -1) {
                            DeInstallRefCount rc = currRefCounts.get(index);
                            int count = rc.getCount();
                            count = count > -1 ? (count += deInstallRefCount.getCount()) : deInstallRefCount.getCount();
                            rc.setCount(count);
                            continue;
                        }
                        currRefCounts.add(deInstallRefCount);
                    }
                } else {
                    deInstallInfo.setRefCounts(addRefCounts);
                }
            }
            List<DeInstallComponent> comps = additionalInfo.getComponents();
            List<DeInstallComponent> currComps = deInstallInfo.getComponents();
            if (comps != null && !comps.isEmpty()) {
                for (DeInstallComponent comp : comps) {
                    int index = currComps.indexOf((Object)comp);
                    if (index > -1) {
                        DeInstallComponent dic = currComps.get(index);
                        List<DeInstallInfoFile> addFiles = comp.getFiles();
                        List<DeInstallInfoFile> currFiles = dic.getFiles();
                        for (DeInstallInfoFile file : addFiles) {
                            if (currFiles.contains(file)) continue;
                            currFiles.add(file);
                        }
                        dic.setFiles(currFiles);
                        continue;
                    }
                    currComps.add(comp);
                }
            }
            deInstallInfo.setComponents(currComps);
            List<DeInstallFeature> list = additionalInfo.getFeatures();
            List<DeInstallFeature> currFeatures = deInstallInfo.getFeatures();
            if (list != null && !list.isEmpty()) {
                for (DeInstallFeature feature : list) {
                    int index = currFeatures.indexOf((Object)feature);
                    if (index > -1) {
                        DeInstallFeature dif = currFeatures.get(index);
                        List<DeInstallInfoFile> addFiles = feature.getFiles();
                        List<DeInstallInfoFile> currFiles = dif.getFiles();
                        for (DeInstallInfoFile file : addFiles) {
                            if (currFiles.contains(file)) continue;
                            currFiles.add(file);
                        }
                        dif.setFiles(currFiles);
                        continue;
                    }
                    currFeatures.add(feature);
                }
            }
            deInstallInfo.setFeatures(currFeatures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMergedDeInstallInfo(DeInstallInfo deInstallInfo, Path deInstallInfoPath) throws IOException, DataHandlerException, GdrException {
        if (deInstallInfo != null && !deInstallInfo.isEmpty()) {
            if (!NioFileLockService.getFileLock((Path)deInstallInfoPath)) {
                GdrException ex = new GdrException("Unable to obtain lock on deinstall-info.");
                _log.throwing(DeInstallInfoHelper.class.getName(), "mergeDeInstallInfo", ex);
                throw ex;
            }
            Object object = _deInstallInfoSaveLock;
            synchronized (object) {
                DeInstallInfo dii = null;
                FileChannel fileChannel = NioFileLockService.getFileChannel((Path)deInstallInfoPath);
                if (fileChannel.size() > 0L) {
                    dii = this.getDeInstallInfo(fileChannel);
                }
                if (dii == null) {
                    dii = deInstallInfo;
                } else {
                    this.mergeDeInstallInfos(dii, deInstallInfo);
                }
                this.sortDeInstallInfo(deInstallInfo);
                this.save((IDataHandlerWrapper)dii, fileChannel);
                NioFileLockService.releaseFileLock((Path)deInstallInfoPath);
            }
        }
    }

    public DeInstallComponent getComponentFromDeInstallInfo(DeInstallInfo deInstallInfo, String componentName, String componentVersion) {
        List<DeInstallComponent> comps;
        DeInstallComponent component = null;
        if (!(deInstallInfo == null || StringUtil.isNullOrEmpty((String)componentName) || StringUtil.isNullOrEmpty((String)componentVersion) || (comps = deInstallInfo.getComponents()) == null || comps.isEmpty())) {
            for (DeInstallComponent comp : comps) {
                if (!comp.getName().equals(componentName) || !comp.getVersion().equals(componentVersion)) continue;
                component = comp;
                break;
            }
        }
        return component;
    }

    public DeInstallFeature getFeatureFromDeInstallInfo(DeInstallInfo deInstallInfo, String featureName, String featureVersion) {
        List<DeInstallFeature> features;
        DeInstallFeature feature = null;
        if (!(deInstallInfo == null || StringUtil.isNullOrEmpty((String)featureName) || StringUtil.isNullOrEmpty((String)featureVersion) || (features = deInstallInfo.getFeatures()) == null || features.isEmpty())) {
            for (DeInstallFeature ftr : features) {
                if (!ftr.getName().equals(featureName) || !ftr.getVersion().equals(featureVersion)) continue;
                feature = ftr;
                break;
            }
        }
        return feature;
    }

    public boolean removeComponentFromDeInstallInfo(DeInstallInfo deInstallInfo, String componentName, String componentVersion) {
        List<DeInstallComponent> comps;
        boolean changed = false;
        if (!(deInstallInfo == null || StringUtil.isNullOrEmpty((String)componentName) || StringUtil.isNullOrEmpty((String)componentVersion) || (comps = deInstallInfo.getComponents()) == null || comps.isEmpty())) {
            Iterator<DeInstallComponent> it = comps.iterator();
            while (it.hasNext()) {
                DeInstallComponent comp = it.next();
                if (!comp.getName().equals(componentName) || !comp.getVersion().equals(componentVersion)) continue;
                it.remove();
                changed = true;
                break;
            }
            if (changed) {
                deInstallInfo.setComponents(comps);
            }
        }
        return changed;
    }

    public boolean removeFeatureFromDeInstallInfo(DeInstallInfo deInstallInfo, String featureName, String featureVersion) {
        List<DeInstallFeature> features;
        boolean changed = false;
        if (!(deInstallInfo == null || StringUtil.isNullOrEmpty((String)featureName) || StringUtil.isNullOrEmpty((String)featureVersion) || (features = deInstallInfo.getFeatures()) == null || features.isEmpty())) {
            Iterator<DeInstallFeature> it = features.iterator();
            while (it.hasNext()) {
                DeInstallFeature feature = it.next();
                if (!feature.getName().equals(featureName) || !feature.getVersion().equals(featureVersion)) continue;
                it.remove();
                changed = true;
                break;
            }
            if (changed) {
                deInstallInfo.setFeatures(features);
            }
        }
        return changed;
    }

    public void addExtraFilesToDeInstallInfo(File home, String name, String version, Collection<File> files, boolean isFeature) throws GdrException, IOException, DataHandlerException {
        Path homePath = NioHelper.getInstance().getPath(home);
        ArrayList<Path> filePaths = new ArrayList<Path>();
        for (File file : files) {
            filePaths.add(Paths.get(file.toString(), new String[0]));
        }
        this.addExtraFilesToDeInstallInfo(homePath, name, version, filePaths, isFeature);
    }

    public void addExtraFilesToDeInstallInfo(Path home, String name, String version, Collection<Path> files, boolean isFeature) throws GdrException, IOException, DataHandlerException {
        if (home == null || !Files.isDirectory(home, new LinkOption[0])) {
            GdrException ex = new GdrException("The home specified was null or was not a directory.");
            _log.throwing(DeInstallInfoHelper.class.getName(), "addExtraFilesToDeInstallInfo", ex);
            throw ex;
        }
        DeInstallInfo deInstallInfo = (DeInstallInfo)this.getRootWrapper();
        this.addExtraFilesToDeInstallInfo(deInstallInfo, name, version, files, isFeature, home);
        this.saveMergedDeInstallInfo(deInstallInfo, this.getDeInstallInfoFilePath(home.resolve("inventory")));
    }

    public synchronized void addExtraFilesToDeInstallInfo(DeInstallInfo deInstallInfo, String name, String version, Collection<Path> files, boolean isFeature, Path oracleHomePath) throws GdrException {
        if (files != null && !files.isEmpty()) {
            if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
                GdrException ex = new GdrException("The name was null or empty.");
                _log.throwing(DeInstallInfoHelper.class.getName(), "addExtraFilesToDeInstallInfo", ex);
                throw ex;
            }
            if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
                GdrException ex = new GdrException("The version was null or empty.");
                _log.throwing(DeInstallInfoHelper.class.getName(), "addExtraFilesToDeInstallInfo", ex);
                throw ex;
            }
            HashMap<String, Integer> overwritten = new HashMap<String, Integer>();
            if (isFeature) {
                int index;
                DeInstallFeature feature = new DeInstallFeature(name, version);
                List<DeInstallFeature> features = deInstallInfo.getFeatures();
                boolean featureAdded = false;
                if (features == null) {
                    features = new ArrayList<DeInstallFeature>();
                }
                if ((index = features.indexOf((Object)feature)) > -1) {
                    feature = features.get(index);
                } else {
                    features.add(feature);
                    featureAdded = true;
                }
                List<DeInstallInfoFile> difs = feature.getFiles();
                if (difs == null) {
                    difs = new ArrayList<DeInstallInfoFile>();
                }
                for (Path p : files) {
                    String path = this.makeRelativePath(oracleHomePath.toString(), p.toString());
                    overwritten.put(p.toString(), 1);
                    difs.add(new DeInstallInfoFile(path));
                }
                feature.setFiles(difs);
                if (featureAdded) {
                    deInstallInfo.setFeatures(features);
                }
            } else {
                int index;
                DeInstallComponent comp = new DeInstallComponent(name, version);
                List<DeInstallComponent> components = deInstallInfo.getComponents();
                boolean compAdded = false;
                if (components == null) {
                    components = new ArrayList<DeInstallComponent>();
                }
                if ((index = components.indexOf((Object)comp)) > -1) {
                    comp = components.get(index);
                } else {
                    components.add(comp);
                    compAdded = true;
                }
                List<DeInstallInfoFile> difs = comp.getFiles();
                if (difs == null) {
                    difs = new ArrayList<DeInstallInfoFile>();
                }
                for (Path p : files) {
                    String path = this.makeRelativePath(oracleHomePath.toString(), p.toString());
                    overwritten.put(p.toString(), 1);
                    difs.add(new DeInstallInfoFile(path));
                }
                comp.setFiles(difs);
                if (compAdded) {
                    deInstallInfo.setComponents(components);
                }
            }
            this.updateDeInstallRefCounts(deInstallInfo, overwritten, false);
        }
    }

    public void updateDeInstallRefCounts(DeInstallInfo deInstallInfo, Map<String, Integer> overwritten, boolean add) {
        if (overwritten != null && !overwritten.isEmpty()) {
            List<DeInstallRefCount> refCounts = deInstallInfo.getRefCounts();
            if (refCounts == null) {
                refCounts = new ArrayList<DeInstallRefCount>();
            }
            for (String path : overwritten.keySet()) {
                DeInstallRefCount refCount = new DeInstallRefCount(path);
                int index = refCounts.indexOf(refCount);
                if (index > -1) {
                    refCount = refCounts.get(index);
                    refCount.setCount(refCount.getCount() + overwritten.get(path));
                    continue;
                }
                if (!add) continue;
                refCount.setCount(overwritten.get(path) + 1);
                refCounts.add(refCount);
            }
            deInstallInfo.setRefCounts(refCounts);
        }
    }

    public Collection<Path> getExtraFilesFromDeInstallInfo(Path home, DeInstallInfo deInstallInfo, Component component) throws GdrException {
        DeInstallComponent comp;
        if (component != null && deInstallInfo != null && (comp = this.getComponentFromDeInstallInfo(deInstallInfo, component.getName(), component.getVersion())) != null) {
            return this.getExtraFilesFromDeInstallInfo(home, comp.getFiles());
        }
        return null;
    }

    public Collection<Path> getExtraFilesFromDeInstallInfo(Path home, DeInstallInfo deInstallInfo, FeatureSet feature) throws GdrException {
        DeInstallFeature dif;
        if (feature != null && deInstallInfo != null && (dif = this.getFeatureFromDeInstallInfo(deInstallInfo, feature.getName(), feature.getVersion())) != null) {
            return this.getExtraFilesFromDeInstallInfo(home, dif.getFiles());
        }
        return null;
    }

    public boolean removeComponentFiles(DeInstallInfo deInstallInfo, Home home, Component component) throws GdrException {
        boolean changed = false;
        if (deInstallInfo != null && home != null && component != null) {
            this.removeExtraFiles(this.getExtraFilesFromDeInstallInfo(home.getHomePath(), deInstallInfo, component));
            changed = this.removeComponentFromDeInstallInfo(deInstallInfo, component.getName(), component.getVersion());
        }
        return changed;
    }

    public boolean removeFeatureSetFiles(DeInstallInfo deInstallInfo, Home home, FeatureSet featureSet) throws GdrException {
        boolean changed = false;
        if (deInstallInfo != null && home != null && featureSet != null) {
            this.removeExtraFiles(this.getExtraFilesFromDeInstallInfo(home.getHomePath(), deInstallInfo, featureSet));
            changed = this.removeFeatureFromDeInstallInfo(deInstallInfo, featureSet.getName(), featureSet.getVersion());
        }
        return changed;
    }

    private void removeExtraFiles(Collection<Path> files) {
        if (files != null) {
            for (Path file : files) {
                try {
                    Files.deleteIfExists(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!Files.exists(file, new LinkOption[0])) continue;
                DeInstallerShutdownHook.add(file, !Files.isDirectory(file, new LinkOption[0]));
            }
        }
    }

    private Collection<Path> getExtraFilesFromDeInstallInfo(Path home, List<DeInstallInfoFile> deInstallFiles) throws GdrException {
        TreeSet<Path> files = new TreeSet<Path>(Collections.reverseOrder());
        if (deInstallFiles != null && !deInstallFiles.isEmpty()) {
            for (DeInstallInfoFile deInstallFile : deInstallFiles) {
                String path = deInstallFile.getPath();
                String parentPath = "";
                Path filePath = this.makeAbsolutePath(home, path);
                if (Files.isDirectory(filePath, new LinkOption[0])) {
                    Stack<Path> recursiveDirectory = new Stack<Path>();
                    recursiveDirectory.add(filePath);
                    while (!recursiveDirectory.isEmpty()) {
                        Path childrenFile = (Path)recursiveDirectory.pop();
                        if (!Files.isDirectory(childrenFile, new LinkOption[0])) continue;
                        try (DirectoryStream<Path> childrenFiles = Files.newDirectoryStream(childrenFile);){
                            if (childrenFiles == null) continue;
                            for (Path child : childrenFiles) {
                                recursiveDirectory.push(child);
                            }
                        }
                        catch (IOException | DirectoryIteratorException e) {
                            throw new GdrException((Throwable)e);
                        }
                        finally {
                            files.add(childrenFile);
                        }
                    }
                }
                for (String subDir : path.split(Pattern.quote(File.separator))) {
                    if (subDir.isEmpty()) continue;
                    parentPath = parentPath + File.separator + subDir;
                    Path absoluteParentPath = this.makeAbsolutePath(home, parentPath);
                    files.add(absoluteParentPath);
                }
            }
            return files;
        }
        return null;
    }

    private String makeRelativePath(String oraHome, String filePath) throws GdrException {
        if (oraHome == null || oraHome.isEmpty()) {
            GdrException ex = new GdrException("oraHome was null or empty.");
            _log.throwing(DeInstallInfoHelper.class.getName(), "makeRelativePath", ex);
            throw ex;
        }
        if (filePath == null || filePath.isEmpty()) {
            GdrException ex = new GdrException("filePath was null or empty.");
            _log.throwing(DeInstallInfoHelper.class.getName(), "makeRelativePath", ex);
            throw ex;
        }
        if (filePath.contains(oraHome)) {
            return filePath.substring(oraHome.length());
        }
        return filePath;
    }

    private Path makeAbsolutePath(Path homePath, String filePath) throws GdrException {
        if (homePath == null) {
            GdrException ex = new GdrException("oraHome was null or empty.");
            _log.throwing(DeInstallInfoHelper.class.getName(), "makeAbsolutePath", ex);
            throw ex;
        }
        if (filePath == null || filePath.isEmpty()) {
            GdrException ex = new GdrException("filePath was null or empty.");
            _log.throwing(DeInstallInfoHelper.class.getName(), "makeAbsolutePath", ex);
            throw ex;
        }
        return homePath.resolve(filePath.substring(1));
    }

    static {
        _deInstallInfoSaveLock = new Object();
    }
}

