/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Variable;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dei.DeInstallInfo;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.inv.DistributionReference;
import com.oracle.cie.gdr.dao.pch.Patch;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.PatchInfo;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionAction;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.dao.rgy.TargetInfo;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTargetFactory;
import com.oracle.cie.gdr.external.impl.LibraryGeneratorImpl;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DeInstallInfoHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.HomeHelper;
import com.oracle.cie.gdr.helpers.PatchHelper;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.installation.DefaultInstallerWrapper;
import com.oracle.cie.gdr.installation.InstallationSession;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.installation.ReferenceCounter;
import com.oracle.cie.gdr.libraries.LibraryException;
import com.oracle.cie.gdr.libraries.LibraryProcessor;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.maven.PomProcessor;
import com.oracle.cie.gdr.nio.NioFileLockService;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.patch.HomeOperationsImpl;
import com.oracle.cie.gdr.patch.PatchWrapper;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.ini.DefaultOraparamIni;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.PatchFactory;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.install.HomeOperationsFactory;

public abstract class CommonInstaller
implements Installer {
    private static final Logger _log = Logger.getLogger(CommonInstaller.class.getName());
    protected InstallationSession _installationSession;
    private DeInstallInfo _deInstallInfo;
    private long _preRegistryLength = -1L;
    private boolean _installationStarted;
    protected SessionInfo _registrySession;
    private Map<FeatureSet, ReferenceCounter> _featureRefCounters = new HashMap<FeatureSet, ReferenceCounter>();
    private Map<Component, ReferenceCounter> _componentRefCounters = new HashMap<Component, ReferenceCounter>();
    private Map<ComponentTarget, ReferenceCounter> _componentTargetRefCounters = new HashMap<ComponentTarget, ReferenceCounter>();
    private Set<FeatureSet> _installedFeatureSets = new LinkedHashSet<FeatureSet>();
    private Set<Component> _installedComponents = new LinkedHashSet<Component>();
    private Map<FeatureSet, LibraryTargetHolder> _libraryTargets;

    public CommonInstaller(InstallationSession installationSession, Map<String, String> variableMap) throws IOException, DataHandlerException, GdrException {
        if (installationSession == null) {
            GdrException ex = new GdrException("The InstallationSession provided was null.");
            _log.throwing(CommonInstaller.class.getName(), "CommonInstaller", ex);
            throw ex;
        }
        this._installationSession = installationSession;
        installationSession.getServiceHolder().getVariableResolverService().set(variableMap);
    }

    @Override
    public InstallationSession getInstallationSession() {
        return this._installationSession;
    }

    @Override
    public Set<FeatureSet> getPostProcessFeatures() {
        return this._installedFeatureSets;
    }

    @Override
    public Set<Component> getPostProcessComponents() {
        return this._installedComponents;
    }

    @Override
    public MetaDataHome getMetaDataHome() {
        return this.getInstallationSession().getMetaDataHome();
    }

    @Override
    public File getMetaDataHomeDir() {
        return this.getMetaDataHome().getComponentMetaDataHome();
    }

    @Override
    public Home getHome() {
        return this.getInstallationSession().getHome();
    }

    @Override
    public File getHomeDir() {
        return this.getHome().getHome();
    }

    public ServiceHolder getServiceHolder() {
        return this.getInstallationSession().getServiceHolder();
    }

    @Override
    public Registry getRegistry() {
        return this.getHome().getRegistry();
    }

    @Override
    public File getRegistryFile() {
        return this.getHome().getRegistryFile();
    }

    @Override
    public DeInstallInfo getDeInstallInfo() {
        if (this._deInstallInfo == null) {
            this._deInstallInfo = (DeInstallInfo)DeInstallInfoHelper.getInstance().getRootWrapper();
        }
        return this._deInstallInfo;
    }

    @Override
    public abstract Set<FeatureSet> getSelectedFeatures();

    public abstract Map<FeatureSet, Collection<Component>> getComponentsMap();

    @Override
    public abstract void saveHomeMetadata(Path var1) throws GdrException, DataHandlerException, IOException;

    @Override
    public abstract Distribution getDistribution();

    @Override
    public Set<Component> getComponents(FeatureSet feature) {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        Map<FeatureSet, Collection<Component>> componentsMap = this.getComponentsMap();
        Collection<Component> allComps = componentsMap.get(feature);
        if (allComps != null) {
            components.addAll(allComps);
        }
        return components;
    }

    @Override
    public Set<Component> getComponents() {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        Map<FeatureSet, Collection<Component>> componentsMap = this.getComponentsMap();
        if (componentsMap != null) {
            for (Collection<Component> allComps : componentsMap.values()) {
                components.addAll(allComps);
            }
        }
        return components;
    }

    @Override
    public Set<Component> getSelectedComponents() {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        Set<FeatureSet> features = this.getSelectedFeatures();
        for (FeatureSet feature : features) {
            Set<Component> comps;
            if (feature.isFullyInstalled() && !feature.isSingleton() || (comps = this.getComponents(feature)) == null || comps.isEmpty()) continue;
            for (Component comp : comps) {
                if (comp.isFullyInstalled()) continue;
                components.add(comp);
            }
        }
        return components;
    }

    @Override
    public void resolveComponentVariables() throws GdrException {
        for (Component component : this.getComponents()) {
            List<Variable> variables = component.getVariables();
            for (Variable variable : variables) {
                if (variable.isValueResolved()) continue;
                try {
                    variable.setResolvedValue(this.getServiceHolder().getVariableResolverService().resolveVariableValue(variable, this));
                }
                catch (GdrException e) {
                    throw new GdrException("Failed to resolve component variable " + variable.getName() + " for component " + component, (Throwable)e);
                }
            }
        }
    }

    @Override
    public Map<FeatureSet, LibraryTargetHolder> getLibraryTargets() throws DependencyException, IOException, DataHandlerException, GdrException {
        if (this._libraryTargets == null) {
            Set<FeatureSet> features = this.getSelectedFeatures();
            features.addAll(this.getHome().getInstalledFeatures());
            HashSet<FeatureSet> externalDummyFeatures = null;
            if (this.getHome().isFederatedHome() && !this.getHome().getChainedFederatedHomes(false).isEmpty()) {
                externalDummyFeatures = new HashSet<FeatureSet>();
                externalDummyFeatures.addAll(this.getInstallationSession().getDistributionTarget().getDummyExternalFeatureSets());
                externalDummyFeatures.addAll(HomeHelper.getExternalDummyFeatures(this.getHome().getInstalledDistributions()));
            }
            this._libraryTargets = FeatureSetHelper.getInstance(this.getMetaDataHome().getClassLoader()).getLibraryTargets(features, externalDummyFeatures, this.getHome(), this.getComponentsMap(), this.getServiceHolder(), this.getInstallationSession().getDirectoryMap());
        }
        return this._libraryTargets;
    }

    @Override
    public long getRequiredSpace() {
        return ComponentHelper.getInstance().getRequiredSpace(this.getHome(), this.getSelectedComponents()) + FeatureSetHelper.getInstance().getRequiredSpace(this.getHome(), this.getSelectedFeatures(), this.getSelectedComponents());
    }

    public File getPreRegistryFile() {
        return this.getPreRegistryFilePath().toFile();
    }

    public Path getPreRegistryFilePath() {
        return this.getHome().getInventoryDirectoryPath().resolve("registry.pre");
    }

    private void isInstallationStarted() throws GdrException {
        if (!this._installationStarted) {
            GdrException ex = new GdrException("The installation was not started.");
            _log.throwing(CommonInstaller.class.getName(), "isInstallationStarted", ex);
            throw ex;
        }
    }

    @Override
    public void startInstall() throws GdrException {
        if (this._installationStarted) {
            GdrException ex = new GdrException("The installation was already started.");
            _log.throwing(CommonInstaller.class.getName(), "startInstall", ex);
            throw ex;
        }
        this.fixRefCounts();
        this.resolveComponentVariables();
        Path preRegistryPath = this.getPreRegistryFilePath();
        try {
            if (!NioFileLockService.getFileLock((Path)preRegistryPath)) {
                GdrException ex = new GdrException("Unable to obtain lock on pre-registry.");
                _log.throwing(CommonInstaller.class.getName(), "startInstall", ex);
                throw ex;
            }
            this.saveHomeMetadata(this.getHome().getInventoryDirectoryPath());
            FileChannel fc = NioFileLockService.getFileChannel((Path)preRegistryPath);
            Registry preRegistry = fc.size() > 0L ? this.getHome().getRegistryHelper().getRegistry(fc) : new Registry(this.getHome().getRegistry().getDataHandler().copy());
            this._registrySession = this.getRegistrySession(preRegistry);
            this.updateRegistry(preRegistry, this._registrySession);
            this.getHome().getRegistryHelper().save((IDataHandlerWrapper)preRegistry, fc);
            this._preRegistryLength = Files.size(preRegistryPath);
            NioFileLockService.releaseFileLock((Path)preRegistryPath);
        }
        catch (IOException e) {
            throw new GdrException((Throwable)e);
        }
        catch (DataHandlerException e) {
            throw new GdrException((Throwable)e);
        }
        this._installationStarted = true;
    }

    private void fixRefCounts() throws GdrException {
        ReferenceCounter refCounter;
        Integer count;
        HashMap<ComponentReference, Integer> componentMap = new HashMap<ComponentReference, Integer>();
        HashMap<FeatureSet, Integer> featureSetMap = new HashMap<FeatureSet, Integer>();
        if (this.getHome().getInstalledDistributions().size() > 1) {
            for (DistributionTarget distributionTarget : this.getHome().getInstalledDistributions()) {
                for (FeatureSet featureSet : distributionTarget.getInstalledFeatureSets()) {
                    Integer featureCounter = (Integer)featureSetMap.get(featureSet);
                    if (featureCounter == null) {
                        featureCounter = 1;
                    } else {
                        Integer n = featureCounter;
                        Integer n2 = featureCounter = Integer.valueOf(featureCounter + 1);
                    }
                    featureSetMap.put(featureSet, featureCounter);
                    for (ComponentReference component : distributionTarget.getInstalledComponents(featureSet)) {
                        Integer compCounter = (Integer)componentMap.get((Object)component);
                        if (compCounter == null) {
                            compCounter = 1;
                        } else {
                            Integer n = compCounter;
                            Integer n3 = compCounter = Integer.valueOf(compCounter + 1);
                        }
                        componentMap.put(component, compCounter);
                    }
                }
            }
        }
        for (FeatureSet feature : featureSetMap.keySet()) {
            count = (Integer)featureSetMap.get(feature);
            refCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.featuresets, feature.getName(), feature.getVersion());
            if (refCounter.getRefCount() != count.intValue()) {
                refCounter.setRefCount(count);
            }
            ReferenceCounter.releaseReferenceCounter(refCounter);
        }
        for (ComponentReference component : componentMap.keySet()) {
            count = (Integer)componentMap.get((Object)component);
            refCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.components, component.getName(), component.getVersion());
            if (refCounter.getRefCount() != count.intValue()) {
                refCounter.setRefCount(count);
            }
            ReferenceCounter.releaseReferenceCounter(refCounter);
        }
    }

    protected SessionInfo getRegistrySession(Registry preRegistry) throws GdrException {
        return this.getHome().getRegistryHelper().getRegistrySession(preRegistry, Mode.INSTALL);
    }

    @Override
    public void completeInstall() throws GdrException {
        this.isInstallationStarted();
        if (!(this._featureRefCounters.isEmpty() && this._componentRefCounters.isEmpty() && this._componentTargetRefCounters.isEmpty())) {
            GdrException ex = new GdrException("The feature or component installation was never finished.");
            _log.throwing(CommonInstaller.class.getName(), "completeInstall", ex);
            throw ex;
        }
        Path preRegistryFile = this.getPreRegistryFilePath();
        try {
            if (!Files.exists(preRegistryFile, new LinkOption[0])) {
                GdrException ex = new GdrException("The pre-registry does not exist.");
                _log.throwing(CommonInstaller.class.getName(), "completeInstall", ex);
                throw ex;
            }
            long preRegistryLength = Files.size(preRegistryFile);
            Registry registry = this.getLockedRegistry();
            if (!NioFileLockService.getFileLock((Path)preRegistryFile)) {
                GdrException ex = new GdrException("Unable to obtain lock on pre-registry.");
                _log.throwing(CommonInstaller.class.getName(), "completeInstall", ex);
                throw ex;
            }
            registry.setSessions(this._registrySession.getId());
            this.updateRegistry(registry, this._registrySession);
            Path deInstallInfoFile = DeInstallInfoHelper.getInstance().getDeInstallInfoFilePath(this.getHome().getInventoryDirectoryPath());
            DeInstallInfoHelper.getInstance().saveMergedDeInstallInfo(this.getDeInstallInfo(), deInstallInfoFile);
            if (this._preRegistryLength > -1L && this._preRegistryLength == preRegistryLength) {
                FileChannel fc = NioFileLockService.getFileChannel((Path)preRegistryFile);
                fc.truncate(0L);
                NioFileLockService.releaseFileLock((Path)preRegistryFile);
                Files.delete(preRegistryFile);
            } else {
                NioFileLockService.releaseFileLock((Path)preRegistryFile);
            }
            this.unlockRegistry();
            this.getInstallationSession().reload();
        }
        catch (IOException e) {
            throw new GdrException((Throwable)e);
        }
        catch (DataHandlerException e) {
            throw new GdrException((Throwable)e);
        }
        this.regenerateLibaries();
        this.applyMetadataPatch();
        this._installationStarted = false;
        this._registrySession = null;
        this._libraryTargets = null;
    }

    protected void regenerateLibaries() throws LibraryException {
        if (RegenerationHelper.hasModifiedMetaData()) {
            LibraryGeneratorImpl generator = new LibraryGeneratorImpl(this.getHomeDir());
            generator.regenerateLibraries();
        }
    }

    @Override
    public boolean startFeatureInstall(FeatureSet feature) throws GdrException {
        this.isInstallationStarted();
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Starting feature install for " + feature);
        }
        if (this._featureRefCounters.remove(feature) != null) {
            GdrException ex = new GdrException("Already installing feature: " + feature);
            _log.throwing(CommonInstaller.class.getName(), "startFeatureInstall", ex);
            throw ex;
        }
        String featureVersion = feature.isSuperseded() ? feature.getSupersededVersion() : feature.getVersion();
        ReferenceCounter refCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.featuresets, feature.getName(), featureVersion);
        this._featureRefCounters.put(feature, refCounter);
        return !feature.getStatus().isInstalled() || !feature.isFullyInstalled();
    }

    @Override
    public void completeFeatureInstall(FeatureSet feature) throws GdrException {
        ReferenceCounter refCounter;
        this.isInstallationStarted();
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Completing feature install for " + feature);
        }
        if ((refCounter = this._featureRefCounters.remove(feature)) == null) {
            GdrException ex = new GdrException("Not currently installing feature: " + feature);
            _log.throwing(CommonInstaller.class.getName(), "completeFeatureInstall", ex);
            throw ex;
        }
        if (!(feature.isSuperseded() || refCounter.getRefCount() >= 1 && feature.isFullyInstalled())) {
            this._installedFeatureSets.add(feature);
        }
        if (!feature.getStatus().isInstalled()) {
            Set<Component> components = this.getComponents(feature);
            if (feature.getInitialRefCount() > 0) {
                refCounter.setRefCount(feature.getInitialRefCount());
                if (components != null && !components.isEmpty()) {
                    for (Component component : components) {
                        ReferenceCounter referenceCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.components, component.getName(), component.getVersion());
                        for (int x = 0; x < refCounter.getRefCount(); ++x) {
                            referenceCounter.increment();
                        }
                        ReferenceCounter.releaseReferenceCounter(referenceCounter);
                    }
                }
            }
            refCounter.increment();
            Collection<FeatureSet> replaces = feature.getReplaces();
            if (replaces != null && !replaces.isEmpty()) {
                Collection<Component> collection;
                if (components != null && !components.isEmpty()) {
                    for (Component component : components) {
                        if (component.hasReplaces()) continue;
                        ReferenceCounter componentRefCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.components, component.getName(), component.getVersion());
                        for (FeatureSet replacedFeature : replaces) {
                            ReferenceCounter replacedRefCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.featuresets, replacedFeature.getName(), replacedFeature.getVersion());
                            int count = replacedRefCounter.getRefCount();
                            for (int x = 0; x < count; ++x) {
                                componentRefCounter.increment();
                            }
                            ReferenceCounter.releaseReferenceCounter(replacedRefCounter);
                        }
                        ReferenceCounter.releaseReferenceCounter(componentRefCounter);
                    }
                }
                if ((collection = feature.getRemovedComponents()) != null && !collection.isEmpty()) {
                    for (Component component : collection) {
                        ReferenceCounter componentRefCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.components, component.getName(), component.getVersion());
                        componentRefCounter.setRefCount(0);
                        ReferenceCounter.releaseReferenceCounter(componentRefCounter);
                    }
                }
                for (FeatureSet replacedFeature : replaces) {
                    ReferenceCounter replacedRefCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.featuresets, replacedFeature.getName(), replacedFeature.getVersion());
                    int count = replacedRefCounter.getRefCount();
                    for (int x = 0; x < count; ++x) {
                        refCounter.increment();
                        replacedRefCounter.decrement();
                    }
                    ReferenceCounter.releaseReferenceCounter(replacedRefCounter);
                }
            }
            if (feature.isSuperseded()) {
                Set<FeatureSet> supersedingDependencies;
                FeatureSet featureSet = feature.getSuperseded();
                List<ComponentReference> list = featureSet.getComponentReferences();
                if (list != null && !list.isEmpty()) {
                    for (ComponentReference compRef : list) {
                        if (!compRef.getStatus().isInstalled()) continue;
                        boolean found = false;
                        for (Component component : components) {
                            if (!component.getName().equals(compRef.getName())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        ReferenceCounter componentRefCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.components, compRef.getName(), compRef.getVersion());
                        componentRefCounter.increment();
                        ReferenceCounter.releaseReferenceCounter(componentRefCounter);
                    }
                }
                if ((supersedingDependencies = feature.getSupersedingDependencies()) != null) {
                    for (FeatureSet supersedingDep : supersedingDependencies) {
                        ReferenceCounter replacedRefCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.featuresets, supersedingDep.getName(), supersedingDep.getVersion());
                        replacedRefCounter.increment();
                        ReferenceCounter.releaseReferenceCounter(replacedRefCounter);
                    }
                }
            }
        }
        ReferenceCounter.releaseReferenceCounter(refCounter);
    }

    @Override
    public void processPostFeatureOperation(FeatureSet feature) throws GdrException {
        this.isInstallationStarted();
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Processing post feature operation for " + feature);
        }
        if (!feature.isSuperseded()) {
            try {
                FeatureSelectionTarget currentFst;
                boolean pomOverwrite;
                Map<FeatureSet, LibraryTargetHolder> libraryTargets = this.getLibraryTargets();
                LibraryTargetHolder holder = null;
                if (libraryTargets != null && !libraryTargets.isEmpty()) {
                    holder = libraryTargets.get(feature);
                    if (holder == null) {
                        throw new GdrException("Library target holder for feature set did not exist " + feature);
                    }
                    LibraryProcessor.process(holder, this.getHome(), this, Mode.INSTALL);
                }
                if (!(pomOverwrite = Boolean.valueOf(this.getServiceHolder().getVariableResolverService().get("POM_OVERWRITE")).booleanValue())) {
                    pomOverwrite = Boolean.valueOf(DefaultOraparamIni.getOraparamProfileString((String)"POM_OVERWRITE", null));
                }
                FeatureSelectionTarget fst = (currentFst = this.getInstallationSession().getFeatureSelectionTarget()) != null ? FeatureSelectionTargetFactory.getFeatureSelectionTarget(currentFst.getFeatures(), currentFst.getInstalledFeatures()) : null;
                boolean distPomGen = this.getInstallationSession().getDistributionTarget().getDistribution().hasPomGen();
                if (distPomGen) {
                    PomProcessor.process(feature, new DefaultInstallerWrapper(this), fst, Mode.INSTALL, this.getInstallationSession().getDirectoryMap(), holder, pomOverwrite);
                } else {
                    _log.info("POM generation disabled at a distribution level for FeatureSet " + feature);
                }
            }
            catch (GdrException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GdrException((Throwable)e);
            }
        }
    }

    @Override
    public boolean startComponentInstall(Component component) throws GdrException {
        this.isInstallationStarted();
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Starting component install for " + component);
        }
        if (this._componentRefCounters.get(component) != null) {
            GdrException ex = new GdrException("Already installing component: " + component);
            _log.throwing(CommonInstaller.class.getName(), "startComponentInstall", ex);
            throw ex;
        }
        String componentVersion = component.isSuperseded() ? component.getSupersededVersion() : component.getVersion();
        ReferenceCounter refCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.components, component.getName(), componentVersion);
        this._componentRefCounters.put(component, refCounter);
        boolean proceed = false;
        if (!component.isSuperseded() && !component.isOmitted()) {
            if (component.isReplicable()) {
                Collection<ComponentTarget> targets = component.getComponentTargets();
                for (ComponentTarget target : targets) {
                    refCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.components, component.getName(), component.getVersion(), target.getReferenceQualifier());
                    this._componentTargetRefCounters.put(target, refCounter);
                }
                proceed = true;
            } else {
                boolean onlyLangInstall = ComponentHelper.getInstance().hasLanguageToInstall(component, this.getHome());
                boolean bl = proceed = refCounter.getRefCount() < 1 || onlyLangInstall;
            }
            if (!proceed && !component.isFullyInstalled() && component.hasReplaces()) {
                for (Component replacedComponent : component.getReplaces()) {
                    if (!component.getVersion().equals(replacedComponent.getVersion())) continue;
                    proceed = true;
                }
            }
        }
        return proceed;
    }

    @Override
    public void completeComponentInstall(Component component) throws GdrException {
        this.completeComponentInstall(component, null);
    }

    @Override
    public void completeComponentInstall(Component component, Map<String, Integer> overwritten) throws GdrException {
        ReferenceCounter refCounter;
        this.isInstallationStarted();
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Completing component install for " + component);
        }
        if ((refCounter = this._componentRefCounters.remove(component)) == null) {
            GdrException ex = new GdrException("Not currently installing component: " + component);
            _log.throwing(CommonInstaller.class.getName(), "completeComponentInstall", ex);
            throw ex;
        }
        if (!component.isSuperseded()) {
            DeInstallInfoHelper.getInstance().updateDeInstallRefCounts(this.getDeInstallInfo(), overwritten, true);
            if (component.isReplicable()) {
                Collection<ComponentTarget> targets = component.getComponentTargets();
                for (ComponentTarget target : targets) {
                    if (this._componentTargetRefCounters.get(target) == null) continue;
                    GdrException ex = new GdrException("Component target installation was never completed: " + target);
                    _log.throwing(CommonInstaller.class.getName(), "completeComponentInstall", ex);
                    throw ex;
                }
            }
            ArrayList<Component> comps = new ArrayList<Component>();
            comps.add(component);
            try {
                ComponentHelper.getInstance().saveComponentsInShipHomeStructure(this.getHome().getInventoryDirectoryPath(), component.isUnstaged(), comps, false);
            }
            catch (Exception e) {
                throw new GdrException((Throwable)e);
            }
        }
        if (!component.getStatus().isInstalled()) {
            this._installedComponents.add(component);
            refCounter.increment();
            Collection<Component> replaces = component.getReplaces();
            if (replaces != null && !replaces.isEmpty()) {
                for (Component replacedComponent : replaces) {
                    if (component.getVersion().equals(replacedComponent.getVersion())) continue;
                    ReferenceCounter replacedRefCounter = ReferenceCounter.getReferenceCounter(this.getHome().getHomePath(), ReferenceCounter.RefType.components, replacedComponent.getName(), replacedComponent.getVersion());
                    int count = replacedRefCounter.getRefCount();
                    for (int x = 0; x < count; ++x) {
                        refCounter.increment();
                        replacedRefCounter.decrement();
                    }
                    ReferenceCounter.releaseReferenceCounter(replacedRefCounter);
                }
            }
        }
        ReferenceCounter.releaseReferenceCounter(refCounter);
    }

    @Override
    public boolean startComponentTargetInstall(ComponentTarget target) throws GdrException {
        this.isInstallationStarted();
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Starting component target install for " + target);
        }
        boolean proceed = true;
        Component component = target.getComponent();
        if (component.isReplicable()) {
            ReferenceCounter refCounter = this._componentTargetRefCounters.get(target);
            if (refCounter == null) {
                GdrException ex = new GdrException("Not currently installing component for target: " + target);
                _log.throwing(CommonInstaller.class.getName(), "startComponentTargetInstall", ex);
                throw ex;
            }
            proceed = refCounter.getRefCount() < 1;
        }
        return proceed;
    }

    @Override
    public void completeComponentTargetInstall(ComponentTarget target) throws GdrException {
        Component component;
        this.isInstallationStarted();
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Completing component target install for " + target);
        }
        if ((component = target.getComponent()).isReplicable()) {
            ReferenceCounter refCounter = this._componentTargetRefCounters.remove(target);
            if (refCounter == null) {
                GdrException ex = new GdrException("Not currently installing component target: " + target);
                _log.throwing(CommonInstaller.class.getName(), "completeComponentTargetInstall", ex);
                throw ex;
            }
            if (component.getComponentReference().getComponentTargetStatus(target.getReferenceQualifier()).isNotInstalled()) {
                refCounter.increment();
            }
            ReferenceCounter.releaseReferenceCounter(refCounter);
        }
    }

    protected void updateRegistry(Registry registry, SessionInfo session) throws GdrException {
        this.updateRegistry(registry, session, false);
    }

    protected void updateRegistry(Registry registry, SessionInfo session, boolean dynamic) throws GdrException {
        this.updateRegistry(registry, session, this.getDistribution(), this.getComponentsMap(), this.getSelectedFeatures(), dynamic);
    }

    protected void updateRegistry(Registry registry, SessionInfo session, Distribution distribution, Map<FeatureSet, Collection<Component>> compMap, Set<FeatureSet> selectedFeatures, boolean dynamic) throws GdrException {
        FeatureInfo finfo;
        Collection<String> prodFams;
        if (distribution == null) {
            throw new GdrException("The distribution provided was null.");
        }
        DistributionInfo dinfo = this.getHome().getRegistryHelper().getDistributionInfo(registry, distribution.getName(), distribution.getVersion());
        if (dinfo == null) {
            dinfo = registry.addDistribution(distribution, session, true);
            if (dynamic) {
                dinfo.setDynamic(true);
            }
        } else {
            dinfo.addSession(session);
        }
        dinfo.setStatus(Status.installed);
        List<DistributionInfo> distributionInfos = registry.getDistributions();
        distributionInfos.remove(dinfo);
        Collection<ComponentInfo> otherInstalledComponentInfos = this.getHome().getRegistryHelper().getInstalledComponentInfos(distributionInfos);
        Collection<FeatureInfo> otherInstalledFeatureInfos = this.getHome().getRegistryHelper().getInstalledFeatureInfos(distributionInfos);
        boolean skipNginst = Boolean.parseBoolean(DefaultOraparamIni.getOraparamProfileString((String)"SKIP_NGINST_UPGRADE", null));
        if (this.getInstallationSession() != null && (prodFams = this.getInstallationSession().getProductFamilies()) != null && !prodFams.isEmpty()) {
            dinfo.setProductFamiliesStrings(prodFams);
        }
        _log.fine("Registry phase. Contents of SKIP_NGINST_UPGRADE: " + skipNginst);
        List<FeatureInfo> finfos = dinfo.getFeatures();
        for (FeatureSet feature : compMap.keySet()) {
            if (feature.hasRemovedDependencies()) {
                for (DistributionInfo distributionInfo : distributionInfos) {
                    Object distRef = new DistributionReference(distributionInfo.getName(), distributionInfo.getVersion());
                    Collection<FeatureSet> removedDependencies = feature.getRemovedDependencies((DistributionReference)((Object)distRef));
                    if (removedDependencies == null) continue;
                    for (FeatureSet removedDependency : removedDependencies) {
                        finfo = this.getHome().getRegistryHelper().getFeatureInfo(distributionInfo.getFeatures(), removedDependency.getName(), removedDependency.getVersion(), true);
                        if (finfo == null || !finfo.isDynamic()) continue;
                        distributionInfo.removeFeatureInfo(finfo);
                    }
                }
            }
            if (!feature.getName().equals("nginst_core") || !skipNginst) {
                FeatureInfo finfo2 = this.getHome().getRegistryHelper().getFeatureInfo(finfos, feature.getName(), feature.getVersion());
                if (finfo2 == null) {
                    finfo2 = new FeatureInfo(this.getHome().getClassLoader(), feature.getName(), feature.getVersion());
                    if (dynamic) {
                        finfo2.setDynamic(true);
                    }
                    dinfo.addFeature(finfo2);
                }
                if (feature.isSingleton()) {
                    finfo2.setSingleton(true);
                }
                boolean installedBySameDist = false;
                for (DistributionTarget distTarget : this.getHome().getDistributionTargetsForFeature(feature)) {
                    if (!distTarget.getDistribution().equals(distribution)) continue;
                    installedBySameDist = true;
                }
                boolean featureSelected = false;
                if (selectedFeatures.contains(feature) || this.getHome().getInstalledFeatures().contains(feature) && installedBySameDist) {
                    featureSelected = true;
                }
                this.updateCompInfos(finfo2, feature.getComponentReferences(), compMap.get(feature), otherInstalledComponentInfos, session, dynamic, featureSelected);
                if (featureSelected) {
                    Collection<FeatureSet> replaces;
                    if (feature.isSuperseded()) {
                        if (!finfo2.getStatus().isInstalled()) {
                            finfo2.setStatus(Status.upgraded);
                            String currentVersion = feature.getSuperseded().getVersion();
                            String originalVersion = finfo2.getVersion();
                            if (!finfo2.isOriginalVersionSet()) {
                                finfo2.setOriginalVersion(originalVersion);
                            }
                            finfo2.setVersion(currentVersion);
                            SessionInfo upgradeSession = session.copy();
                            upgradeSession.setAction(SessionAction.upgrade);
                            upgradeSession.setVersion(currentVersion);
                            upgradeSession.setPreviousVersion(originalVersion);
                            finfo2.addSession(upgradeSession);
                            List<FeatureInfo> existingFeatures = this.getHome().getRegistryHelper().getFeatureInfos(otherInstalledFeatureInfos, feature.getName(), currentVersion, false);
                            Object supersedingFeature = null;
                            for (FeatureInfo existingFeature : existingFeatures) {
                                Object status = existingFeature.getStatus();
                                if (!status.isInstalled() || status.isUpgraded()) continue;
                                supersedingFeature = existingFeature;
                                break;
                            }
                            if (supersedingFeature == null) {
                                if (!existingFeatures.isEmpty()) {
                                    supersedingFeature = existingFeatures.iterator().next();
                                } else {
                                    throw new GdrException("Unable to locate superseding feature set info entry in registry for " + finfo2);
                                }
                            }
                            List<ComponentInfo> supersedingComponentInfos = ((FeatureInfo)supersedingFeature).getComponents();
                            List<ComponentInfo> currentComponentInfos = finfo2.getComponents();
                            for (ComponentInfo currentComponentInfo : currentComponentInfos) {
                                supersedingComponentInfos.remove(currentComponentInfo);
                            }
                            if (!supersedingComponentInfos.isEmpty()) {
                                for (ComponentInfo ci : supersedingComponentInfos) {
                                    finfo2.addComponent(ci);
                                }
                            }
                        }
                    } else if (!finfo2.getStatus().isInstalled()) {
                        finfo2.setStatus(Status.installed);
                        finfo2.addSession(session);
                    }
                    if ((replaces = feature.getReplaces()) == null || replaces.isEmpty()) continue;
                    for (FeatureSet replaced : replaces) {
                        List<FeatureInfo> replacedFeatures = this.getHome().getRegistryHelper().getFeatureInfos(otherInstalledFeatureInfos, replaced.getName(), replaced.getVersion(), false);
                        if (replacedFeatures == null || replacedFeatures.isEmpty()) continue;
                        for (FeatureInfo replacedFeature : replacedFeatures) {
                            replacedFeature.setStatus(Status.upgraded);
                            replacedFeature.setSingleton(feature.isSingleton());
                            String currentVersion = feature.getVersion();
                            String originalVersion = replacedFeature.getVersion();
                            if (!replacedFeature.isOriginalVersionSet()) {
                                replacedFeature.setOriginalVersion(originalVersion);
                            }
                            replacedFeature.setVersion(currentVersion);
                            SessionInfo upgradeSession = session.copy();
                            upgradeSession.setAction(SessionAction.upgrade);
                            upgradeSession.setVersion(currentVersion);
                            upgradeSession.setPreviousVersion(originalVersion);
                            replacedFeature.addSession(upgradeSession);
                            List<ComponentInfo> replacedComponentInfos = replacedFeature.getComponents();
                            List<ComponentInfo> currentComponentInfos = finfo2.getComponents();
                            Collection<Component> removedComponents = feature.getRemovedComponents();
                            for (ComponentInfo replacedComponentInfo : replacedComponentInfos) {
                                currentComponentInfos.remove(replacedComponentInfo);
                                if (removedComponents == null || removedComponents.isEmpty()) continue;
                                String name = replacedComponentInfo.getName();
                                String version = replacedComponentInfo.getVersion();
                                for (Component removedComponent : removedComponents) {
                                    if (!name.equals(removedComponent.getName()) || !version.equals(removedComponent.getVersion())) continue;
                                    replacedComponentInfo.setStatus(Status.notinstalled);
                                    SessionInfo deinstallSession = session.copy();
                                    deinstallSession.setAction(SessionAction.deinstall);
                                    replacedComponentInfo.addSession(deinstallSession);
                                    List<TargetInfo> replacedTargets = replacedComponentInfo.getTargets();
                                    for (TargetInfo replacedTarget : replacedTargets) {
                                        replacedTarget.setStatus(Status.notinstalled);
                                        replacedTarget.addSession(deinstallSession);
                                    }
                                }
                            }
                            if (currentComponentInfos.isEmpty()) continue;
                            for (ComponentInfo ci : currentComponentInfos) {
                                replacedFeature.addComponent(ci);
                            }
                        }
                    }
                    continue;
                }
                if (finfo2.getStatus() == Status.notinstalled) continue;
                finfo2.setStatus(Status.notinstalled);
                continue;
            }
            _log.info("Skipping registry update of nginst_core featureset since SKIP_NGINST_UPGRADE is set to true");
        }
        for (FeatureSet feature : compMap.keySet()) {
            if (feature.hasReplaces() && feature.hasReplacesDependencies()) {
                for (DistributionInfo distributionInfo : distributionInfos) {
                    List<FeatureInfo> replacedFeatures = this.getHome().getRegistryHelper().getFeatureInfos(distributionInfo.getFeatures(), feature.getName(), feature.getVersion(), false);
                    if (replacedFeatures == null || replacedFeatures.isEmpty()) continue;
                    for (FeatureSet replacesDependency : feature.getReplacesDependencies()) {
                        FeatureInfo replacesDepInfo = this.getHome().getRegistryHelper().getFeatureInfo(distributionInfo.getFeatures(), replacesDependency.getName(), replacesDependency.getVersion());
                        if (replacesDepInfo == null) {
                            finfo = this.getHome().getRegistryHelper().getFeatureInfo(dinfo.getFeatures(), replacesDependency.getName(), replacesDependency.getVersion());
                            finfo = finfo.copy();
                            finfo.setDynamic(true);
                            for (ComponentInfo componentInfo : finfo.getComponents()) {
                                componentInfo.setDynamic(true);
                            }
                            distributionInfo.addFeature(finfo);
                            continue;
                        }
                        if (replacesDepInfo.getStatus().isInstalled()) continue;
                        replacesDepInfo.setStatus(Status.installed);
                        replacesDepInfo.addSession(session);
                    }
                }
                continue;
            }
            if (!feature.isSuperseded() || !feature.hasSupersedingDependencies()) continue;
            for (FeatureSet superDep : feature.getSupersedingDependencies()) {
                FeatureInfo currentDistFtrInfo = this.getHome().getRegistryHelper().getFeatureInfo(dinfo.getFeatures(), superDep.getName(), superDep.getVersion());
                if (currentDistFtrInfo == null) {
                    for (DistributionInfo distributionInfo : distributionInfos) {
                        FeatureInfo otherDistFtrInfo = this.getHome().getRegistryHelper().getFeatureInfo(distributionInfo.getFeatures(), superDep.getName(), superDep.getVersion());
                        if (otherDistFtrInfo == null) continue;
                        currentDistFtrInfo = otherDistFtrInfo.copy();
                        currentDistFtrInfo.setDynamic(true);
                        for (ComponentInfo componentInfo : currentDistFtrInfo.getComponents()) {
                            componentInfo.setDynamic(true);
                        }
                        dinfo.addFeature(currentDistFtrInfo);
                        break;
                    }
                }
                if (currentDistFtrInfo == null) {
                    currentDistFtrInfo = dinfo.addFeature(superDep);
                    currentDistFtrInfo.setStatus(Status.installed);
                    currentDistFtrInfo.addSession(session);
                    currentDistFtrInfo.setDynamic(true);
                    continue;
                }
                if (currentDistFtrInfo.getStatus().isInstalled()) continue;
                currentDistFtrInfo.setStatus(Status.installed);
                currentDistFtrInfo.addSession(session);
            }
        }
        try {
            this.getHome().getRegistryHelper().persistSessionFederatedHomes(registry, this.getHome());
        }
        catch (IOException e) {
            throw new GdrException("Failed to persist this session's federated homes.", (Throwable)e);
        }
    }

    protected void updateCompInfos(FeatureInfo finfo, List<ComponentReference> compRefs, Collection<Component> components, Collection<ComponentInfo> otherInstalledComponentInfos, SessionInfo session, boolean dynamic, boolean featureSelected) {
        List<ComponentInfo> cinfos = finfo.getComponents();
        for (ComponentReference compRef : compRefs) {
            Component component = ComponentHelper.getInstance().getComponent(components, compRef);
            ComponentInfo cinfo = this.getHome().getRegistryHelper().getComponentInfo(cinfos, compRef.getName(), compRef.getOriginalVersion(), true);
            if (cinfo == null) {
                cinfo = new ComponentInfo(this.getHome().getClassLoader(), compRef.getName(), compRef.getVersion(), component != null ? component.getPatchLevel() : null);
                if (dynamic) {
                    cinfo.setDynamic(true);
                }
                finfo.addComponent(cinfo);
            }
            if (component != null && component.isSingleton()) {
                cinfo.setSingleton(true);
            }
            if (featureSelected && component != null) {
                Collection<Component> replaces;
                if (component.isSuperseded()) {
                    if (!cinfo.getStatus().isInstalled()) {
                        cinfo.setStatus(Status.upgraded);
                        String currentVersion = component.getSuperseded().getVersion();
                        String originalVersion = cinfo.getVersion();
                        if (!cinfo.isOriginalVersionSet()) {
                            cinfo.setOriginalVersion(originalVersion);
                        }
                        cinfo.setVersion(currentVersion);
                        String patchLevel = component.getSuperseded().getPatchLevel();
                        cinfo.setPatchLevel(patchLevel);
                        SessionInfo upgradeSession = session.copy();
                        upgradeSession.setAction(SessionAction.upgrade);
                        upgradeSession.setVersion(currentVersion);
                        upgradeSession.setPreviousVersion(originalVersion);
                        if (originalVersion.equals(currentVersion)) {
                            upgradeSession.setPreviousPatchLevel(component.getPatchLevel());
                        }
                        upgradeSession.setPatchLevel(patchLevel);
                        cinfo.addSession(upgradeSession);
                        ComponentInfo supersedingComponent = this.getHome().getRegistryHelper().getComponentInfo(otherInstalledComponentInfos, compRef.getName(), currentVersion, false);
                        cinfo.setTargets(supersedingComponent.getTargets());
                    }
                } else if (!component.isOmitted()) {
                    Collection<ComponentTarget> targets;
                    if (!cinfo.getStatus().isInstalled()) {
                        cinfo.setStatus(Status.installed);
                        cinfo.addSession(session);
                    }
                    if ((targets = component.getComponentTargets()) != null && !targets.isEmpty()) {
                        List<TargetInfo> tinfos = cinfo.getTargets();
                        for (ComponentTarget target : targets) {
                            TargetInfo tinfo = this.getHome().getRegistryHelper().getTargetInfo(tinfos, target.getReferenceQualifier());
                            if (tinfo == null) {
                                tinfo = new TargetInfo(this.getHome().getClassLoader(), target);
                                cinfo.addTarget(tinfo);
                            }
                            if (tinfo.getStatus().isInstalled()) continue;
                            tinfo.setStatus(Status.installed);
                            tinfo.addSession(session);
                        }
                    }
                }
                if ((replaces = component.getReplaces()) == null || replaces.isEmpty()) continue;
                for (Component replaced : replaces) {
                    List<ComponentInfo> replacedComponents = this.getHome().getRegistryHelper().getComponentInfos(otherInstalledComponentInfos, replaced.getName(), replaced.getVersion(), false);
                    if (replacedComponents == null || replacedComponents.isEmpty()) continue;
                    for (ComponentInfo replacedComponent : replacedComponents) {
                        replacedComponent.setStatus(Status.upgraded);
                        replacedComponent.setSingleton(component.isSingleton());
                        String currentVersion = component.getVersion();
                        String originalVersion = replacedComponent.getVersion();
                        if (!replacedComponent.isOriginalVersionSet()) {
                            replacedComponent.setOriginalVersion(originalVersion);
                        }
                        replacedComponent.setVersion(currentVersion);
                        replacedComponent.setPatchLevel(component.getPatchLevel());
                        SessionInfo upgradeSession = session.copy();
                        upgradeSession.setAction(SessionAction.upgrade);
                        upgradeSession.setVersion(currentVersion);
                        upgradeSession.setPreviousVersion(originalVersion);
                        if (originalVersion.equals(currentVersion)) {
                            upgradeSession.setPreviousPatchLevel(replaced.getPatchLevel());
                        }
                        upgradeSession.setPatchLevel(component.getPatchLevel());
                        replacedComponent.addSession(upgradeSession);
                        replacedComponent.setTargets(cinfo.getTargets());
                    }
                }
                continue;
            }
            if (cinfo.getStatus().isNotInstalled()) continue;
            cinfo.setStatus(Status.notinstalled);
        }
    }

    @Override
    public void addExtraFilesToDeInstallInfo(String name, String version, Collection<Path> files, boolean isFeature) throws GdrException {
        this.isInstallationStarted();
        DeInstallInfoHelper.getInstance().addExtraFilesToDeInstallInfo(this.getDeInstallInfo(), name, version, files, isFeature, this.getHome().getHomePath());
    }

    public boolean installPatches() throws GdrException {
        Path registryFile = this.getHome().getRegistryFilePath();
        Path preRegistryPath = this.getPreRegistryFilePath();
        try {
            if (!Files.exists(preRegistryPath, new LinkOption[0])) {
                GdrException ex = new GdrException("The pre-registry does not exist.");
                _log.throwing(CommonInstaller.class.getName(), "installPatches", ex);
                throw ex;
            }
            long preRegistryLength = Files.size(preRegistryPath);
            Registry registry = this.getLockedRegistry();
            if (!NioFileLockService.getFileLock((Path)preRegistryPath)) {
                GdrException ex = new GdrException("Unable to obtain lock on pre-registry.");
                _log.throwing(CommonInstaller.class.getName(), "installPatches", ex);
                throw ex;
            }
            registry.setSessions(this._registrySession.getId());
            this.updateRegistryForPatches(registry, this._registrySession);
            this.unlockRegistry();
            if (this._preRegistryLength > -1L && this._preRegistryLength == preRegistryLength) {
                FileChannel fc = NioFileLockService.getFileChannel((Path)preRegistryPath);
                fc.truncate(0L);
                NioFileLockService.releaseFileLock((Path)preRegistryPath);
                Files.delete(preRegistryPath);
            } else {
                NioFileLockService.releaseFileLock((Path)preRegistryPath);
            }
            NioFileLockService.releaseFileLock((Path)registryFile);
        }
        catch (IOException e) {
            throw new GdrException((Throwable)e);
        }
        catch (DataHandlerException e) {
            throw new GdrException((Throwable)e);
        }
        this._installationStarted = false;
        this._registrySession = null;
        return true;
    }

    protected void applyMetadataPatch() {
        String overridePatchesDir = this.getInstallationSession().getServiceHolder().getVariableResolverService().get("METADATA_PATCH_DIR_OVERRIDE");
        Path patchesDir = overridePatchesDir != null && !overridePatchesDir.isEmpty() ? NioHelper.getInstance().getPath(overridePatchesDir, new String[0]) : this.getMetaDataHome().getGdrMetaDataHomePath().resolve("patches");
        if (Files.isDirectory(patchesDir, new LinkOption[0])) {
            try (DirectoryStream<Path> patchDirs = Files.newDirectoryStream(patchesDir);){
                PatchFactory factory = BasePatchFactory.instance();
                for (Path patchDir : patchDirs) {
                    _log.info("Attempting to apply metadata patch located in: " + patchDir);
                    try {
                        String oraHome = this.getHome().getHomePath().toString();
                        oracle.glcm.opatch.common.api.Patch metadataPatch = factory.createPatch(patchDir.toString());
                        if (metadataPatch != null) {
                            _log.info("Patch " + metadataPatch.getPatchId() + " will be applied to home: " + oraHome);
                            ArrayList<PatchInventory.Component> patchComps = metadataPatch.getComponents();
                            if (patchComps == null || patchComps.isEmpty()) {
                                Component randomComponent = this.getPostProcessComponents().iterator().next();
                                patchComps = new ArrayList<PatchInventory.Component>();
                                patchComps.add(new HomeOperationsImpl.ComponentWrapper(HomeOperationsFactory.getInstance().getComponentInfo(randomComponent.getName(), randomComponent.getVersion(), randomComponent.getPatchLevel())));
                                metadataPatch = new PatchWrapper(metadataPatch, patchComps);
                            }
                            factory.getPatchFastInstallInstance().apply(oraHome, metadataPatch);
                            continue;
                        }
                        _log.warning("Unable to load meta-data patch from: " + patchDir);
                    }
                    catch (Exception e) {
                        _log.log(Level.WARNING, "Failed to apply meta-data patch: " + patchDir, e);
                    }
                }
            }
            catch (IOException e) {
                _log.log(Level.WARNING, "Failed to create directory stream from directory: " + patchesDir, e);
            }
        }
    }

    protected void unlockRegistry() throws IOException, DataHandlerException, GdrException {
        this.getHome().unlockRegistry();
    }

    protected Registry getLockedRegistry() throws IOException, DataHandlerException, GdrException {
        return this.getHome().lockRegistry();
    }

    protected void updateRegistryForPatches(Registry registry, SessionInfo session) throws GdrException {
        this.updateRegistryForPatches(registry, session, this.getDistribution(), this.getComponentsMap());
    }

    protected void updateRegistryForPatches(Registry registry, SessionInfo session, Distribution distribution, Map<FeatureSet, Collection<Component>> compMap) throws GdrException {
        if (distribution == null) {
            throw new GdrException("The distribution provided was null.");
        }
        DistributionInfo dinfo = this.getHome().getRegistryHelper().getDistributionInfo(registry, distribution.getName(), distribution.getVersion());
        if (dinfo != null) {
            List<FeatureInfo> finfos = dinfo.getFeatures();
            for (FeatureSet feature : compMap.keySet()) {
                FeatureInfo finfo = this.getHome().getRegistryHelper().getFeatureInfo(finfos, feature.getName(), feature.getVersion());
                if (null == finfo || !finfo.getStatus().isInstalled()) continue;
                List<ComponentReference> compRefs = feature.getComponentReferences();
                List<ComponentInfo> cinfos = finfo.getComponents();
                Collection<Component> components = compMap.get(feature);
                for (ComponentReference compRef : compRefs) {
                    Set<Patch> patches;
                    ComponentInfo cinfo = this.getHome().getRegistryHelper().getComponentInfo(cinfos, compRef.getName(), compRef.getVersion());
                    Component component = ComponentHelper.getInstance().getComponent(components, compRef);
                    if (null == component || !cinfo.getStatus().isInstalled()) continue;
                    List<PatchInfo> pinfos = cinfo.getPatches();
                    try {
                        patches = PatchHelper.getInstance().getPatches(this.getMetaDataHomeDir());
                    }
                    catch (Exception e) {
                        GdrException ex = new GdrException("An error ocurred when retrieving patches.");
                        _log.throwing(CommonInstaller.class.getName(), "updateRegistryForPatches", ex);
                        throw ex;
                    }
                    for (Patch patch : patches) {
                        PatchInfo pinfo = this.getHome().getRegistryHelper().getPatchInfo(pinfos, patch.getPatchId());
                        if (null != pinfo) continue;
                        pinfo = new PatchInfo(this.getHome().getClassLoader(), patch.getPatchId());
                        pinfo.setStatus(Status.installed);
                        pinfo.addSession(session);
                        cinfo.addPatch(pinfo);
                    }
                }
            }
        }
    }
}

