/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.nfo.ExternalFeatureReference;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.installation.CommonInstaller;
import com.oracle.cie.gdr.installation.ComponentArchiveInstallationSession;
import com.oracle.cie.gdr.installation.DistributionInstaller;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ComponentArchiveInstaller
extends CommonInstaller {
    private static final Logger _log = Logger.getLogger(ComponentArchiveInstaller.class.getName());
    private ComponentArchiveInstallationSession _componentArchiveInstallationSession;

    public ComponentArchiveInstaller(ComponentArchiveInstallationSession installerSession, Map<String, String> variableMap) throws IOException, DataHandlerException, GdrException, DependencyException {
        super(installerSession, variableMap);
        this._componentArchiveInstallationSession = installerSession;
        this._componentArchiveInstallationSession.validateInstallation();
    }

    public ComponentArchiveInstallationSession getComponentArchiveInstallationSession() {
        return this._componentArchiveInstallationSession;
    }

    public FeatureLoader getFeatureLoader() {
        return this.getComponentArchiveInstallationSession().getFeatureLoader();
    }

    public ComponentLoader getComponentLoader() {
        return this.getComponentArchiveInstallationSession().getComponentLoader();
    }

    @Override
    public Map<ExternalFeatureReference, List<Reference>> getExternalDistributions() {
        return null;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return FeatureSetHelper.getInstance().getSortedByDiskOrder(this.getFeatureSets(), this.getComponentsMap());
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap() {
        return this.getComponentLoader().getComponentsMap();
    }

    @Override
    public void saveHomeMetadata(Path dir) throws GdrException, DataHandlerException, IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                GdrException ex = new GdrException("Directory specified did not exist and could not be created: " + dir, (Throwable)e);
                _log.throwing(DistributionInstaller.class.getName(), "saveHomeMetadata", ex);
                throw ex;
            }
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            GdrException ex = new GdrException("Directory specified was not a directory: " + dir);
            _log.throwing(DistributionInstaller.class.getName(), "saveHomeMetadata", ex);
            throw ex;
        }
        Path distributionDir = dir.resolve("distributions");
        DistributionHelper.getInstance().save((IDataHandlerWrapper)this.getDistribution(), distributionDir.resolve(DistributionHelper.getInstance().getDistributionFileName(this.getDistribution())));
        Path featuresDir = dir.resolve("featuresets");
        this.getFeatureLoader().saveFeatures(featuresDir);
        ComponentHelper.getInstance().saveComponentsInShipHomeStructure(dir, true, this.getComponentLoader().getComponents());
    }

    @Override
    public Distribution getDistribution() {
        return this.getComponentArchiveInstallationSession().getDistributionTarget().getDistribution();
    }

    @Override
    public Set<FeatureSet> getFeatureSets() {
        return this.getFeatureLoader().getFeatureSets();
    }

    @Override
    protected void updateRegistry(Registry registry, SessionInfo session) throws GdrException {
        super.updateRegistry(registry, session, true);
    }
}

