/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.AuxiliaryDirectoryMap;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.InstallType;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dao.nfo.InstallerComponentInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerDistributionInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerInfo;
import com.oracle.cie.gdr.dao.pai.PatchAttachmentInfo;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.InstallerSession;
import com.oracle.cie.gdr.external.impl.FeatureSetImpl;
import com.oracle.cie.gdr.external.impl.InstallTypeImpl;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.InstallerInfoHelper;
import com.oracle.cie.gdr.helpers.LabelMapHelper;
import com.oracle.cie.gdr.helpers.PatchAttachmentInfoHelper;
import com.oracle.cie.gdr.installation.InstallationSession;
import com.oracle.cie.gdr.installation.InstallationValidator;
import com.oracle.cie.gdr.session.DistributionSession;
import com.oracle.cie.gdr.session.DistributionSessionImpl;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.ini.DefaultOraparamIni;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DistributionInstallationSession
extends InstallationSession
implements InstallerSession,
DistributionSession {
    private static final Logger _log = Logger.getLogger(DistributionInstallationSession.class.getName());
    protected DistributionSessionImpl _distributionSession;
    private ComponentLoader _componentLoader;
    private DirectoryMap _directoryMap;
    private LabelMap _labelMap = null;
    private PatchAttachmentInfo _patchAttachmentInfo;

    public DistributionInstallationSession(File shipHomeDir, File homeDir, Set<Integer> platforms, Set<Integer> locales) throws GdrException, DependencyException, IOException, DataHandlerException {
        this(shipHomeDir, homeDir, null, platforms, locales);
    }

    public DistributionInstallationSession(File shipHomeDir, File homeDir, Reference distributionReference, Set<Integer> platforms, Set<Integer> locales) throws GdrException, DependencyException, IOException, DataHandlerException {
        this(shipHomeDir, homeDir, distributionReference, platforms, locales, null);
    }

    public DistributionInstallationSession(File shipHomeDir, File homeDir, Reference distributionReference, Set<Integer> platforms, Set<Integer> locales, InstallerInfo installerInfo) throws GdrException, DependencyException, IOException, DataHandlerException {
        super(shipHomeDir, homeDir, platforms, locales);
        this.init(distributionReference, installerInfo);
    }

    public DistributionInstallationSession(MetaDataHome metaDataHome, File homeDir, Reference distributionReference, Set<Integer> platforms, Set<Integer> locales, InstallerInfo installerInfo) throws GdrException, DependencyException, IOException, DataHandlerException {
        super(metaDataHome, homeDir, platforms, locales);
        this.init(distributionReference, installerInfo);
    }

    public DistributionInstallationSession(MetaDataHome metaDataHome, Path homeDir, Reference distributionReference, Set<Integer> platforms, Set<Integer> locales, InstallerInfo installerInfo, Map<Reference, Component> previouslyLoadedComponents) throws GdrException, DependencyException, IOException, DataHandlerException {
        super(metaDataHome, homeDir, platforms, locales, previouslyLoadedComponents);
        this.init(distributionReference, installerInfo);
    }

    @Override
    public void setHome(Home home) throws GdrException {
        super.setHome(home);
        this._distributionSession.setHome(home);
        this.setInstallationStates(this._distributionSession.getDistributionLoader().getDistribution(), this.getComponentLoader().getComponentsMap());
        this._distributionSession.validateInstallTypes();
    }

    @Override
    public DistributionLoader getDistributionLoader() {
        return this._distributionSession.getDistributionLoader();
    }

    @Override
    public FeatureSelectionTarget getFeatureSelectionTarget() {
        return this._distributionSession.getFeatureSelectionTarget();
    }

    @Override
    public ComponentLoader getComponentLoader() {
        return this._componentLoader;
    }

    @Override
    public Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> getSelectedFeatures() {
        Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> selectedFeatures = this._distributionSession.getSelectedFeatures();
        return FeatureSetHelper.getInstance().getSortedByDiskOrder(selectedFeatures, this.getComponentLoader().getComponentsMap());
    }

    @Override
    public void setSelectedFeatures(Set<Reference> featureRefs) throws GdrException, DependencyException {
        this._distributionSession.setSelectedFeatures(featureRefs);
    }

    @Override
    public DirectoryMap getDirectoryMap() {
        return this._directoryMap;
    }

    @Override
    public void setAuxiliaryDirectoryMap(String name) throws GdrException {
        AuxiliaryDirectoryMap directoryMap = null;
        List<AuxiliaryDirectoryMap> auxiliaryDirectoryMaps = this.getDistributionLoader().getDistribution().getAuxiliaryDirectoryMaps();
        if (auxiliaryDirectoryMaps != null && !auxiliaryDirectoryMaps.isEmpty()) {
            for (AuxiliaryDirectoryMap auxiliaryDirectoryMap : auxiliaryDirectoryMaps) {
                if (!auxiliaryDirectoryMap.getName().equals(name)) continue;
                directoryMap = auxiliaryDirectoryMap;
                break;
            }
        }
        if (directoryMap == null) {
            throw new GdrException("Unable to locate auxiliary directory map: " + name);
        }
        if (this._directoryMap != directoryMap) {
            this._directoryMap = directoryMap;
            try {
                this.loadComponents();
            }
            catch (IOException e) {
                throw new GdrException((Throwable)e);
            }
            catch (DataHandlerException e) {
                throw new GdrException((Throwable)e);
            }
        }
    }

    protected void init(Reference distributionReference, InstallerInfo installerInfo) throws IOException, DataHandlerException, GdrException {
        MetaDataHome metadataHome;
        if (distributionReference == null) {
            distributionReference = DistributionHelper.getInstance().locateDistribution(this.getMetaDataHome());
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Creating distribution session using distribution " + (Object)((Object)distributionReference));
        }
        this._distributionSession = new DistributionSessionImpl(this.getHome(), this.getMetaDataHome(), distributionReference, Mode.INSTALL);
        Path infoDir = this.getMetaDataHome().getGdrMetaDataHomePath().resolve(InstallerInfoHelper.getInstance().getPath());
        Path installerInfoFile = infoDir.resolve("installer-info.xml");
        if (Files.exists(installerInfoFile, new LinkOption[0])) {
            InstallerInfo distributionInstallerInfo = InstallerInfoHelper.getInstance().getInstallerInfo(installerInfoFile);
            if (installerInfo != null) {
                InstallerInfoHelper.getInstance().mergeInstallerInfoPackagingStates(distributionInstallerInfo, installerInfo);
            }
            this.setInstallerInfo(distributionInstallerInfo);
        } else if (installerInfo != null) {
            this.setInstallerInfo(installerInfo);
        }
        Path patchAttachmentInfoFile = infoDir.resolve("patch-attachment-info.xml");
        Path baseDir = this.getShipHomeDirPath().getParent().resolve("Disk1");
        if (Boolean.valueOf(DefaultOraparamIni.getOraparamProfileString((String)"NETWORK_INSTALL", (String)"false")).booleanValue()) {
            patchAttachmentInfoFile = baseDir.resolve("stage" + File.separator + "info" + File.separator + "patch-attachment-info.xml");
        }
        if (Files.exists(patchAttachmentInfoFile, new LinkOption[0])) {
            PatchAttachmentInfo patchAttachmentInfo = PatchAttachmentInfoHelper.getInstance().getPatchAttachmentInfo(patchAttachmentInfoFile);
            if (Boolean.valueOf(DefaultOraparamIni.getOraparamProfileString((String)"NETWORK_INSTALL", (String)"false")).booleanValue()) {
                this.setPatchAttachmentInfo(patchAttachmentInfo, baseDir);
            } else {
                this.setPatchAttachmentInfo(patchAttachmentInfo);
            }
        }
        if (!(metadataHome = this.getMetaDataHome()).isShiphome() && !metadataHome.isRepository()) {
            this._labelMap = LabelMapHelper.getInstance().getLabelMap(this.getMetaDataHome().getGdrMetaDataHomePath());
        }
        this._directoryMap = this.getDistributionLoader().getDirectoryMap();
        this.loadComponents();
    }

    private void loadComponents() throws GdrException, IOException, DataHandlerException {
        this._componentLoader = new ComponentLoader(this.getMetaDataHome(), this.getServiceHolder(), Mode.INSTALL, this.getDistributionLoader().getFeatureSets(), this._directoryMap, this.getInstallerDistributionInfo(), this._labelMap, this.getPreviouslyLoadedComponents());
        this.setInstallationStates(this._distributionSession.getDistributionLoader().getDistribution(), this.getComponentLoader().getComponentsMap());
    }

    @Override
    public void validateInstallation() throws DependencyException, GdrException {
        DistributionTarget installedDistMatch;
        super.validateInstallation();
        this._distributionSession.initDefaultInstallType();
        InstallerDistributionInfo installerDistributionInfo = this.getInstallerDistributionInfo();
        if (this.getMetaDataHome().isShiphome() && installerDistributionInfo != null) {
            LinkedHashSet targetSelectedFeatures = new LinkedHashSet(this.getFeatureSelectionTarget().getOrderedSelection());
            for (com.oracle.cie.gdr.dao.ftr.FeatureSet feature : targetSelectedFeatures) {
                List<ComponentReference> refs = feature.getComponentReferences();
                if (refs == null || refs.isEmpty()) continue;
                for (ComponentReference ref : refs) {
                    File diskDir;
                    int disk;
                    InstallerComponentInfo cinfo = InstallerInfoHelper.getInstance().getInstallerComponentInfo(installerDistributionInfo, feature, ref);
                    if (cinfo == null || !cinfo.isPackaged() || (disk = cinfo.getDisk()) <= 1 || !(diskDir = this.getMetaDataHome().getComponentMetaDataHome().getParentFile()).getName().startsWith("Disk") || (diskDir = new File(diskDir.getParentFile(), "Disk" + disk)).exists()) continue;
                    _log.severe("The component " + (Object)((Object)ref) + " which is referenced by the selected feature " + feature + " requires Disk " + disk + " but the directory does not exist " + diskDir);
                    GdrException ex = new GdrException("The selected feature " + feature + " contains a component which requires Disk" + disk + " but the directory does not exist " + diskDir);
                    _log.throwing(DistributionInstallationSession.class.getName(), "validateInstallation", ex);
                    throw ex;
                }
            }
        }
        DistributionTarget dist = this.getDistributionLoader().getDistributionTarget();
        this.refreshRegistry();
        DistributionTarget distributionTarget = installedDistMatch = this._home != null ? this._home.getInstalledDistribution(dist.getDistributionName(), dist.getDistributionVersion()) : null;
        if (installedDistMatch != null) {
            this.setInstallationStates(this._distributionSession.getDistributionLoader().getDistribution(), this.getComponentLoader().getComponentsMap());
        }
        InstallationValidator.validate(this.getDistributionTarget(), this.getDistributionInfo(), this.getSelectedFeatures(), this.getComponentLoader(), null, this.getHome());
    }

    @Override
    public Set<com.oracle.cie.gdr.external.InstallType> getInstallTypes() {
        LinkedHashSet<com.oracle.cie.gdr.external.InstallType> extInstallTypes = new LinkedHashSet<com.oracle.cie.gdr.external.InstallType>();
        Set<InstallType> installTypes = this._distributionSession.getInstallTypes();
        if (installTypes != null && !installTypes.isEmpty()) {
            for (InstallType installType : installTypes) {
                extInstallTypes.add(new InstallTypeImpl(installType));
            }
        }
        return extInstallTypes;
    }

    @Override
    public com.oracle.cie.gdr.external.InstallType getDefaultInstallType() {
        InstallType installType = this._distributionSession.getDefaultInstallType();
        return new InstallTypeImpl(installType);
    }

    @Override
    public void setInstallType(com.oracle.cie.gdr.external.InstallType installType) throws DependencyException, GdrException {
        super.setInstallType(installType);
        this._distributionSession.setInstallType(((InstallTypeImpl)installType).getInstallType());
    }

    @Override
    public Set<FeatureSet> getCurrentlySelectedFeatures() {
        LinkedHashSet<FeatureSet> externalFeatures = new LinkedHashSet<FeatureSet>();
        Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> selectedFeatures = this.getSelectedFeatures();
        if (selectedFeatures != null && !selectedFeatures.isEmpty()) {
            for (com.oracle.cie.gdr.dao.ftr.FeatureSet feature : selectedFeatures) {
                externalFeatures.add(FeatureSetImpl.newInstance(feature, this.getMetaDataHome(), Mode.INSTALL));
            }
        }
        return externalFeatures;
    }

    private void refreshRegistry() throws GdrException {
        if (this._home != null) {
            try {
                this._home = Home.getHome(this._home.getHomePath());
            }
            catch (Exception e) {
                throw new GdrException("Could not refresh Home", (Throwable)e);
            }
        }
    }

    public PatchAttachmentInfo getPatchAttachmentInfo() {
        return this._patchAttachmentInfo;
    }

    public void setPatchAttachmentInfo(PatchAttachmentInfo patchAttachmentInfo, Path patchesLocation) {
        patchAttachmentInfo.setPatchesLoc(PatchAttachmentInfoHelper.getInstance().getPatchAttachmentsLocation(patchesLocation));
        this._patchAttachmentInfo = patchAttachmentInfo;
    }

    public void setPatchAttachmentInfo(PatchAttachmentInfo patchAttachmentInfo) {
        if (this.getMetaDataHome().isRepository()) {
            patchAttachmentInfo.setPatchesLoc(PatchAttachmentInfoHelper.getInstance().getPatchAttachmentsLocation(this.getMetaDataHome().getComponentMetaDataHomePath().resolve("com.oracle.cie".replaceAll("\\.", "/"))));
        } else {
            patchAttachmentInfo.setPatchesLoc(PatchAttachmentInfoHelper.getInstance().getPatchAttachmentsLocation(this.getMetaDataHome().getSrchomePath()));
        }
        this._patchAttachmentInfo = patchAttachmentInfo;
    }
}

