/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.di.DistributionInfo;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.nfo.ExternalFeatureReference;
import com.oracle.cie.gdr.dependency.FeatureDependencyManager;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.installation.CommonInstaller;
import com.oracle.cie.gdr.installation.DistributionInstallationSession;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.ini.DefaultOraparamIni;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DistributionInstaller
extends CommonInstaller {
    private static final Logger _log = Logger.getLogger(DistributionInstaller.class.getName());
    private DistributionInstallationSession _distributionInstallationSession;

    public DistributionInstaller(DistributionInstallationSession installerSession, Map<String, String> variableMap) throws GdrException, IOException, DataHandlerException, DependencyException {
        super(installerSession, variableMap);
        this._distributionInstallationSession = installerSession;
        this._distributionInstallationSession.validateInstallation();
    }

    public DistributionInstallationSession getDistributionInstallationSession() {
        return this._distributionInstallationSession;
    }

    public DistributionLoader getDistributionLoader() {
        return this.getDistributionInstallationSession().getDistributionLoader();
    }

    public ComponentLoader getComponentLoader() {
        return this.getDistributionInstallationSession().getComponentLoader();
    }

    public FeatureSelectionTarget getFeatureSelectionTarget() {
        return this.getDistributionInstallationSession().getFeatureSelectionTarget();
    }

    @Override
    public Set<FeatureSet> getFeatureSets() {
        return this.getDistributionLoader().getFeatureSets();
    }

    @Override
    public Distribution getDistribution() {
        return this.getDistributionLoader().getDistribution();
    }

    public Set<FeatureSet> getInstalledFeatureSets() {
        HashSet<FeatureSet> installedFeatures = new HashSet<FeatureSet>();
        Set<FeatureSet> allFeatures = this.getFeatureSets();
        for (FeatureSet feature : allFeatures) {
            if (!feature.getStatus().isInstalled()) continue;
            installedFeatures.add(feature);
        }
        return installedFeatures;
    }

    @Override
    public Map<ExternalFeatureReference, List<Reference>> getExternalDistributions() {
        return this.getInstallationSession().getExternalDistributions();
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return this.getDistributionInstallationSession().getSelectedFeatures();
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap() {
        return this.getComponentLoader().getComponentsMap();
    }

    @Override
    public void saveHomeMetadata(Path dir) throws GdrException, DataHandlerException, IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
            if (!Files.exists(dir, new LinkOption[0])) {
                GdrException ex = new GdrException("Directory specified did not exist and could not be created: " + dir);
                _log.throwing(DistributionInstaller.class.getName(), "saveHomeMetadata", ex);
                throw ex;
            }
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            GdrException ex = new GdrException("Directory specified was not a directory: " + dir);
            _log.throwing(DistributionInstaller.class.getName(), "saveHomeMetadata", ex);
            throw ex;
        }
        Path distributionDir = dir.resolve("distributions");
        DistributionInfo distributionInfo = this.getDistributionLoader().getDistributionInfo();
        List productFamilies = null;
        if (distributionInfo != null) {
            productFamilies = distributionInfo.getProductFamilies();
            distributionInfo.setProductFamilies(null);
        }
        this.getDistributionLoader().saveDistribution(distributionDir);
        if (productFamilies != null && !productFamilies.isEmpty()) {
            distributionInfo.setProductFamilies(productFamilies);
        }
        Path featuresDir = dir.resolve("featuresets");
        this.getDistributionLoader().getFeatureLoader().saveFeatures(featuresDir);
        FeatureDependencyManager dependencyManager = this.getDistributionLoader().getMetaDataHome().getFeatureDependencyManager();
        if (dependencyManager.hasFeatureSetDependencies()) {
            dependencyManager.saveFeatureDependencies(dir.resolve(FeatureDependencyManager.getFeatureSetDependencyPath()));
        }
        this.saveOraparamIni(dir);
    }

    private void saveOraparamIni(Path dir) throws GdrException, IOException {
        Path iniDir = dir.resolve("inis");
        if (!Files.exists(iniDir, new LinkOption[0])) {
            Files.createDirectories(iniDir, new FileAttribute[0]);
            if (!Files.exists(iniDir, new LinkOption[0])) {
                GdrException ex = new GdrException("Directory specified did not exist and could not be created: " + iniDir);
                _log.throwing(DistributionInstaller.class.getName(), "saveOraparamIni", ex);
                throw ex;
            }
        } else if (!Files.isDirectory(iniDir, new LinkOption[0])) {
            GdrException ex = new GdrException("Directory specified was not a directory: " + iniDir);
            _log.throwing(DistributionInstaller.class.getName(), "saveOraparamIni", ex);
            throw ex;
        }
        Distribution distribution = this.getDistribution();
        String iniName = GdrHelper.getFormattedNameVersion(distribution.getName(), distribution.getVersion()) + ".ini";
        DefaultOraparamIni.save((Path)iniDir.resolve(iniName));
    }
}

