/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dei.DeInstallInfo;
import com.oracle.cie.gdr.dao.di.DistributionInfo;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.inv.DistributionReference;
import com.oracle.cie.gdr.dao.nfo.ExternalDeps;
import com.oracle.cie.gdr.dao.nfo.ExternalFeatureReference;
import com.oracle.cie.gdr.dao.nfo.InstallerDistributionInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.InstallType;
import com.oracle.cie.gdr.external.InstallerConfig;
import com.oracle.cie.gdr.external.InstallerSession;
import com.oracle.cie.gdr.external.impl.InstallTypeImpl;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DeInstallInfoHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.InstallerInfoHelper;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.session.CommonSession;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class InstallationSession
extends CommonSession
implements InstallerSession {
    private static final Logger _log = Logger.getLogger(InstallationSession.class.getName());
    private InstallerInfo _installerInfo;
    private Map<ExternalFeatureReference, List<Reference>> _externalDistributions;
    private InstallType _installType;
    private DistributionInfo _distributionInfo;
    private Map<Reference, Component> _previouslyLoadedComponents;

    public InstallationSession(File shipHomeDir, File homeDir, Set<Integer> platforms, Set<Integer> locales) throws GdrException, IOException, DataHandlerException {
        this(shipHomeDir, homeDir, platforms, locales, true);
    }

    public InstallationSession(File shipHomeDir, File homeDir, Set<Integer> platforms, Set<Integer> locales, boolean gdrLabelRequired) throws GdrException, IOException, DataHandlerException {
        this(ComponentHelper.getInstance().findMetaDataHome(shipHomeDir, gdrLabelRequired), homeDir, platforms, locales);
    }

    public InstallationSession(MetaDataHome metaDataHome, File homeDir, Set<Integer> platforms, Set<Integer> locales) throws GdrException, IOException, DataHandlerException {
        super(metaDataHome, homeDir, platforms, locales);
    }

    public InstallationSession(MetaDataHome metaDataHome, Path homeDir, Set<Integer> platforms, Set<Integer> locales) throws GdrException, IOException, DataHandlerException {
        this(metaDataHome, homeDir, platforms, locales, null);
    }

    public InstallationSession(MetaDataHome metaDataHome, Path homeDir, Set<Integer> platforms, Set<Integer> locales, Map<Reference, Component> previouslyLoadedComponents) throws GdrException, IOException, DataHandlerException {
        super(metaDataHome, homeDir, platforms, locales);
        this._previouslyLoadedComponents = previouslyLoadedComponents;
    }

    @Override
    public DistributionLoader getDistributionLoader() {
        return null;
    }

    @Override
    public DistributionInfo getDistributionInfo() {
        return this.getDistributionLoader() != null ? this.getDistributionLoader().getDistributionInfo() : this._distributionInfo;
    }

    public void setDistributionInfo(DistributionInfo distributionInfo) {
        this._distributionInfo = distributionInfo;
    }

    public Collection<String> getProductFamilies() {
        return DistributionInfoHelper.getInstance((ClassLoader)this.getHome().getClassLoader()).getProductFamilies(this.getDistributionInfo());
    }

    @Override
    public DistributionTarget getDistributionTarget() {
        DistributionLoader distributionLoader = this.getDistributionLoader();
        return distributionLoader == null ? null : distributionLoader.getDistributionTarget();
    }

    @Override
    public FeatureSelectionTarget getFeatureSelectionTarget() {
        return null;
    }

    @Override
    public Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> getSelectedFeatures() {
        return null;
    }

    @Override
    public ComponentLoader getComponentLoader() {
        return null;
    }

    @Override
    public void setSelectedFeatures(Set<Reference> featureRefs) throws GdrException, DependencyException {
    }

    @Override
    public void setAuxiliaryDirectoryMap(String name) throws GdrException {
        throw new GdrException("Setting the auxiliary directory map not supported by this session.");
    }

    public Map<Reference, Component> getPreviouslyLoadedComponents() {
        return this._previouslyLoadedComponents;
    }

    @Override
    public File getShipHomeDir() {
        return this.getMetaDataHome().getComponentMetaDataHome();
    }

    public Path getShipHomeDirPath() {
        return this.getMetaDataHome().getComponentMetaDataHomePath();
    }

    public DirectoryMap getDirectoryMap() {
        return null;
    }

    public InstallerInfo getInstallerInfo() {
        return this._installerInfo;
    }

    public void setInstallerInfo(InstallerInfo installerInfo) {
        this._installerInfo = installerInfo;
    }

    @Override
    public void validateInstallation() throws DependencyException, GdrException {
        if (this.getHome() == null) {
            GdrException ex = new GdrException("The home was not set. The installation cannot proceed without a valid home directory being provided.");
            _log.throwing(InstallationSession.class.getName(), "validateInstallation", ex);
            throw ex;
        }
    }

    @Override
    public Set<InstallType> getInstallTypes() {
        LinkedHashSet<InstallType> installTypes = new LinkedHashSet<InstallType>();
        installTypes.add(new InstallTypeImpl(DistributionHelper.getInstance().createDefaultInstallType()));
        return installTypes;
    }

    @Override
    public InstallType getDefaultInstallType() {
        return new InstallTypeImpl(DistributionHelper.getInstance().createDefaultInstallType());
    }

    @Override
    public InstallType getInstallType() {
        return this._installType;
    }

    @Override
    public void setInstallType(InstallType installType) throws DependencyException, GdrException {
        this._installType = installType;
    }

    @Override
    public Set<FeatureSet> getCurrentlySelectedFeatures() {
        return new LinkedHashSet<FeatureSet>();
    }

    @Override
    public Map<ExternalFeatureReference, List<Reference>> getExternalDistributions() {
        if (this._externalDistributions == null && this._installerInfo != null) {
            List<ExternalFeatureReference> extftrs;
            this._externalDistributions = new HashMap<ExternalFeatureReference, List<Reference>>();
            ExternalDeps extDeps = this._installerInfo.getExternalDeps();
            if (extDeps != null && (extftrs = extDeps.getFeatures()) != null && !extftrs.isEmpty()) {
                for (ExternalFeatureReference extftr : extftrs) {
                    List<Reference> refs = extftr.getDistributions();
                    this._externalDistributions.put(extftr, refs);
                }
            }
        }
        return this._externalDistributions;
    }

    @Override
    public long getFeatureSize(Reference featureRef) {
        long size = 0L;
        InstallerInfo installerInfo = this.getInstallerInfo();
        if (installerInfo != null) {
            return InstallerInfoHelper.getInstance().getInstallerFeatureSize(this.getInstallerDistributionInfo(), featureRef.getName(), featureRef.getVersion());
        }
        return size;
    }

    public InstallerDistributionInfo getInstallerDistributionInfo() {
        return InstallerInfoHelper.getInstance().getInstallerDistributionInfo(this.getInstallerInfo(), this.getDistributionLoader().getDistributionName(), this.getDistributionLoader().getDistributionVersion());
    }

    @Override
    public long getTotalInstallationSize() {
        Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> selectedFeatures = this.getSelectedFeatures();
        Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> installedFeatures = this.getHome().getInstalledFeatures();
        if (installedFeatures != null && !installedFeatures.isEmpty()) {
            selectedFeatures.addAll(installedFeatures);
        }
        long totalSize = 0L;
        for (com.oracle.cie.gdr.dao.ftr.FeatureSet feature : selectedFeatures) {
            long size = this.getFeatureSize(InstallerConfig.createReference(feature.getName(), feature.getVersion()));
            totalSize += size;
        }
        return totalSize;
    }

    protected void setInstallationStates(Map<com.oracle.cie.gdr.dao.ftr.FeatureSet, Collection<Component>> componentsMap) throws GdrException {
        this.setInstallationStates(null, componentsMap);
    }

    protected void setInstallationStates(Distribution distribution, Map<com.oracle.cie.gdr.dao.ftr.FeatureSet, Collection<Component>> componentsMap) throws GdrException {
        if (componentsMap != null && !componentsMap.isEmpty()) {
            String version;
            Home home = this.getHome();
            DeInstallInfo deInstallInfo = null;
            Collection<DistributionTarget> installedDistributions = home != null ? home.getInstalledDistributions() : null;
            HashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet> allInstalledFeatures = home != null ? home.getInstalledFeatures() : new HashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet>();
            LinkedHashSet<Component> singletonFeatureSetComponents = new LinkedHashSet<Component>();
            for (com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet : componentsMap.keySet()) {
                featureSet.setSuperseded(null);
                featureSet.setReplaces(null);
                featureSet.setInitialRefCount(0);
                featureSet.setReplacesDependencies(null);
                featureSet.setSupersedingDependencies(null);
            }
            LinkedHashMap incrementedReplacesDependenciesMap = new LinkedHashMap();
            HashMap removedDependenciesMap = new HashMap();
            HashMap<DistributionTarget, HashSet<String>> allDependencyNames = new HashMap<DistributionTarget, HashSet<String>>();
            for (com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet : componentsMap.keySet()) {
                if (installedDistributions == null || installedDistributions.isEmpty()) continue;
                for (DistributionTarget distributionTarget : installedDistributions) {
                    Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> installedFeatures = distributionTarget.getInstalledFeatureSets();
                    for (com.oracle.cie.gdr.dao.ftr.FeatureSet installedFeature : installedFeatures) {
                        if (!featureSet.getName().equals(installedFeature.getName())) continue;
                        if (featureSet.isUpgradeInstalled()) {
                            featureSet.setSingleton(true);
                        }
                        if (!featureSet.isSingleton() && !installedFeature.isSingleton()) continue;
                        Iterator<ComponentReference> components = componentsMap.get(featureSet);
                        singletonFeatureSetComponents.addAll((Collection<Component>)((Object)components));
                        Version version2 = new Version(featureSet.getVersion());
                        Version installedVersion = new Version(installedFeature.getVersion());
                        int versionCompare = version2.compareTo(installedVersion);
                        if (versionCompare < 0) {
                            String currentSupersedingVersion = featureSet.getSupersededVersion();
                            if (!StringUtil.isNullOrEmpty((String)currentSupersedingVersion, (boolean)true) && installedVersion.compareTo(new Version(currentSupersedingVersion)) >= 0) continue;
                            featureSet.setSuperseded(installedFeature);
                            Iterator iterator = components.iterator();
                            while (iterator.hasNext()) {
                                Component component = (Component)iterator.next();
                                component.setOmitted(true);
                            }
                            continue;
                        }
                        if (versionCompare > 0) {
                            featureSet.addReplaces(installedFeature);
                            featureSet.setInitialRefCount(0);
                            Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> replacesDependencies = FeatureSetHelper.getInstance(home.getClassLoader()).getResolvedFeatureSetDependenciesFiltered(featureSet, this.getFeatureSelectionTarget().getFeatures(), this.getFeatureSelectionTarget().getInstalledFeatures(), null);
                            replacesDependencies.remove(featureSet);
                            if (!replacesDependencies.isEmpty()) {
                                LinkedHashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet> incrementedReplacesDependencies = (LinkedHashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet>)incrementedReplacesDependenciesMap.get(distributionTarget);
                                if (incrementedReplacesDependencies == null) {
                                    incrementedReplacesDependencies = new LinkedHashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet>();
                                    incrementedReplacesDependenciesMap.put(distributionTarget, incrementedReplacesDependencies);
                                }
                                for (com.oracle.cie.gdr.dao.ftr.FeatureSet replacesDependency : replacesDependencies) {
                                    if (incrementedReplacesDependencies.contains(replacesDependency)) continue;
                                    if (allInstalledFeatures.contains(replacesDependency)) {
                                        Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> installedFeatureDeps = FeatureSetHelper.getInstance(home.getClassLoader()).getResolvedFeatureSetDependenciesFiltered(installedFeature, allInstalledFeatures, null, null);
                                        if (installedFeatureDeps.contains(replacesDependency)) continue;
                                        replacesDependency.incrementInitialRefCount();
                                        incrementedReplacesDependencies.add(replacesDependency);
                                        continue;
                                    }
                                    if (replacesDependency.hasReplaces()) continue;
                                    replacesDependency.incrementInitialRefCount();
                                    incrementedReplacesDependencies.add(replacesDependency);
                                }
                                featureSet.setReplacesDependencies(replacesDependencies);
                            }
                            try {
                                com.oracle.cie.gdr.dao.rgy.DistributionInfo distributionInfo = home.getRegistryHelper().getDistributionInfo(home.getRegistry(), distributionTarget.getDistributionName(), distributionTarget.getDistributionVersion());
                                FeatureInfo finfo = home.getRegistryHelper().getFeatureInfo(distributionInfo.getFeatures(), installedFeature.getName(), installedFeature.getVersion());
                                if (finfo != null && !finfo.isDynamic()) {
                                    List<com.oracle.cie.gdr.dao.ftr.FeatureSet> previousDependencies = FeatureSetHelper.getInstance(home.getClassLoader()).getResolvedFeatureDependencies(allInstalledFeatures, installedFeature);
                                    previousDependencies.remove(installedFeature);
                                    List<com.oracle.cie.gdr.dao.ftr.FeatureSet> newDependencies = FeatureSetHelper.getInstance(home.getClassLoader()).getResolvedFeatureDependencies(this.getFeatureSelectionTarget().getFeatures(), featureSet);
                                    newDependencies.remove(featureSet);
                                    for (com.oracle.cie.gdr.dao.ftr.FeatureSet newDependency : newDependencies) {
                                        HashSet<String> dependencyNames = (HashSet<String>)allDependencyNames.get(distributionTarget);
                                        if (dependencyNames == null) {
                                            dependencyNames = new HashSet<String>();
                                            allDependencyNames.put(distributionTarget, dependencyNames);
                                        }
                                        dependencyNames.add(newDependency.getName());
                                    }
                                    for (com.oracle.cie.gdr.dao.ftr.FeatureSet previousDependency : previousDependencies) {
                                        HashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet> removedDependencies;
                                        boolean found = false;
                                        for (com.oracle.cie.gdr.dao.ftr.FeatureSet newDependency : newDependencies) {
                                            if (!newDependency.getName().equals(previousDependency.getName())) continue;
                                            found = true;
                                            break;
                                        }
                                        if (found) continue;
                                        HashMap<DistributionTarget, HashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet>> removedDependenciesDist = (HashMap<DistributionTarget, HashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet>>)removedDependenciesMap.get(featureSet);
                                        if (removedDependenciesDist == null) {
                                            removedDependenciesDist = new HashMap<DistributionTarget, HashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet>>();
                                            removedDependenciesMap.put(featureSet, removedDependenciesDist);
                                        }
                                        if ((removedDependencies = (HashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet>)removedDependenciesDist.get(distributionTarget)) == null) {
                                            removedDependencies = new HashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet>();
                                            removedDependenciesDist.put(distributionTarget, removedDependencies);
                                        }
                                        removedDependencies.add(previousDependency);
                                    }
                                }
                            }
                            catch (DependencyException e) {
                                throw new GdrException("Failed to calculate dependencies for superseded featureset " + installedFeature, (Throwable)e);
                            }
                            Set<ComponentReference> installedComponents = distributionTarget.getInstalledComponents(installedFeature);
                            for (ComponentReference installedComponent : installedComponents) {
                                boolean found = false;
                                Iterator<Object> iterator = components.iterator();
                                while (iterator.hasNext()) {
                                    Component component = (Component)iterator.next();
                                    if (!component.getName().equals(installedComponent.getName())) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                try {
                                    Path deInstallInfoFile;
                                    DirectoryMap directoryMap = distributionTarget.getDirectoryMap();
                                    if (deInstallInfo == null && Files.exists(deInstallInfoFile = DeInstallInfoHelper.getInstance(home.getClassLoader()).getDeInstallInfoFilePath(home.getInventoryDirectoryPath()), new LinkOption[0])) {
                                        deInstallInfo = DeInstallInfoHelper.getInstance(home.getClassLoader()).getDeInstallInfo(deInstallInfoFile);
                                    }
                                    Component removedComponent = FeatureSetHelper.getInstance(home.getClassLoader()).getDeInstallerComponent(installedComponent, directoryMap, this.getServiceHolder(), deInstallInfo, home.getMetaDataHome());
                                    featureSet.addRemovedComponent(removedComponent);
                                }
                                catch (Exception e) {
                                    throw new GdrException("Failed to load removed feature set component's de-install information " + (Object)((Object)installedComponent), (Throwable)e);
                                }
                            }
                            continue;
                        }
                        if (!installedFeature.isUpgrades()) continue;
                        featureSet.setUpgradesInHome(installedFeature.getUpgrades());
                    }
                }
            }
            for (Map.Entry entry : removedDependenciesMap.entrySet()) {
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    DistributionReference distRef = null;
                    for (com.oracle.cie.gdr.dao.ftr.FeatureSet removedDependency : (Set)entry2.getValue()) {
                        if (((Set)allDependencyNames.get(entry2.getKey())).contains(removedDependency.getName())) continue;
                        if (distRef == null) {
                            distRef = new DistributionReference(((DistributionTarget)entry2.getKey()).getDistributionName(), ((DistributionTarget)entry2.getKey()).getDistributionVersion());
                        }
                        ((com.oracle.cie.gdr.dao.ftr.FeatureSet)entry.getKey()).addRemovedDependency(distRef, removedDependency);
                    }
                }
            }
            for (com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet : componentsMap.keySet()) {
                if (!featureSet.isSuperseded()) continue;
                com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet2 = featureSet.getSuperseded();
                Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> set = FeatureSetHelper.getInstance(home.getClassLoader()).getResolvedFeatureSetDependenciesFiltered(featureSet2, home.getInstalledFeatures(), null, componentsMap.keySet());
                set.remove(featureSet2);
                HashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet> remove = new HashSet<com.oracle.cie.gdr.dao.ftr.FeatureSet>();
                block21: for (com.oracle.cie.gdr.dao.ftr.FeatureSet supersedingDep : set) {
                    for (com.oracle.cie.gdr.dao.ftr.FeatureSet fs : componentsMap.keySet()) {
                        if ((!fs.isSuperseded() || !fs.getSuperseded().equals(supersedingDep)) && (!fs.hasReplaces() || !fs.getReplaces().contains(supersedingDep))) continue;
                        remove.add(supersedingDep);
                        continue block21;
                    }
                }
                if (!remove.isEmpty()) {
                    set.removeAll(remove);
                }
                featureSet.setSupersedingDependencies(set);
            }
            Set<ComponentReference> installedComponents = home != null ? home.getInstalledComponents() : null;
            for (Collection<Component> collection : componentsMap.values()) {
                block24: for (Component component : collection) {
                    component.setSuperseded(null);
                    component.setReplaces(null);
                    if (installedComponents == null || installedComponents.isEmpty()) continue;
                    String name = component.getName();
                    boolean singleton = component.isSingleton() || singletonFeatureSetComponents.contains(component);
                    for (ComponentReference installedComponent : installedComponents) {
                        Version installedVersion;
                        if (!name.equals(installedComponent.getName())) continue;
                        version = new Version(component.getVersion());
                        int versionCompare = version.compareTo(installedVersion = new Version(installedComponent.getVersion()));
                        if (versionCompare == 0) {
                            String patchLevel = component.getPatchLevel();
                            String installedPatchLevel = installedComponent.getPatchLevel();
                            if (StringUtil.isNullOrEmpty((String)patchLevel)) {
                                patchLevel = "0";
                            }
                            if (StringUtil.isNullOrEmpty((String)installedPatchLevel)) {
                                installedPatchLevel = "0";
                            }
                            version = new Version(patchLevel);
                            installedVersion = new Version(installedPatchLevel);
                            versionCompare = version.compareTo(installedVersion);
                        }
                        if (!singleton && installedComponent.isSingleton()) {
                            singleton = true;
                        }
                        if (singleton) {
                            if (versionCompare < 0) {
                                String currentSupersedingVersion = component.getSupersededVersion();
                                if (!StringUtil.isNullOrEmpty((String)currentSupersedingVersion, (boolean)true) && installedVersion.compareTo(new Version(currentSupersedingVersion)) >= 0) continue;
                                component.setSuperseded(installedComponent);
                                component.setOmitted(false);
                                continue;
                            }
                            if (versionCompare <= 0) continue;
                            try {
                                Path deInstallInfoFile;
                                DirectoryMap directoryMap;
                                Collection<DistributionTarget> dists = home.getInstalledDistributions(installedComponent);
                                DirectoryMap directoryMap2 = directoryMap = dists != null && !dists.isEmpty() ? dists.iterator().next().getDirectoryMap() : this.getDirectoryMap();
                                if (deInstallInfo == null && Files.exists(deInstallInfoFile = DeInstallInfoHelper.getInstance(home.getClassLoader()).getDeInstallInfoFilePath(home.getInventoryDirectoryPath()), new LinkOption[0])) {
                                    deInstallInfo = DeInstallInfoHelper.getInstance(home.getClassLoader()).getDeInstallInfo(deInstallInfoFile);
                                }
                                Component replacedComponent = FeatureSetHelper.getInstance(home.getClassLoader()).getDeInstallerComponent(installedComponent, directoryMap, this.getServiceHolder(), deInstallInfo, home.getMetaDataHome());
                                component.addReplaces(replacedComponent);
                                component.setOmitted(false);
                                continue;
                            }
                            catch (Exception e) {
                                throw new GdrException("Failed to load replaced component's de-install information " + (Object)((Object)installedComponent), (Throwable)e);
                            }
                        }
                        if (versionCompare != 0) continue;
                        continue block24;
                    }
                }
            }
            if (distribution != null) {
                DistributionTarget distributionTarget = home != null ? home.getInstalledDistribution(distribution.getName(), distribution.getVersion()) : null;
                Set<ComponentReference> set = distributionTarget != null ? distributionTarget.getInstalledComponents() : null;
                for (Collection<Component> components : componentsMap.values()) {
                    for (Component component : components) {
                        if (!component.isSuperseded()) {
                            component.setFullyInstalled(false);
                            ComponentReference componentReference = null;
                            if (set != null) {
                                String name = component.getName();
                                version = component.getVersion();
                                String patchLevel = component.getPatchLevel();
                                for (ComponentReference ref : set) {
                                    if (!name.equals(ref.getName()) || !version.equals(ref.getVersion()) || (!StringUtil.isNullOrEmpty((String)patchLevel, (boolean)true) || !StringUtil.isNullOrEmpty((String)ref.getPatchLevel(), (boolean)true)) && (patchLevel == null || !patchLevel.equals(ref.getPatchLevel()))) continue;
                                    componentReference = ref;
                                    break;
                                }
                            }
                            if (componentReference == null) continue;
                            boolean targetNotInstalled = false;
                            Collection<ComponentTarget> componentTargets = component.getComponentTargets();
                            for (ComponentTarget componentTarget : componentTargets) {
                                Status status = componentReference.getComponentTargetStatus(componentTarget.getReferenceQualifier());
                                if (status != null && status.isInstalled()) continue;
                                targetNotInstalled = true;
                            }
                            component.setFullyInstalled(!targetNotInstalled);
                            continue;
                        }
                        component.setFullyInstalled(true);
                    }
                }
            }
            Set<com.oracle.cie.gdr.dao.ftr.FeatureSet> set = home != null ? home.getInstalledFeatures() : null;
            for (com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet : componentsMap.keySet()) {
                if (!featureSet.isSuperseded()) {
                    if (set != null && set.contains(featureSet)) {
                        Collection<Component> components;
                        components = componentsMap.get(featureSet);
                        boolean featureFullyInstalled = true;
                        for (Component component : components) {
                            if (component.isFullyInstalled()) continue;
                            featureFullyInstalled = false;
                            break;
                        }
                        featureSet.setFullyInstalled(featureFullyInstalled);
                        continue;
                    }
                    featureSet.setFullyInstalled(false);
                    continue;
                }
                featureSet.setFullyInstalled(true);
            }
        }
    }

    public void reload() throws GdrException {
        this.setHome(this.getHome());
    }
}

