/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.LibraryEntry;
import com.oracle.cie.gdr.dao.cpd.Selection;
import com.oracle.cie.gdr.dao.ftr.FeatureLibrary;
import com.oracle.cie.gdr.dao.ftr.FeatureLibraryInclude;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.installation.InstallerWrapper;
import com.oracle.cie.gdr.libraries.JarLibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryEntryLocation;
import com.oracle.cie.gdr.libraries.LibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.libraries.LibraryKey;
import com.oracle.cie.gdr.libraries.LibraryLocation;
import com.oracle.cie.gdr.libraries.LibraryProcessorManager;
import com.oracle.cie.gdr.libraries.LibraryTarget;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.libraries.LibraryVersion;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class DefaultLibraryHandler
implements LibraryHandler {
    private static final Logger _log = Logger.getLogger(DefaultLibraryHandler.class.getName());
    private Home _home;
    private InstallerWrapper _installerWrapper;
    private Mode mode;

    @Override
    public abstract LibraryType getLibraryType();

    public abstract String getEntryLocationPrefix();

    public abstract boolean isSupportedLibraryType(LibraryType var1);

    protected abstract void processComponentLibrary(LibraryKey var1, LibraryTarget var2, Set<LibraryEntryLocation> var3, String var4) throws LibraryHandlerException;

    protected abstract void processFeatureLibrary(LibraryKey var1, LibraryTargetHolder var2, Set<LibraryEntryLocation> var3, String var4) throws LibraryHandlerException;

    public abstract List<String> getAbsoluteComponentJarPaths(LibraryKey var1, LibraryTarget var2) throws LibraryHandlerException;

    public abstract List<String> getAbsoluteFeaturesetJarPaths(LibraryKey var1, LibraryTargetHolder var2) throws LibraryHandlerException;

    @Override
    public void handle(LibraryTargetHolder holder) throws GdrException {
        if (holder == null) {
            LibraryHandlerException ex = new LibraryHandlerException("The library target holder provided was null.");
            _log.throwing(this.getClass().getName(), "handle", (Throwable)((Object)ex));
            throw ex;
        }
        this.handleComponents(holder);
        this.handleFeaturesets(holder);
    }

    private void handleComponents(LibraryTargetHolder holder) throws GdrException, LibraryHandlerException {
        for (LibraryKey key : holder.getLibraryKeys()) {
            List<LibraryTarget> targets = holder.getLibraryTargets(key);
            if (targets == null || targets.isEmpty() || key.getType().isNone()) continue;
            for (LibraryTarget target : targets) {
                if (!this.isSupportedLibraryType(key.getType()) || key.getVisibility().isNone()) continue;
                Set<LibraryEntryLocation> entryLocations = target.getEntryLocations(this.mode);
                if (RegenerationHelper.isRegenerateState() && (target.getType().equals((Object)LibraryType.manifest) || !this.containsModifiedFile(entryLocations)) && !target.needsRegeneration()) continue;
                this.getAbsoluteComponentJarPaths(key, target);
                if (this.isThreadable()) {
                    LibraryProcessorManager.addComponentLibrary(this.getHome(), this.getInstallerWrapper(), this.mode, this.getLibraryType(), key, target, entryLocations, target.getProductHome(this.mode));
                } else {
                    LibraryProcessorManager.removeLibraryFromPool(this.getAbsoluteComponentJarPaths(key, target));
                    this.processComponentLibrary(key, target, entryLocations, target.getProductHome(this.mode));
                }
                if (!this.containsModifiedFile(entryLocations) && !target.needsRegeneration()) continue;
                RegenerationHelper.getInstance().addPomComponentToRegenerate(target.getComponent());
            }
        }
    }

    private void handleFeaturesets(LibraryTargetHolder holder) throws GdrException, LibraryHandlerException {
        for (LibraryKey key : holder.getFeatureLibraryKeys()) {
            if (!this.isSupportedLibraryType(key.getType())) continue;
            Set<LibraryEntryLocation> entryLocations = this.getFeatureLibraryEntryLocations(holder, key);
            FeatureLibrary library = holder.getFeatureLibrary(key);
            String productHome = holder.getProductHome(library, this.mode);
            if (RegenerationHelper.isRegenerateState() && (!this.containsModifiedFile(entryLocations) || key.getType().equals((Object)LibraryType.manifest)) && !holder.needsRegeneration()) continue;
            this.getAbsoluteFeaturesetJarPaths(key, holder);
            if (this.isThreadable()) {
                LibraryProcessorManager.addFeatureSetLibrary(this.getHome(), this.getInstallerWrapper(), this.mode, this.getLibraryType(), key, holder, entryLocations, productHome);
            } else {
                LibraryProcessorManager.removeLibraryFromPool(this.getAbsoluteFeaturesetJarPaths(key, holder));
                this.processFeatureLibrary(key, holder, entryLocations, productHome);
            }
            if ((!this.containsModifiedFile(entryLocations) || key.getType().equals((Object)LibraryType.manifest)) && !holder.needsRegeneration()) continue;
            try {
                RegenerationHelper.getInstance().addPomFeatureSetToRegenerate(holder.getFeature());
            }
            catch (DataHandlerException | IOException e) {
                throw new GdrException(e);
            }
        }
    }

    public Set<LibraryEntryLocation> getFeatureLibraryEntryLocations(LibraryTargetHolder holder, LibraryKey key) throws GdrException {
        LinkedHashSet<LibraryEntryLocation> entryLocations = new LinkedHashSet<LibraryEntryLocation>();
        FeatureLibrary library = holder.getFeatureLibrary(key);
        List<FeatureLibraryInclude> includes = library.getIncludes();
        for (FeatureLibraryInclude include : includes) {
            LibraryVersion version = this.getIncludeVersion(include, key.getType(), holder);
            HashMap<FeatureLibraryInclude, Set<FeatureLibraryInclude>> cycleCheck = new HashMap<FeatureLibraryInclude, Set<FeatureLibraryInclude>>();
            HashMap<FeatureLibraryInclude, Set<LibraryTargetHolder>> globalCycleCheck = new HashMap<FeatureLibraryInclude, Set<LibraryTargetHolder>>();
            try {
                this.getLibraryTargetEntryLocations(key.getType(), include, version, holder, entryLocations, cycleCheck, globalCycleCheck);
            }
            catch (Exception e) {
                GdrException e2 = new GdrException("A failure occurred while processing the include \"" + include.getName() + "\" defined in the \"" + (Object)((Object)library) + "\" library from the \"" + holder.getFeature().toString(false) + "\" feature set.", (Throwable)e);
                _log.throwing(this.getClass().getName(), "getFeatureLibraryEntryLocations", e2);
                throw e2;
            }
        }
        return entryLocations;
    }

    protected void getLibraryTargetEntryLocations(LibraryType type, FeatureLibraryInclude include, LibraryVersion version, LibraryTargetHolder holder, Set<LibraryEntryLocation> entryLocations, Map<FeatureLibraryInclude, Set<FeatureLibraryInclude>> cycleCheck, Map<FeatureLibraryInclude, Set<LibraryTargetHolder>> globalCycleCheck) throws GdrException {
        LinkedList<LibraryLocation> stack = new LinkedList<LibraryLocation>();
        LibraryLocation libLoc = new LibraryLocation(type, include, version, holder, entryLocations, cycleCheck, globalCycleCheck);
        stack.push(libLoc);
        while (!stack.isEmpty()) {
            LibraryHandlerException ex;
            libLoc = (LibraryLocation)stack.pop();
            if (libLoc.getType() == null || libLoc.getName() == null || libLoc.getVersion() == null) continue;
            if (!libLoc.isFeature()) {
                Collection<LibraryKey> compKeys = libLoc.getLibraryKeys(libLoc.getName());
                if (compKeys != null && !compKeys.isEmpty()) {
                    for (LibraryKey libraryKey : compKeys) {
                        if (!DefaultLibraryHandler.isValidVersion(libraryKey.getLibraryVersion(), libLoc.getVersion(), libraryKey.getIgnoreVersion(), libLoc.getIgnoreVersion(), libLoc.isSingleton())) continue;
                        if (DefaultLibraryHandler.isValidExplodeType(libraryKey.getType(), libLoc.getType(), libLoc.getExplode())) {
                            for (LibraryTarget target : libLoc.getLibraryTargets(libraryKey)) {
                                libLoc.getEntryLocations().addAll(target.getEntryLocations(this.mode));
                            }
                            continue;
                        }
                        if (DefaultLibraryHandler.isValidUnexplodeType(libraryKey.getType(), libLoc.getType(), libraryKey.getIgnoreType(), libLoc.getIgnoreType(), libLoc.getExplode(), !libraryKey.getVisibility().isNone())) {
                            for (LibraryTarget target : libLoc.getLibraryTargets(libraryKey)) {
                                String filePath = this.getAbsoluteComponentJarPaths(libraryKey, target).get(0);
                                String productHome = target.getProductHome(this.mode);
                                String relativePath = FileUtils.formatPath(filePath.replaceFirst((this._home.toString() + File.separator).replaceAll("\\\\", "\\\\\\\\"), ""), "/");
                                String stagePath = FileUtils.formatPath(this._home.toString() + File.separator + productHome + File.separator + relativePath, "/");
                                LibraryEntry entry = new LibraryEntry();
                                entry.setName(relativePath);
                                entry.setExplode(false);
                                entry.setIncludeParent(false);
                                LibraryEntryLocation entryLocation = new LibraryEntryLocation(entry, target, relativePath, stagePath, productHome, libLoc.getHolder().getHome());
                                libLoc.getEntryLocations().add(entryLocation);
                            }
                            continue;
                        }
                        if (libLoc.getExplode() || !libraryKey.getVisibility().isNone()) continue;
                        GdrException e = new GdrException("The library include \"" + libLoc.getName() + "\" is not supported with the explode value of false defined because the included library is not visible.");
                        _log.throwing(this.getClass().getName(), "getLibraryTargetEntryLocations", e);
                        throw e;
                    }
                }
            } else {
                Collection<LibraryKey> featureKeys = libLoc.getFeatureLibraryKeys(libLoc.getName());
                if (featureKeys != null && !featureKeys.isEmpty()) {
                    for (LibraryKey libraryKey : featureKeys) {
                        if (!DefaultLibraryHandler.isValidVersion(libraryKey.getLibraryVersion(), libLoc.getVersion(), libraryKey.getIgnoreVersion(), libLoc.getInclude().getIgnoreVersion(), libLoc.isSingleton())) continue;
                        FeatureLibrary target = libLoc.getFeatureLibrary(libraryKey);
                        if (DefaultLibraryHandler.isValidExplodeType(libraryKey.getType(), libLoc.getType(), libLoc.getExplode())) {
                            LinkedList<LibraryLocation> orderStack = new LinkedList<LibraryLocation>();
                            for (FeatureLibraryInclude newInclude : target.getIncludes()) {
                                this.updateCycleCheck(libLoc.getCycleCheck(), libLoc.getInclude(), newInclude, libLoc.getHolder());
                                LibraryVersion newVersion = this.getIncludeVersion(newInclude, libLoc.getType(), libLoc.getHolder());
                                LibraryLocation libLocation = new LibraryLocation(libLoc.getType(), newInclude, newVersion, libLoc.getHolder(), libLoc.getEntryLocations(), libLoc.getCycleCheck(), libLoc.getGlobalCycleCheck());
                                orderStack.push(libLocation);
                            }
                            while (!orderStack.isEmpty()) {
                                stack.push((LibraryLocation)orderStack.pop());
                            }
                            continue;
                        }
                        if (DefaultLibraryHandler.isValidUnexplodeType(libraryKey.getType(), libLoc.getType(), libraryKey.getIgnoreType(), libLoc.getIgnoreType(), libLoc.getExplode(), !libraryKey.getVisibility().isNone())) {
                            try {
                                String filePath = null;
                                if (libLoc.getType().equals((Object)libraryKey.getType())) {
                                    filePath = this.getAbsoluteFeaturesetJarPaths(libraryKey, libLoc.getHolder()).get(0);
                                } else {
                                    LibraryHandler libHandler = libraryKey.getType().getHandler();
                                    ((JarLibraryHandler)libHandler).setHome(this.getHome());
                                    ((JarLibraryHandler)libHandler).setInstallerWrapper(this.getInstallerWrapper());
                                    filePath = ((JarLibraryHandler)libHandler).getAbsoluteFeaturesetJarPaths(libraryKey, libLoc.getHolder()).get(0);
                                }
                                String productHome = libLoc.getProductHome(target, this.mode);
                                String relativePath = FileUtils.formatPath(filePath.replaceFirst((this._home.toString() + File.separator).replaceAll("\\\\", "\\\\\\\\"), ""), "/");
                                String stagePath = FileUtils.formatPath(this._home.toString() + File.separator + productHome + File.separator + relativePath, "/");
                                LibraryEntry entry = new LibraryEntry();
                                entry.setName(relativePath);
                                entry.setExplode(false);
                                entry.setIncludeParent(false);
                                LibraryEntryLocation entryLocation = new LibraryEntryLocation(entry, null, relativePath, stagePath, productHome, libLoc.getHolder().getHome());
                                libLoc.addEntryLocation(entryLocation);
                                continue;
                            }
                            catch (Exception e) {
                                throw new LibraryHandlerException(e);
                            }
                        }
                        if (libLoc.getExplode() || !libraryKey.getVisibility().isNone()) continue;
                        GdrException e = new GdrException("The library include \"" + libLoc.getName() + "\" is not supported with the explode value of false defined because the included library is not visible.");
                        _log.throwing(this.getClass().getName(), "getLibraryTargetEntryLocations", e);
                        throw e;
                    }
                }
            }
            if (!libLoc.isGlobal()) {
                Set<LibraryTargetHolder> childDeps = libLoc.getDependencies();
                if (childDeps == null || childDeps.isEmpty()) continue;
                LinkedList<LibraryLocation> orderStack = new LinkedList<LibraryLocation>();
                for (LibraryTargetHolder childDep : childDeps) {
                    LibraryLocation libLocation = new LibraryLocation(libLoc.getType(), libLoc.getInclude(), libLoc.getVersion(), childDep, libLoc.getEntryLocations(), libLoc.getCycleCheck(), libLoc.getGlobalCycleCheck());
                    orderStack.push(libLocation);
                }
                while (!orderStack.isEmpty()) {
                    stack.push((LibraryLocation)orderStack.pop());
                }
                continue;
            }
            try {
                InstallerWrapper installerWrapper = this.getInstallerWrapper();
                Map<FeatureSet, LibraryTargetHolder> globalTargets = installerWrapper != null ? installerWrapper.getLibraryTargets() : null;
                if (globalTargets == null || globalTargets.isEmpty()) continue;
                Set<LibraryTargetHolder> set = libLoc.getGlobalCycleCheck().get((Object)libLoc.getInclude());
                LinkedList<LibraryLocation> orderStack = new LinkedList<LibraryLocation>();
                for (LibraryTargetHolder globalHolder : globalTargets.values()) {
                    if (set != null && set.contains(globalHolder)) continue;
                    libLoc.addToGlobalCycleCheck(set, globalHolder);
                    LibraryLocation libLocation = new LibraryLocation(libLoc.getType(), libLoc.getInclude(), libLoc.getVersion(), globalHolder, libLoc.getEntryLocations(), libLoc.getCycleCheck(), libLoc.GlobalCycleCheck());
                    orderStack.push(libLocation);
                }
                while (!orderStack.isEmpty()) {
                    stack.push((LibraryLocation)orderStack.pop());
                }
            }
            catch (DependencyException e) {
                ex = new LibraryHandlerException(e);
                _log.throwing(this.getClass().getName(), "getGlobalLibraryTargetEntryLocations", (Throwable)((Object)ex));
                throw ex;
            }
            catch (IOException e) {
                ex = new LibraryHandlerException(e);
                _log.throwing(this.getClass().getName(), "getGlobalLibraryTargetEntryLocations", (Throwable)((Object)ex));
                throw ex;
            }
            catch (DataHandlerException e) {
                ex = new LibraryHandlerException(e);
                _log.throwing(this.getClass().getName(), "getGlobalLibraryTargetEntryLocations", (Throwable)((Object)ex));
                throw ex;
            }
        }
    }

    private static boolean isValidExplodeType(LibraryType keyType, LibraryType includeType, boolean explode) {
        return explode && (keyType.equals((Object)includeType) || keyType.isNone());
    }

    private static boolean isValidUnexplodeType(LibraryType keyType, LibraryType includeType, boolean ignoreInclude, boolean ignoreLibrary, boolean explode, boolean targetVisible) {
        return targetVisible && (!explode && keyType.equals((Object)includeType) || includeType.equals((Object)LibraryType.manifest) && (ignoreInclude || ignoreLibrary));
    }

    public static boolean isValidVersion(LibraryVersion keyVersion, LibraryVersion includeVersion, boolean ignoreInclude, boolean ignoreLibrary, boolean isSingleton) {
        return keyVersion.equals(includeVersion) || ignoreInclude || ignoreLibrary || isSingleton;
    }

    private void updateCycleCheck(Map<FeatureLibraryInclude, Set<FeatureLibraryInclude>> cycleCheck, FeatureLibraryInclude include, FeatureLibraryInclude newInclude, LibraryTargetHolder holder) throws GdrException {
        if (newInclude.isFeature().booleanValue()) {
            if (include.equals((Object)newInclude)) {
                LibraryHandlerException e = new LibraryHandlerException("There's a cyclic include in FeatureSet " + holder.getFeature());
                _log.throwing(this.getClass().getName(), "updateCycleCheck", (Throwable)((Object)e));
                throw e;
            }
            if (!cycleCheck.containsKey((Object)include)) {
                HashSet<FeatureLibraryInclude> deps = new HashSet<FeatureLibraryInclude>();
                deps.add(newInclude);
                cycleCheck.put(include, deps);
            } else {
                cycleCheck.get((Object)include).add(newInclude);
            }
            for (Map.Entry<FeatureLibraryInclude, Set<FeatureLibraryInclude>> mapEntry : cycleCheck.entrySet()) {
                if (!mapEntry.getValue().contains((Object)include)) continue;
                if (mapEntry.getKey().equals((Object)newInclude)) {
                    GdrException e = new GdrException("There's a cyclic include in FeatureSet " + holder.getFeature());
                    _log.throwing(this.getClass().getName(), "updateCycleCheck", e);
                    throw e;
                }
                cycleCheck.get((Object)mapEntry.getKey()).add(newInclude);
            }
        }
    }

    protected LibraryVersion getIncludeVersion(FeatureLibraryInclude include, LibraryType type, LibraryTargetHolder holder) {
        LibraryVersion version = new LibraryVersion();
        if (StringUtil.isNullOrEmpty((String)include.getVersion(), (boolean)true)) {
            for (LibraryKey key : holder.getFeatureLibraryKeys()) {
                LibraryVersion defaultVersion = key.getLibraryVersion();
                if (defaultVersion.compareTo(version) < 0 || !key.getType().equals((Object)type) && !type.equals((Object)LibraryType.none)) continue;
                version = defaultVersion;
            }
        } else {
            version = new LibraryVersion(include.getVersion());
        }
        return version;
    }

    public Home getHome() {
        return this._home;
    }

    public void setHome(Home home) {
        this._home = home;
    }

    public InstallerWrapper getInstallerWrapper() {
        return this._installerWrapper;
    }

    public void setInstallerWrapper(InstallerWrapper installerWrapper) {
        this._installerWrapper = installerWrapper;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    protected boolean containsModifiedFile(Set<LibraryEntryLocation> entryLocations) throws GdrException {
        if (RegenerationHelper.isRegenerateState() && entryLocations != null && entryLocations.size() > 0) {
            if (RegenerationHelper.getInstance().needToRegenerateAllFiles()) {
                return true;
            }
            for (LibraryEntryLocation entryLocation : entryLocations) {
                Path entryLocationPath = NioHelper.getInstance().getPath(entryLocation.getFullPath(), new String[0]);
                if (!RegenerationHelper.getInstance().getModifiedFiles().containsKey(entryLocationPath)) continue;
                Set<String> jarEntries = RegenerationHelper.getInstance().getModifiedFiles().get(entryLocationPath);
                if (!jarEntries.isEmpty() && !entryLocation.getIncludes().isEmpty()) {
                    for (Selection include : entryLocation.getIncludes()) {
                        if (!jarEntries.contains(include.getName())) continue;
                        return true;
                    }
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    public static Path getEntryLocationFile(LibraryEntryLocation entryLocation, Home home, Mode mode) {
        if (mode.isInstallMode() || mode.isDeInstallMode()) {
            return home.getHomePath().resolve(entryLocation.getFullPath());
        }
        return NioHelper.getInstance().getPath(entryLocation.getStagePath(), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanLibraryDirectory(Path libFile) throws LibraryHandlerException {
        Path path = libFile;
        synchronized (path) {
            try {
                Files.createDirectories(libFile.getParent(), new FileAttribute[0]);
                if (!Files.exists(libFile.getParent(), new LinkOption[0]) && !Files.exists(libFile.getParent(), new LinkOption[0])) {
                    throw new LibraryHandlerException("Failed to create parent directory " + libFile.getParent());
                }
                if (Files.exists(libFile, new LinkOption[0])) {
                    Files.delete(libFile);
                    if (Files.exists(libFile, new LinkOption[0])) {
                        throw new LibraryHandlerException("Failed to delete existing Jar: " + libFile.toAbsolutePath());
                    }
                }
            }
            catch (IOException e) {
                throw new LibraryHandlerException("Failed to clean library directory: " + libFile.toAbsolutePath());
            }
        }
    }

    public boolean isThreadable() {
        return false;
    }
}

