/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.cpd.LibraryEntry;
import com.oracle.cie.gdr.dao.cpd.Selection;
import com.oracle.cie.gdr.libraries.LibraryTarget;
import java.util.List;

public class LibraryEntryLocation {
    private LibraryEntry _entry;
    private LibraryTarget _libraryTarget;
    private String _path;
    private String _stagePath;
    private String _productHome;
    private Home _home;

    public LibraryEntryLocation(LibraryEntry entry, LibraryTarget libraryTarget, String path, String stagePath, String productHome, Home home) {
        this._entry = entry;
        this._libraryTarget = libraryTarget;
        this._path = path;
        this._stagePath = stagePath;
        this._productHome = productHome;
        this._home = home;
    }

    public LibraryEntry getEntry() {
        return this._entry;
    }

    public LibraryTarget getLibraryTarget() {
        return this._libraryTarget;
    }

    public String getPath() {
        return this._path;
    }

    public String getProductHome() {
        return this._productHome;
    }

    public String getFullPath() {
        return this.getProductHome() + "/" + this.getPath();
    }

    public String getStagePath() {
        return this._stagePath;
    }

    public List<Selection> getIncludes() {
        return this._entry.getIncludes();
    }

    public List<Selection> getExcludes() {
        return this._entry.getExcludes();
    }

    public String toString() {
        return this.getFullPath();
    }

    public Home getHome() {
        return this._home;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LibraryEntryLocation other = (LibraryEntryLocation)obj;
        if (this._entry == null ? other._entry != null : !this._entry.equals((Object)other._entry)) {
            return false;
        }
        if (this._path == null ? other._path != null : !this._path.equals(other._path)) {
            return false;
        }
        return !(this._productHome == null ? other._productHome != null : !this._productHome.equals(other._productHome));
    }

    public int hashCode() {
        LibraryEntry entry = this.getEntry();
        String path = this.getPath();
        String productHome = this.getProductHome();
        int hash = 17;
        hash = 23 * hash + (entry != null ? entry.hashCode() : 0);
        hash = 23 * hash + (path != null ? path.hashCode() : 0);
        hash = 23 * hash + (productHome != null ? productHome.hashCode() : 0);
        return hash;
    }
}

