/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.installation.DefaultInstallerWrapper;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.installation.InstallerWrapper;
import com.oracle.cie.gdr.libraries.JarLibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.utils.GdrException;

public class LibraryProcessor {
    public static void process(LibraryTargetHolder holder, Home home, Installer installer, Mode mode) throws GdrException {
        LibraryProcessor.process(holder, home, new DefaultInstallerWrapper(installer), mode);
    }

    public static void process(LibraryTargetHolder holder, Home home, InstallerWrapper installerWrapper, Mode mode) throws GdrException {
        for (LibraryType type : LibraryType.values()) {
            if (type.isNone() || !holder.hasLibraryTypes(type) || RegenerationHelper.isRegenerateState() && !RegenerationHelper.getInstance().regenerateType(type)) continue;
            LibraryProcessor.process(type, holder, home, installerWrapper, mode);
        }
    }

    public static void process(LibraryType type, LibraryTargetHolder holder, Home home, InstallerWrapper installerWrapper, Mode mode) throws GdrException {
        try {
            LibraryHandler libHandler = type.getHandler();
            ((JarLibraryHandler)libHandler).setHome(home);
            ((JarLibraryHandler)libHandler).setInstallerWrapper(installerWrapper);
            ((JarLibraryHandler)libHandler).setMode(mode);
            libHandler.handle(holder);
        }
        catch (Exception e) {
            throw new LibraryHandlerException(e);
        }
    }
}

