/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.installation.InstallerWrapper;
import com.oracle.cie.gdr.libraries.JarLibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryEntryLocation;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.libraries.LibraryKey;
import com.oracle.cie.gdr.libraries.LibraryProcessorTask;
import com.oracle.cie.gdr.libraries.LibraryTarget;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.libraries.LibraryType;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;

public class LibraryProcessorManager {
    private static final Logger _log = Logger.getLogger(LibraryProcessorManager.class.getName());
    private static final Vector<LibraryProcessorTask> libTask = new Vector();
    private static ExecutorService executor;
    private static ArrayList<LibraryHandlerException> errors;
    private static Observer myObserver;
    private static Integer loopCounter;
    private static Vector<String> libraryLoopCheck;
    private static boolean breakFutureLoop;

    public static void processLibraries() throws LibraryHandlerException {
        if (libTask == null || libTask.isEmpty()) {
            return;
        }
        executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
        errors = new ArrayList();
        try {
            LibraryProcessorManager.removeDuplicatedJarLocations();
        }
        catch (LibraryHandlerException e) {
            libTask.clear();
            throw e;
        }
        try {
            while (!libTask.isEmpty()) {
                LibraryProcessorManager.processLibraryCycle();
            }
        }
        catch (InterruptedException e) {
            throw new LibraryHandlerException(e);
        }
        catch (ExecutionException e) {
            throw new LibraryHandlerException(e);
        }
        finally {
            executor.shutdownNow();
            libTask.clear();
            if (errors.size() > 0) {
                throw errors.get(0);
            }
            breakFutureLoop = true;
        }
    }

    private static void processLibraryCycle() throws InterruptedException, ExecutionException {
        ArrayList list = new ArrayList();
        while (!libTask.isEmpty()) {
            LibraryProcessorTask task = libTask.iterator().next();
            if (task == null) continue;
            list.add(executor.submit(task));
            libTask.remove(task);
        }
        breakFutureLoop = false;
        for (Future future : list) {
            future.get();
            if (!breakFutureLoop) continue;
            break;
        }
    }

    private static void removeDuplicatedJarLocations() throws LibraryHandlerException {
        ArrayList<String> allLibs = new ArrayList<String>();
        ArrayList<LibraryProcessorTask> removeList = new ArrayList<LibraryProcessorTask>();
        for (int i = libTask.size() - 1; i >= 0; --i) {
            LibraryProcessorTask task = libTask.get(i);
            List<String> taskLocs = task.getLibrariesLocations();
            ArrayList<Integer> removeLoc = new ArrayList<Integer>();
            for (String loc : taskLocs) {
                if (allLibs.contains(loc)) {
                    _log.warning("Library overlapping " + loc);
                    removeLoc.add(taskLocs.indexOf(loc));
                    continue;
                }
                allLibs.add(loc);
            }
            if (removeLoc.size() == taskLocs.size()) {
                removeList.add(task);
                continue;
            }
            task.removeLoc(removeLoc);
        }
        libTask.removeAll(removeList);
    }

    public static void setObserver(Observer o) {
        if (o != null) {
            myObserver = o;
        }
    }

    public static Observer getObserver() {
        return myObserver;
    }

    public static void stopAll(LibraryHandlerException myExeption) {
        errors.add(myExeption);
        executor.shutdownNow();
        breakFutureLoop = true;
    }

    public static void addComponentLibrary(Home home, InstallerWrapper installerWrapper, Mode mode, LibraryType libType, LibraryKey key, LibraryTarget target, Set<LibraryEntryLocation> entryLocations, String location) throws LibraryHandlerException {
        try {
            JarLibraryHandler myLib = (JarLibraryHandler)libType.getHandler();
            myLib.setHome(home);
            myLib.setInstallerWrapper(installerWrapper);
            myLib.setMode(mode);
            libTask.add(new LibraryProcessorTask(myLib, key, target, entryLocations, location));
        }
        catch (LibraryHandlerException e) {
            throw new LibraryHandlerException((Throwable)((Object)e));
        }
        catch (ClassNotFoundException e) {
            throw new LibraryHandlerException(e);
        }
        catch (NoSuchMethodException e) {
            throw new LibraryHandlerException(e);
        }
        catch (InvocationTargetException e) {
            throw new LibraryHandlerException(e);
        }
        catch (IllegalAccessException e) {
            throw new LibraryHandlerException(e);
        }
        catch (InstantiationException e) {
            throw new LibraryHandlerException(e);
        }
    }

    public static void addFeatureSetLibrary(Home home, InstallerWrapper installerWrapper, Mode mode, LibraryType libType, LibraryKey key, LibraryTargetHolder targetHolder, Set<LibraryEntryLocation> entryLocations, String location) throws LibraryHandlerException {
        try {
            JarLibraryHandler myLib = (JarLibraryHandler)libType.getHandler();
            myLib.setHome(home);
            myLib.setInstallerWrapper(installerWrapper);
            myLib.setMode(mode);
            libTask.add(new LibraryProcessorTask(myLib, key, targetHolder, entryLocations, location));
        }
        catch (LibraryHandlerException e) {
            throw new LibraryHandlerException((Throwable)((Object)e));
        }
        catch (ClassNotFoundException e) {
            throw new LibraryHandlerException(e);
        }
        catch (NoSuchMethodException e) {
            throw new LibraryHandlerException(e);
        }
        catch (InvocationTargetException e) {
            throw new LibraryHandlerException(e);
        }
        catch (IllegalAccessException e) {
            throw new LibraryHandlerException(e);
        }
        catch (InstantiationException e) {
            throw new LibraryHandlerException(e);
        }
    }

    public static void removeLibraryFromPool(List<String> newAbsoluteLocations) throws LibraryHandlerException {
        if (newAbsoluteLocations == null || newAbsoluteLocations.isEmpty()) {
            return;
        }
        ArrayList<LibraryProcessorTask> removeList = new ArrayList<LibraryProcessorTask>();
        for (LibraryProcessorTask task : libTask) {
            ArrayList<Integer> removeLoc = new ArrayList<Integer>();
            List<String> taskLocs = task.getLibrariesLocations();
            for (String loc : taskLocs) {
                if (!newAbsoluteLocations.contains(loc)) continue;
                _log.warning("Library overlapping " + loc);
                removeLoc.add(taskLocs.indexOf(loc));
            }
            if (removeLoc.size() == taskLocs.size()) {
                removeList.add(task);
                continue;
            }
            task.removeLoc(removeLoc);
        }
        libTask.removeAll(removeList);
    }

    public static Collection<LibraryKey> getKeys() {
        ArrayList<LibraryKey> arr = new ArrayList<LibraryKey>();
        for (LibraryProcessorTask task : libTask) {
            if (task == null) continue;
            arr.add(task.getKey());
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLibraryToLoop(String library, Throwable exception) throws LibraryHandlerException {
        Integer n = loopCounter;
        synchronized (n) {
            if (libraryLoopCheck.contains(library)) {
                Integer n2 = loopCounter;
                Integer n3 = loopCounter = Integer.valueOf(loopCounter + 1);
                if (loopCounter > libraryLoopCheck.size()) {
                    throw new LibraryHandlerException("Cyclic dependency detected among featureset libraries: " + libraryLoopCheck, exception);
                }
            } else {
                libraryLoopCheck.add(library);
                loopCounter = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLibraryFromLoop(String library) {
        Integer n = loopCounter;
        synchronized (n) {
            libraryLoopCheck.remove(library);
            loopCounter = 0;
        }
    }

    static {
        loopCounter = new Integer(0);
        libraryLoopCheck = new Vector();
    }
}

