/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.common.util.StringUtil;

public class LibraryVersion
implements Comparable<LibraryVersion> {
    private String versionString = "";
    private int[] versionComponents = new int[0];

    public LibraryVersion() {
    }

    public LibraryVersion(String version) {
        this();
        if (!StringUtil.isNullOrEmpty((String)version)) {
            this.versionString = version;
            if (version.contains("\\.")) {
                String[] splittedVersion = version.split("\\.");
                this.versionComponents = new int[splittedVersion.length];
                for (int i = 0; i < splittedVersion.length; ++i) {
                    this.versionComponents[i] = Integer.parseInt(splittedVersion[i]);
                }
            }
        }
    }

    @Override
    public int compareTo(LibraryVersion o) {
        int limit = o.versionComponents.length <= this.versionComponents.length ? o.versionComponents.length : this.versionComponents.length;
        for (int i = 0; i < limit; ++i) {
            if (o.versionComponents[i] > this.versionComponents[i]) {
                return -1;
            }
            if (o.versionComponents[i] >= this.versionComponents[i]) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryVersion libraryVersion = (LibraryVersion)o;
        if (libraryVersion.versionString.equals(this.versionString)) {
            return true;
        }
        return libraryVersion.versionComponents.length > 0 && this.versionComponents.length > 0 && this.compareTo(libraryVersion) == 0;
    }

    public int hashCode() {
        int hash = this.versionString.hashCode();
        if (this.versionComponents.length >= 3) {
            for (int i = 0; i < 3; ++i) {
                hash = 31 * hash + this.versionComponents[i];
            }
        }
        return hash;
    }

    public String toString() {
        return this.versionString;
    }
}

