/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.merger;

import com.oracle.cie.gdr.merger.EntryDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntryDescriptorCollection {
    private Map<String, EntryDescriptor> entries = new HashMap<String, EntryDescriptor>();
    private Map<String, List<EntryDescriptor>> conflictingEntries = new HashMap<String, List<EntryDescriptor>>();
    private final int _bufferSize = 100000;

    public boolean contains(String name) {
        return this.entries.containsKey(name);
    }

    public boolean containsConflict(String name) {
        return this.conflictingEntries.containsKey(name);
    }

    public void add(EntryDescriptor entry) throws IOException {
        if (this.containsConflict(entry.getEntry().getName())) {
            List<EntryDescriptor> conflictList = this.conflictingEntries.get(entry.getEntry().getName());
            conflictList.add(entry);
        } else if (this.contains(entry.getEntry().getName())) {
            if (!this.equalEntries(this.entries.get(entry.getEntry().getName()), entry)) {
                EntryDescriptor temp = this.entries.get(entry.getEntry().getName());
                this.entries.remove(entry.getEntry().getName());
                ArrayList<EntryDescriptor> newConflict = new ArrayList<EntryDescriptor>();
                newConflict.add(temp);
                newConflict.add(entry);
                this.conflictingEntries.put(entry.getEntry().getName(), newConflict);
            }
        } else {
            this.entries.put(entry.getEntry().getName(), entry);
        }
    }

    private boolean equalEntries(EntryDescriptor entry1, EntryDescriptor entry2) throws IOException {
        if (entry1.getEntry().getCrc() != -1L && entry2.getEntry().getCrc() != -1L) {
            return entry1.getEntry().getCrc() == entry2.getEntry().getCrc();
        }
        InputStream is1 = entry1.getLibraryJar().getJar().getJar().getInputStream(entry1.getEntry());
        InputStream is2 = entry2.getLibraryJar().getJar().getJar().getInputStream(entry2.getEntry());
        ReadableByteChannel ch1 = Channels.newChannel(is1);
        ReadableByteChannel ch2 = Channels.newChannel(is2);
        ByteBuffer buf1 = ByteBuffer.allocateDirect(100000);
        ByteBuffer buf2 = ByteBuffer.allocateDirect(100000);
        try {
            while (true) {
                int n1 = ch1.read(buf1);
                int n2 = ch2.read(buf2);
                if (n1 == -1 || n2 == -1) {
                    boolean bl = n1 == n2;
                    return bl;
                }
                buf1.flip();
                buf2.flip();
                if (buf1.compareTo(buf2) != 0) {
                    boolean bl = false;
                    return bl;
                }
                buf1.clear();
                buf2.clear();
            }
        }
        finally {
            if (is1 != null) {
                is1.close();
            }
            if (is2 != null) {
                is2.close();
            }
        }
    }

    public Collection<EntryDescriptor> getEntries() {
        return this.entries.values();
    }

    public Collection<List<EntryDescriptor>> getConflicts() {
        return this.conflictingEntries.values();
    }

    public List<EntryDescriptor> getConflict() {
        return this.conflictingEntries.values().iterator().next();
    }

    public void removeConflict(String entry) {
        this.conflictingEntries.remove(entry);
    }
}

