/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.orchestration.action.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.nio.NioCopy;
import com.oracle.cie.gdr.nio.NioFixCRLF;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.orchestration.InstallActionFactory;
import com.oracle.cie.gdr.orchestration.InstallActionHelper;
import com.oracle.cie.gdr.orchestration.InstallActionResult;
import com.oracle.cie.gdr.orchestration.InstallActionTarget;
import com.oracle.cie.gdr.orchestration.action.impl.CommonInstallAction;
import com.oracle.cie.gdr.orchestration.impl.InstallActionResultImpl;
import com.oracle.cie.gdr.orchestration.lifecycle.InstallPhase;
import com.oracle.cie.gdr.pack200.Pack200Engine;
import com.oracle.cie.gdr.utils.ACLPermissionUtil;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.POSIXPermissionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;

public class ComponentInstallAction
extends CommonInstallAction {
    private static final Logger _log = Logger.getLogger(ComponentInstallAction.class.getName());
    private static final int MODE_STANDARD_LENGTH = 3;
    private boolean _windows = PlatformInfoHelper.getInstance().isInWindowsGroup(PlatformInfoHelper.getInstance().getCurrentPlatformId());
    private List<String> _principals = Collections.singletonList(System.getProperty("user.name"));

    public ComponentInstallAction(InstallActionTarget target) {
        super(target);
    }

    @Override
    public String getName() {
        return "component-install";
    }

    @Override
    public String getDisplayName() {
        return "Component Install";
    }

    @Override
    public Set<InstallPhase> getInstallPhases(Mode mode) {
        return this.getInstallPhaseSet(InstallPhase.PROCESS);
    }

    @Override
    public Set<Mode> getInstallActionModes() {
        return Collections.singleton(Mode.INSTALL);
    }

    @Override
    public InstallActionResult execute() {
        InstallActionResultImpl result = null;
        try {
            Set<Component> components;
            Installer installer = this.getTarget().getInstaller();
            Set<FeatureSet> selectedFeatures = installer.getSelectedFeatures();
            LinkedHashSet<Component> replacedComponents = new LinkedHashSet<Component>();
            for (FeatureSet feature : selectedFeatures) {
                if (feature.hasRemovedComponents()) {
                    replacedComponents.addAll(feature.getRemovedComponents());
                }
                if ((components = installer.getComponents(feature)) == null || components.isEmpty()) continue;
                for (Component c : components) {
                    if (!c.hasReplaces()) continue;
                    replacedComponents.addAll(c.getReplaces());
                }
            }
            if (!replacedComponents.isEmpty()) {
                for (Component replacedComponent : replacedComponents) {
                    InstallActionHelper.deInstallComponent(replacedComponent, null, this.getTarget().getHomePath(), true);
                }
            }
            for (FeatureSet feature : selectedFeatures) {
                if (installer.startFeatureInstall(feature)) {
                    components = installer.getComponents(feature);
                    this.installComponents(components, installer);
                }
                installer.completeFeatureInstall(feature);
            }
        }
        catch (Exception e) {
            result = InstallActionFactory.getFailureResult(this, "File installation failed.", e);
        }
        return result == null ? InstallActionFactory.getSuccessResult(this) : result;
    }

    protected void installComponents(Collection<Component> components, Installer installer) throws GdrException, IOException {
        if (components != null && !components.isEmpty()) {
            for (Component c : components) {
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Starting installation of component: " + c);
                }
                if (installer == null || installer.startComponentInstall(c)) {
                    for (ComponentTarget target : c.getComponentTargets()) {
                        if (installer == null || installer.startComponentTargetInstall(target)) {
                            this.installComponentFiles(c, target);
                        }
                        if (installer == null) continue;
                        installer.completeComponentTargetInstall(target);
                    }
                }
                if (installer != null) {
                    installer.completeComponentInstall(c);
                }
                if (!_log.isLoggable(Level.FINER)) continue;
                _log.finer("Completed installation of component: " + c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installComponentFiles(Component component, ComponentTarget target) throws IOException, GdrException {
        HashMap<String, Collection<FileTarget>> sourceToTargetsMap = new HashMap<String, Collection<FileTarget>>();
        ArrayList<FileTarget> symlinks = new ArrayList<FileTarget>();
        List<FileTarget> files = target.getFileTargets();
        if (files != null) {
            for (FileTarget fileTarget : files) {
                if (!fileTarget.isSymlink()) {
                    ArrayList<FileTarget> targets = (ArrayList<FileTarget>)sourceToTargetsMap.get(fileTarget.getSource());
                    if (targets == null) {
                        targets = new ArrayList<FileTarget>();
                        sourceToTargetsMap.put(fileTarget.getSource(), targets);
                    }
                    targets.add(fileTarget);
                    continue;
                }
                symlinks.add(fileTarget);
            }
        }
        if (component.isUnstaged()) {
            FileSystem fileSystem = NioHelper.getInstance().getFileSystem(component.getCompDefLocationPath());
            if (fileSystem == null) {
                fileSystem = FileSystems.getDefault();
            }
            this.extractContent(sourceToTargetsMap, fileSystem);
        } else {
            FileSystem carbFileSystem = null;
            FileSystem extractFileSystem = null;
            ZipInputStream jarInputStream = null;
            try {
                if (component.isCarb()) {
                    Path componentArchivePath = component.getArchiveLocationPath();
                    carbFileSystem = FileSystems.newFileSystem(componentArchivePath, null);
                    String entryPath = ComponentHelper.getInstance().getComponentArchiveCarbPath(component.getName(), component.getVersion());
                    Path dataFilesDir = carbFileSystem.getPath(entryPath, "DataFilesExtracted");
                    if (Files.exists(dataFilesDir, new LinkOption[0])) {
                        Path archivePath = dataFilesDir.resolve(target.getSource());
                        if (Files.exists(archivePath, new LinkOption[0])) {
                            extractFileSystem = carbFileSystem;
                        } else if (component.hasComponentExtensions()) {
                            for (Component extension : component.getComponentExtensions()) {
                                componentArchivePath = extension.getArchiveLocationPath();
                                carbFileSystem = FileSystems.newFileSystem(componentArchivePath, null);
                                dataFilesDir = carbFileSystem.getPath(entryPath, "DataFilesExtracted");
                                archivePath = dataFilesDir.resolve(target.getSource());
                                if (!Files.exists(archivePath, new LinkOption[0])) continue;
                                extractFileSystem = carbFileSystem;
                                break;
                            }
                        }
                        if (extractFileSystem == null) {
                            throw new GdrException("Unable to locate file-group source jar \"" + archivePath + "\" for component " + component);
                        }
                        if (_log.isLoggable(Level.FINER)) {
                            _log.finer("Extracting " + archivePath + " from flattened carb " + componentArchivePath);
                        }
                    } else {
                        dataFilesDir = carbFileSystem.getPath(entryPath, "DataFiles");
                        if (!Files.exists(dataFilesDir, new LinkOption[0])) {
                            throw new GdrException("The carb did not contain a DataFiles directory.");
                        }
                        Path fileGroupJar = dataFilesDir.resolve(target.getSource());
                        if (Files.exists(fileGroupJar, new LinkOption[0])) {
                            jarInputStream = new JarInputStream(Files.newInputStream(fileGroupJar, new OpenOption[0]));
                        } else if (component.hasComponentExtensions()) {
                            for (Component extension : component.getComponentExtensions()) {
                                componentArchivePath = extension.getArchiveLocationPath();
                                carbFileSystem = FileSystems.newFileSystem(componentArchivePath, null);
                                dataFilesDir = carbFileSystem.getPath(entryPath, "DataFiles");
                                fileGroupJar = dataFilesDir.resolve(target.getSource());
                                if (!Files.exists(fileGroupJar, new LinkOption[0])) continue;
                                jarInputStream = new JarInputStream(Files.newInputStream(fileGroupJar, new OpenOption[0]));
                                break;
                            }
                        }
                        if (jarInputStream == null) {
                            throw new GdrException("Unable to locate file-group source jar \"" + fileGroupJar + "\" for component " + component);
                        }
                        jarInputStream = new JarInputStream(Files.newInputStream(fileGroupJar, new OpenOption[0]));
                        if (_log.isLoggable(Level.FINER)) {
                            _log.finer("Extracting " + fileGroupJar + " from " + componentArchivePath);
                        }
                    }
                } else {
                    Path componentArchivePath = target.getSourceFilePath();
                    extractFileSystem = FileSystems.newFileSystem(NioHelper.getInstance().getInternalPath(componentArchivePath), null);
                    if (_log.isLoggable(Level.FINER)) {
                        _log.finer("Extracting " + target.getSourceFilePath() + " from " + componentArchivePath);
                    }
                }
                if (jarInputStream != null) {
                    this.extractContent(sourceToTargetsMap, (JarInputStream)jarInputStream);
                } else {
                    this.extractContent(sourceToTargetsMap, extractFileSystem);
                }
            }
            finally {
                if (jarInputStream != null) {
                    try {
                        jarInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (extractFileSystem != null) {
                    try {
                        extractFileSystem.close();
                    }
                    catch (IOException iOException) {}
                }
                if (carbFileSystem != null) {
                    try {
                        carbFileSystem.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.createSymLinks(symlinks);
    }

    protected void extractContent(Map<String, Collection<FileTarget>> sourceToTargetsMap, FileSystem extractFileSystem) throws IOException, GdrException {
        Path homePath = this.getTarget().getHomePath();
        if (sourceToTargetsMap != null && !sourceToTargetsMap.isEmpty()) {
            Map<Path, Collection<FileTarget>> dirPathToTargets = this.createDirectories(sourceToTargetsMap, homePath);
            for (Map.Entry<String, Collection<FileTarget>> entry : sourceToTargetsMap.entrySet()) {
                Path sourcePath = extractFileSystem.getPath(entry.getKey(), new String[0]);
                Iterator<FileTarget> it = entry.getValue().iterator();
                FileTarget fileTarget = it.next();
                Path destPath = homePath.resolve(fileTarget.getDest());
                this.createParentDir(destPath);
                if (fileTarget.isCopyAsZeroByte()) {
                    if (!Files.exists(destPath, new LinkOption[0])) {
                        Files.createFile(destPath, new FileAttribute[0]);
                    }
                } else if (fileTarget.isPacked()) {
                    Path packedDestPath = homePath.resolve(fileTarget.getDest() + ".pack.gz");
                    NioCopy.copyFile((Path)sourcePath, (Path)packedDestPath, this.getFileCopyOptions(fileTarget));
                    Pack200Engine.getInstance().unpack(packedDestPath.toFile(), destPath.toFile());
                    long sizeDelta = Files.size(destPath) - Files.size(packedDestPath);
                    if (sizeDelta < Integer.MIN_VALUE || sizeDelta > Integer.MAX_VALUE) {
                        _log.severe("Size delta value was smaller or larger than the valid integer limits");
                        throw new GdrException("Size delta value was smaller or larger than the valid integer limits");
                    }
                    Files.delete(packedDestPath);
                } else {
                    NioCopy.copyFile((Path)sourcePath, (Path)destPath, this.getFileCopyOptions(fileTarget));
                }
                if (fileTarget.isCopyAsText()) {
                    new NioFixCRLF().processFile(destPath.toAbsolutePath().toString());
                }
                this.changePermissions(destPath, fileTarget.getMode());
                while (it.hasNext()) {
                    fileTarget = it.next();
                    Path dupPath = homePath.resolve(fileTarget.getDest());
                    if (dupPath.equals(destPath)) continue;
                    NioCopy.copyFile((Path)destPath, (Path)dupPath, this.getFileCopyOptions(fileTarget));
                    this.changePermissions(dupPath, fileTarget.getMode());
                }
            }
            for (Map.Entry<Object, Collection<FileTarget>> entry : dirPathToTargets.entrySet()) {
                this.changePermissions((Path)entry.getKey(), this.getStrongestMode(entry.getValue()));
            }
        }
    }

    protected void extractContent(Map<String, Collection<FileTarget>> sourceToTargetsMap, JarInputStream jarInputStream) throws IOException, GdrException {
        Path homePath = this.getTarget().getHomePath();
        if (sourceToTargetsMap != null && !sourceToTargetsMap.isEmpty()) {
            Map<Path, Collection<FileTarget>> dirPathToTargets = this.createDirectories(sourceToTargetsMap, homePath);
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null) {
                Collection<FileTarget> fileTargets = sourceToTargetsMap.get(jarEntry.getName());
                if (fileTargets != null) {
                    Iterator<FileTarget> it = fileTargets.iterator();
                    FileTarget fileTarget = it.next();
                    Path destPath = homePath.resolve(fileTarget.getDest());
                    this.createParentDir(destPath);
                    if (fileTarget.isPacked()) {
                        Path packedDestPath = homePath.resolve(fileTarget.getDest() + ".pack.gz");
                        NioCopy.copyFile((InputStream)jarInputStream, (Path)packedDestPath, this.getInputStreamCopyOptions(fileTarget));
                        Pack200Engine.getInstance().unpack(packedDestPath.toFile(), destPath.toFile());
                        long sizeDelta = Files.size(destPath) - Files.size(packedDestPath);
                        if (sizeDelta < Integer.MIN_VALUE || sizeDelta > Integer.MAX_VALUE) {
                            _log.severe("Size delta value was smaller or larger than the valid integer limits");
                            throw new GdrException("Size delta value was smaller or larger than the valid integer limits");
                        }
                        Files.delete(packedDestPath);
                    } else {
                        NioCopy.copyFile((InputStream)jarInputStream, (Path)destPath, this.getInputStreamCopyOptions(fileTarget));
                    }
                    if (fileTarget.isCopyAsText()) {
                        new NioFixCRLF().processFile(destPath.toAbsolutePath().toString());
                    }
                    this.changePermissions(destPath, fileTarget.getMode());
                    while (it.hasNext()) {
                        fileTarget = it.next();
                        Path dupPath = homePath.resolve(fileTarget.getDest());
                        if (dupPath.equals(destPath)) continue;
                        NioCopy.copyFile((Path)destPath, (Path)dupPath, this.getFileCopyOptions(fileTarget));
                        this.changePermissions(dupPath, fileTarget.getMode());
                    }
                }
                jarEntry = jarInputStream.getNextJarEntry();
            }
            for (Map.Entry<Path, Collection<FileTarget>> entry : dirPathToTargets.entrySet()) {
                this.changePermissions(entry.getKey(), this.getStrongestMode(entry.getValue()));
            }
        }
    }

    protected Map<Path, Collection<FileTarget>> createDirectories(Map<String, Collection<FileTarget>> sourceToTargetsMap, Path homePath) throws IOException {
        Collection<FileTarget> dirTargets;
        HashMap<Path, Collection<FileTarget>> dirPathToTargets = new HashMap<Path, Collection<FileTarget>>();
        if (sourceToTargetsMap != null && !sourceToTargetsMap.isEmpty() && (dirTargets = sourceToTargetsMap.remove("/")) != null) {
            for (FileTarget ft : dirTargets) {
                if (ft.isDirectory()) {
                    Path destPath = homePath.resolve(ft.getDest());
                    Files.createDirectories(destPath, new FileAttribute[0]);
                    ArrayList<FileTarget> fileTargets = (ArrayList<FileTarget>)dirPathToTargets.get(destPath);
                    if (fileTargets == null) {
                        fileTargets = new ArrayList<FileTarget>();
                        dirPathToTargets.put(destPath, fileTargets);
                    }
                    fileTargets.add(ft);
                    continue;
                }
                dirTargets.remove(ft);
            }
        }
        return dirPathToTargets;
    }

    protected void createSymLinks(Collection<FileTarget> symlinks) throws IOException {
        if (symlinks != null) {
            Path homePath = this.getTarget().getHomePath();
            for (FileTarget fileTarget : symlinks) {
                Path sourcePath = homePath.resolve(fileTarget.getSource());
                Path destPath = homePath.resolve(fileTarget.getDest());
                this.createParentDir(destPath);
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Creating symbolic link " + destPath + " from " + sourcePath);
                }
                Files.createSymbolicLink(destPath, destPath, new FileAttribute[0]);
            }
        }
    }

    protected void createParentDir(Path path) throws IOException {
        Path parentPath;
        if (path != null && !Files.exists(parentPath = path.getParent(), new LinkOption[0])) {
            Files.createDirectories(parentPath, new FileAttribute[0]);
        }
    }

    protected String getStrongestMode(Collection<FileTarget> fileTargets) {
        String mode = null;
        if (fileTargets != null) {
            for (FileTarget ft : fileTargets) {
                String fileTargetMode = ft.getMode();
                if (StringUtil.isNullOrEmpty((String)fileTargetMode, (boolean)true)) continue;
                if (mode == null) {
                    mode = fileTargetMode;
                    continue;
                }
                int modeInt = -1;
                try {
                    modeInt = Integer.parseInt(mode);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                int ftModeInt = -1;
                try {
                    ftModeInt = Integer.parseInt(fileTargetMode);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (ftModeInt >= modeInt) continue;
                mode = fileTargetMode;
            }
        }
        return mode;
    }

    protected void changePermissions(Path path, String mode) {
        if (path != null) {
            boolean setPerm;
            if (StringUtil.isNullOrEmpty((String)mode)) {
                mode = Files.isDirectory(path, new LinkOption[0]) ? "750" : "640";
            }
            if (!this._windows) {
                if (mode.length() > 3) {
                    mode = mode.substring(0, 3);
                }
                setPerm = POSIXPermissionUtil.setPermissions(path, mode);
            } else {
                setPerm = !Files.isDirectory(path, new LinkOption[0]) ? ACLPermissionUtil.setPermissions(path, this._principals) : true;
            }
            if (_log.isLoggable(Level.FINEST)) {
                if (setPerm) {
                    _log.finest("Success changing file permissions for file: " + path);
                } else {
                    _log.finest("Failure changing file permissions for file: " + path);
                }
            }
        }
    }

    private List<CopyOption> getFileCopyOptions(FileTarget fileTarget) {
        List copyOptions = NioCopy.getFileCopyOptions((boolean)true, (boolean)false, (boolean)true);
        this.addChecksumCopyOption(fileTarget, copyOptions);
        return copyOptions;
    }

    private List<CopyOption> getInputStreamCopyOptions(FileTarget fileTarget) {
        List copyOptions = NioCopy.getInputStreamCopyOptions((boolean)true);
        this.addChecksumCopyOption(fileTarget, copyOptions);
        return copyOptions;
    }

    private void addChecksumCopyOption(FileTarget fileTarget, List<CopyOption> copyOptions) {
        CopyOption checksumCopyOption;
        String checksum;
        if (fileTarget != null && copyOptions != null && !StringUtil.isNullOrEmpty((String)(checksum = fileTarget.getChecksum()), (boolean)true) && (checksumCopyOption = NioHelper.getInstance().getChecksumCopyOption(checksum)) != null) {
            copyOptions.add(checksumCopyOption);
        }
    }
}

