/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.orchestration.action.impl;

import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.installation.DefaultInstallerWrapper;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.libraries.LibraryProcessorManager;
import com.oracle.cie.gdr.maven.PomProcessor;
import com.oracle.cie.gdr.orchestration.InstallActionFactory;
import com.oracle.cie.gdr.orchestration.InstallActionResult;
import com.oracle.cie.gdr.orchestration.InstallActionTarget;
import com.oracle.cie.gdr.orchestration.action.impl.CommonInstallAction;
import com.oracle.cie.gdr.orchestration.lifecycle.InstallPhase;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LibraryGenerationInstallAction
extends CommonInstallAction {
    private static final Logger _log = Logger.getLogger(LibraryGenerationInstallAction.class.getName());

    public LibraryGenerationInstallAction(InstallActionTarget target) {
        super(target);
    }

    @Override
    public String getName() {
        return "library-generation";
    }

    @Override
    public String getDisplayName() {
        return "Library Generation";
    }

    @Override
    public Set<Mode> getInstallActionModes() {
        return this.getModeSet(Mode.INSTALL);
    }

    @Override
    public Set<InstallPhase> getInstallPhases(Mode mode) {
        return this.getInstallPhaseSet(InstallPhase.POST_PROCESS);
    }

    @Override
    public InstallActionResult execute() {
        Installer installer = this.getTarget().getInstaller();
        LinkedHashSet<FeatureSet> affectedSingletonFeatures = new LinkedHashSet<FeatureSet>();
        LinkedHashSet<Component> affectedSingletonComponents = new LinkedHashSet<Component>();
        try {
            boolean distPomGen;
            Set<FeatureSet> features = installer.getPostProcessFeatures();
            for (FeatureSet feature : features) {
                try {
                    installer.processPostFeatureOperation(feature);
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Failure occurred while post processing feature set " + feature, e);
                }
            }
            LibraryProcessorManager.processLibraries();
            if (!affectedSingletonFeatures.isEmpty()) {
                RegenerationHelper.getInstance().addModifiedFeatureSets(affectedSingletonFeatures);
            }
            for (Component comp : installer.getComponents()) {
                if (!comp.hasReplaces()) continue;
                affectedSingletonComponents.add(comp);
            }
            if (!affectedSingletonComponents.isEmpty()) {
                RegenerationHelper.getInstance().addModifiedComponents(affectedSingletonComponents);
            }
            if (distPomGen = installer.getDistribution().hasPomGen()) {
                PomProcessor.processPendingPOMs(new DefaultInstallerWrapper(installer), Mode.INSTALL);
            } else {
                _log.info("POM generation post processing disabled at a distribution level.");
            }
        }
        catch (Exception e) {
            return InstallActionFactory.getFailureResult(this, "Failure occurred during post featureset processing.", e);
        }
        return InstallActionFactory.getSuccessResult(this);
    }
}

