/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.orchestration.impl;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.gdr.orchestration.InstallActionException;
import com.oracle.cie.gdr.orchestration.InstallActionExecutor;
import com.oracle.cie.gdr.orchestration.InstallActionManager;
import com.oracle.cie.gdr.orchestration.InstallActionResult;
import com.oracle.cie.gdr.orchestration.ProgressInfo;
import com.oracle.cie.gdr.orchestration.action.InstallAction;
import com.oracle.cie.gdr.orchestration.impl.InstallActionRunnerImpl;
import com.oracle.cie.gdr.orchestration.impl.InstallActionTargetImpl;
import com.oracle.cie.gdr.orchestration.lifecycle.InstallPhase;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallActionExecutorImpl
implements InstallActionExecutor {
    private static final Logger _log = Logger.getLogger(InstallActionExecutorImpl.class.getName());
    private InstallActionManager _installActionManager;

    public InstallActionExecutorImpl(InstallActionManager installActionManager) {
        this._installActionManager = installActionManager;
    }

    public InstallActionManager getInstallActionManager() {
        return this._installActionManager;
    }

    @Override
    public void execute() throws InstallActionException {
        Map<InstallPhase, List<InstallAction>> actions = this.getInstallActionManager().getInstallActions();
        InstallActionTargetImpl installActionTarget = (InstallActionTargetImpl)this.getInstallActionManager().getInstallActionTarget();
        for (InstallPhase installPhase : InstallPhase.values()) {
            installActionTarget.setCurrentInstallPhase(installPhase);
            List<InstallAction> installActions = actions.get((Object)installPhase);
            if (installActions == null) continue;
            for (InstallAction installAction : installActions) {
                if (installAction.isActionRequired(installPhase)) {
                    Reporting.report((String)(">>> Install action \"" + installAction.getDisplayName() + "\" starting..."));
                    InstallActionResult result = this.executeInstallAction(installAction);
                    if (result.isFailure()) {
                        _log.log(Level.SEVERE, "A failure occurred while running \"" + installAction.getName() + "\" install action.  Message: " + result.getMessage(), result.getCause());
                        Reporting.report((String)("<<< Install action \"" + installAction.getDisplayName() + "\" failed..."));
                        throw new InstallActionException("The install action \"" + installAction.getName() + "\" failed with message " + result.getMessage(), result.getCause());
                    }
                    if (result.isWarning()) {
                        _log.log(Level.WARNING, "A warning occurred while running \"" + installAction.getName() + "\" install action.  Message: " + result.getMessage(), result.getCause());
                        Reporting.report((String)("<<< Install action \"" + installAction.getDisplayName() + "\" completed with warning..."));
                        continue;
                    }
                    _log.log(Level.INFO, "A success occurred while running \"" + installAction.getName() + "\" install action.  Message: " + result.getMessage(), result.getCause());
                    Reporting.report((String)("<<< Install action \"" + installAction.getDisplayName() + "\" completed successfully..."));
                    continue;
                }
                _log.info("Skipping install action \"" + installAction.getName() + "\" due to action not being required.");
            }
        }
    }

    private InstallActionResult executeInstallAction(InstallAction installAction) throws InstallActionException {
        if (installAction == null) {
            throw new InstallActionException("The install action provided was null.");
        }
        ProgressInfo progressInfo = installAction.init();
        InstallActionRunnerImpl runner = new InstallActionRunnerImpl(installAction);
        Thread thread = new Thread(runner);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return runner.getInstallActionResult();
    }
}

