/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.pack200;

import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.JarUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;

public class Pack200Engine {
    private static final Logger _log = Logger.getLogger(Pack200Engine.class.getName());
    public static final String EXTENSION = ".pack.gz";
    private static Pack200Engine _instance;
    private static String _effort;

    public static Pack200Engine getInstance() {
        if (_instance == null) {
            _instance = new Pack200Engine();
        }
        return _instance;
    }

    public static Map<String, String> getDefaultFlags() {
        HashMap<String, String> defaultFlags = new HashMap<String, String>();
        defaultFlags.put("pack.effort", Pack200Engine.getEffort());
        defaultFlags.put("pack.segment.limit", "-1");
        defaultFlags.put("pack.keep.file.order", "false");
        defaultFlags.put("pack.modification.time", "latest");
        defaultFlags.put("pack.deflate.hint", "true");
        defaultFlags.put("pack.code.attribute.SourceFile", "strip");
        defaultFlags.put("pack.unknown.attribute", "pass");
        return defaultFlags;
    }

    public File pack(File sourceFile) throws GdrException, IOException {
        return this.pack(sourceFile, null);
    }

    public File pack(File sourceFile, File destFile) throws GdrException, IOException {
        if (!JarUtils.isArchive((File)sourceFile)) {
            throw new GdrException("The file to pack is not an archive. File path: " + sourceFile.getPath());
        }
        if (destFile != null) {
            if (sourceFile.getPath().equals(destFile.getPath())) {
                throw new GdrException("Destination File can not be the same as source Jar. Source: " + sourceFile.getPath() + ", Dest: " + destFile.getPath());
            }
        } else {
            destFile = this.createTemporaryFile();
        }
        _log.finest("Packing file " + sourceFile.getPath() + " to " + destFile.getPath());
        JarFile jarFile = null;
        FileOutputStream fos = null;
        OutputStream os = null;
        Pack200.Packer packer = Pack200.newPacker();
        packer.properties().putAll(Pack200Engine.getDefaultFlags());
        try {
            jarFile = new JarFile(sourceFile);
            fos = new FileOutputStream(destFile);
            os = new GZIPOutputStream(fos);
            packer.pack(jarFile, os);
        }
        catch (IOException ioe) {
            Delete.delete((File)destFile);
            throw new GdrException("There was a problem packing file " + sourceFile.getPath(), (Throwable)ioe);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return destFile;
    }

    private File createTemporaryFile() throws GdrException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("jar", null);
        }
        catch (IOException e) {
            throw new GdrException("The temporary dest file could not be created.", (Throwable)e);
        }
        return tempFile;
    }

    public File unpack(File sourceFile) throws GdrException, IOException {
        return this.unpack(sourceFile, null);
    }

    public File unpack(File packedFile, File destFile) throws GdrException, IOException {
        if (destFile != null) {
            if (packedFile.getPath().equals(destFile.getPath())) {
                throw new GdrException("Destination File can not be the same as source Jar. Source: " + packedFile.getPath() + ", Dest: " + destFile.getPath());
            }
        } else {
            destFile = this.createTemporaryFile();
        }
        _log.fine("Unpacking file " + packedFile.getPath() + " to " + destFile.getPath());
        FileInputStream fis = null;
        GZIPInputStream is = null;
        FileOutputStream fos = null;
        ZipOutputStream jos = null;
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        unpacker.properties().putAll(Pack200Engine.getDefaultFlags());
        try {
            fis = new FileInputStream(packedFile);
            is = new GZIPInputStream(fis);
            fos = new FileOutputStream(destFile);
            jos = new JarOutputStream(fos);
            unpacker.unpack((InputStream)is, (JarOutputStream)jos);
        }
        catch (IOException ioe) {
            Delete.delete((File)destFile);
            throw new GdrException("There was a problem unpacking the file " + packedFile.getPath(), (Throwable)ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (jos != null) {
                try {
                    jos.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return destFile;
    }

    public static String getEffort() {
        return _effort;
    }

    public void setEffort(String effort) {
        if (!StringUtil.isNullOrEmpty((String)effort) && Integer.parseInt(effort) < 9 && Integer.parseInt(effort) > 1) {
            _effort = effort;
        } else {
            _log.finest("The value specified for Pack200 effort should be a number between 1 and 9. Using effort level 1.");
        }
    }

    static {
        _effort = "1";
    }
}

