/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.packaging;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.Version;
import com.oracle.cie.gdr.carbdiff.PatchArtifactDefinitionProcessor;
import com.oracle.cie.gdr.carbdiff.PatchDeployProcessor;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Bug;
import com.oracle.cie.gdr.dao.cpd.BugInfo;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.LabelMapHelper;
import com.oracle.cie.gdr.packaging.CommonPackager;
import com.oracle.cie.gdr.repository.RepositoryReleaseVersionResolver;
import com.oracle.cie.gdr.services.ComponentGroupIdService;
import com.oracle.cie.gdr.services.RepositoryService;
import com.oracle.cie.gdr.services.TopLevelDirectoryService;
import com.oracle.cie.gdr.services.VariableResolverService;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.rest.RestException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentArchivePackager
extends CommonPackager {
    private static final Logger _log = Logger.getLogger(ComponentArchivePackager.class.getName());
    private FeatureLoader _featureLoader;
    private ComponentLoader _componentLoader;

    public ComponentArchivePackager(File metaDataHome, Set<Integer> platforms, Set<Integer> locales, Map<String, String> variableMap) throws IOException, DataHandlerException, GdrException {
        this(metaDataHome, null, null, platforms, locales, variableMap, false);
    }

    public ComponentArchivePackager(File metaDataHome, Set<Reference> componentReferences, Set<Integer> platforms, Set<Integer> locales, Map<String, String> variableMap) throws IOException, DataHandlerException, GdrException {
        this(metaDataHome, null, componentReferences, platforms, locales, variableMap, false);
    }

    public ComponentArchivePackager(MetaDataHome metaDataHome, Set<Reference> componentReferences, Set<Integer> platforms, Set<Integer> locales, Map<String, String> variableMap) throws IOException, DataHandlerException, GdrException {
        this(metaDataHome, null, componentReferences, platforms, locales, variableMap, false);
    }

    public ComponentArchivePackager(File metaDataHome, Set<FeatureSetReference> featureRefs, Set<Reference> componentReferences, Set<Integer> platforms, Set<Integer> locales, Map<String, String> variableMap, boolean reuse) throws IOException, DataHandlerException, GdrException {
        this(new MetaDataHome(metaDataHome, false), featureRefs, componentReferences, platforms, locales, variableMap, reuse);
    }

    public ComponentArchivePackager(MetaDataHome metaDataHome, Set<FeatureSetReference> featureRefs, Set<Reference> componentReferences, Set<Integer> platforms, Set<Integer> locales, Map<String, String> variableMap, boolean reuse) throws IOException, DataHandlerException, GdrException {
        super(metaDataHome, platforms, locales, variableMap);
        this.init(featureRefs, componentReferences, reuse);
    }

    public FeatureLoader getFeatureLoader() {
        return this._featureLoader;
    }

    public ComponentLoader getComponentLoader() {
        return this._componentLoader;
    }

    protected void init(Set<FeatureSetReference> featureRefs, Set<Reference> componentReferences, boolean reuse) throws IOException, DataHandlerException, GdrException {
        if (!StringUtil.isNullOrEmpty((String)this._serviceHolder.getVariableResolverService().get("RELEASE_VERSION"))) {
            try {
                RepositoryReleaseVersionResolver.getInstance().configure(this._serviceHolder.getVariableResolverService().get("RELEASE_VERSION"), this._serviceHolder.getVariableResolverService().get("localRepo"), this._serviceHolder.getVariableResolverService().get("repoURL"));
            }
            catch (RepositoryCommonException | RestException e) {
                throw new GdrException(e);
            }
        }
        if (featureRefs == null && componentReferences == null) {
            File installDir = this.getMetaDataHome().getInstallDir();
            componentReferences = ComponentHelper.getInstance().findComponents(installDir, true, reuse);
            if (componentReferences == null || componentReferences.isEmpty()) {
                GdrException ex = new GdrException("Failed to package component archives because no component definitions were found under " + installDir);
                _log.throwing(ComponentArchivePackager.class.getName(), "init", ex);
                throw ex;
            }
        }
        if ((featureRefs == null || featureRefs.isEmpty()) && (componentReferences == null || componentReferences.isEmpty())) {
            GdrException ex = new GdrException("Failed to package component archives because no components or features were provided.");
            _log.throwing(ComponentArchivePackager.class.getName(), "init", ex);
            throw ex;
        }
        HashSet<FeatureSet> dummyFeature = null;
        if (componentReferences != null && !componentReferences.isEmpty()) {
            dummyFeature = new HashSet<FeatureSet>();
            dummyFeature.add(FeatureSetHelper.getInstance().createFeatureSet("ComponentArchiveFeature", "12.0.0.0.0", componentReferences));
        }
        this._featureLoader = new FeatureLoader(this.getMetaDataHome(), featureRefs, dummyFeature);
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Loaded " + this._featureLoader.getFeatureSets().size() + " feature sets.");
        }
        String tld = this.getMetaDataHome().getGdrMetaDataHomePath().getFileName().toString();
        String series = TopLevelDirectoryService.getSeriesFromTopLevelDirectory(tld);
        LabelMap labelMap = LabelMapHelper.getInstance().createLabelMap(series, tld, this._featureLoader.getComponentReferences());
        this._componentLoader = new ComponentLoader(this.getMetaDataHome(), this.getServiceHolder(), Mode.PACKAGE_COMPONENT, this._featureLoader.getFeatureSets(), null, labelMap);
        Set<Component> components = this._componentLoader.getComponents();
        ArrayList<String> failedComponents = new ArrayList<String>();
        for (Component component : components) {
            try {
                Collection<ComponentTarget> targets = component.getComponentTargets();
                for (ComponentTarget target : targets) {
                    if (target.getComponentFileMap().isExpanded()) continue;
                    target.getFileTargets();
                }
                if (!component.isCarb()) {
                    ComponentHelper.getInstance().expandLibrary(component);
                }
                if (StringUtil.isNullOrEmpty((String)component.getGroupId())) {
                    component.setGroupId(ComponentGroupIdService.getInstance().getGroupId(component.getName()));
                }
                component.setGdrVersion(Version.getVersion());
                if (StringUtil.isNullOrEmpty((String)this._serviceHolder.getVariableResolverService().get("BUG_LIST"))) continue;
                component.setBugInfo(this.generateBugInfo(this._serviceHolder.getVariableResolverService().get("BUG_LIST")));
            }
            catch (GdrException e) {
                _log.log(Level.SEVERE, "Error found while processing component " + component, e);
                failedComponents.add(component.getName() + ": " + ((Object)((Object)e)).getClass() + ": " + e.getMessage());
            }
        }
        if (!failedComponents.isEmpty()) {
            Iterator failures = failedComponents.iterator();
            StringBuilder message = new StringBuilder();
            message.append(failedComponents.size()).append(" Errors were found while processing components:");
            while (failures.hasNext()) {
                message.append(System.lineSeparator());
                String failure = (String)failures.next();
                message.append(failure);
            }
            throw new GdrException(message.toString());
        }
        FeatureSetHelper.getInstance().validateFeatureInclude(this._featureLoader.getFeatureSets(), this.getComponentLoader().getComponents());
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap() {
        return this.getComponentLoader().getComponentsMap();
    }

    @Override
    public void saveShiphomeMetadata(File dir) throws GdrException, DataHandlerException, IOException {
        Set<Component> comps = this.getComponents();
        ComponentHelper.getInstance().saveComponentsInShipHomeStructure(dir, true, comps);
        boolean validatePatchDeploy = true;
        if (!StringUtil.isNullOrEmpty((String)this._serviceHolder.getVariableResolverService().get("VALIDATE_PATCH_DEPLOY"))) {
            validatePatchDeploy = Boolean.valueOf(this._serviceHolder.getVariableResolverService().get("VALIDATE_PATCH_DEPLOY"));
        }
        this.savePatchDeploysInShipHomeStructure(dir, validatePatchDeploy, comps);
        PatchArtifactDefinitionProcessor.getInstance().processPatchArtifactDefinitions(dir, comps);
        if (comps != null && !comps.isEmpty()) {
            for (Component component : comps) {
                RepositoryService repositoryService;
                File compDir = ComponentHelper.getInstance().getComponentArchiveDir(dir, component.getName(), component.getVersion());
                if (!compDir.exists()) {
                    compDir.mkdirs();
                }
                if ((repositoryService = component.getRepositoryService()) == null) continue;
                repositoryService.saveConsumptionModule(component.getName(), component.getVersion(), compDir);
            }
            String consumedArtifactFilePath = VariableResolverService.getVariableResolverService().get("CONSUMED_ARTIFACT_FILE");
            if (!StringUtil.isNullOrEmpty((String)consumedArtifactFilePath, (boolean)true)) {
                RepositoryService.saveMergedConsumptionModule(comps, new File(consumedArtifactFilePath));
            }
        }
    }

    @Override
    public void updateInstallerInfo(File dir) throws DataHandlerException, IOException {
    }

    public void savePatchDeploysInShipHomeStructure(File dir, boolean validate, Collection<Component> comps) throws GdrException, IOException, DataHandlerException {
        if (!dir.exists() && !dir.mkdirs()) {
            GdrException ex = new GdrException("Directory specified did not exist and could not be created: " + dir);
            _log.throwing(ComponentHelper.class.getName(), "savePatchDeploysInShipHomeStructure", ex);
            throw ex;
        }
        if (!dir.isDirectory()) {
            GdrException ex = new GdrException("Directory specified was not a directory: " + dir);
            _log.throwing(ComponentHelper.class.getName(), "savePatchDeploysInShipHomeStructure", ex);
            throw ex;
        }
        if (comps != null && !comps.isEmpty()) {
            for (Component component : comps) {
                if (component.isCarb()) continue;
                component = component.copy();
                File patchDeploy = PatchDeployProcessor.getInstance().getSinglePatchDeploy(component, component.getComponentExtensions());
                File compDir = ComponentHelper.getInstance().getComponentArchiveDir(dir, component.getName(), component.getVersion());
                if (validate && patchDeploy != null) {
                    PatchDeployProcessor.getInstance().validatePatchDeploy(patchDeploy);
                }
                if (!compDir.exists()) {
                    compDir.mkdirs();
                }
                if (patchDeploy != null) {
                    _log.info("Patch deploy found is located in :" + patchDeploy.getAbsolutePath());
                    FileCopy.copy((File)patchDeploy, (File)new File(compDir, "patchDeploy.xml"));
                    continue;
                }
                _log.info("Patch deploy was not found in components.");
            }
        }
    }

    private BugInfo generateBugInfo(String bugList) {
        String[] bugIds = bugList.split(",");
        ArrayList<Bug> bugs = new ArrayList<Bug>();
        Bug bug = null;
        BugInfo bugInfo = new BugInfo();
        for (String bugId : bugIds) {
            bug = new Bug(bugId, "");
            bugs.add(bug);
        }
        bugInfo.setBugInfoList(bugs);
        return bugInfo;
    }
}

